/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.io.MonosaccharideImporter;
import org.eurocarbdb.resourcesdb.io.NameParsingException;
import org.eurocarbdb.resourcesdb.io.StandardImporter;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;
import org.eurocarbdb.resourcesdb.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BcsdbImporter
extends StandardImporter
implements MonosaccharideImporter {
    private BasetypeTemplate detectedSuperclass = null;
    private ArrayList<BasetypeTemplate> btList = new ArrayList();
    private Ringtype detectedRingtype = null;
    private String configurationSymbolsStr = "";

    public BcsdbImporter(Config confObj) {
        this((Config)null, (TemplateContainer)null);
    }

    public BcsdbImporter(Config confObj, TemplateContainer container) {
        super(GlycanNamescheme.BCSDB, confObj, container);
    }

    public BcsdbImporter() {
        this((Config)null, (TemplateContainer)null);
    }

    public BasetypeTemplate getDetectedSuperclass() {
        return this.detectedSuperclass;
    }

    public void setDetectedSuperclass(BasetypeTemplate detectedSuperclass) {
        this.detectedSuperclass = detectedSuperclass;
    }

    public ArrayList<BasetypeTemplate> getBtList() {
        return this.btList;
    }

    public void addBasetypeToBtList(BasetypeTemplate tmpl) {
        this.btList.add(tmpl);
    }

    public String getConfigurationSymbolsStr() {
        return this.configurationSymbolsStr;
    }

    private void setConfigurationSymbolsStr(String confSymbolsStr) {
        this.configurationSymbolsStr = confSymbolsStr;
    }

    private void addConfigurationSymbol(char confSym) {
        this.configurationSymbolsStr = this.configurationSymbolsStr + confSym;
    }

    public Ringtype getDetectedRingtype() {
        return this.detectedRingtype;
    }

    public void setDetectedRingtype(Ringtype detectedRingtype) {
        this.detectedRingtype = detectedRingtype;
    }

    @Override
    public Monosaccharide parseMsString(String name) throws ResourcesDbException {
        Monosaccharide ms = new Monosaccharide(this.getConfig(), this.getTemplateContainer());
        this.parseMsString(name, ms);
        return ms;
    }

    public void parseMsString(String name, Monosaccharide ms) throws ResourcesDbException {
        String trivName;
        if (ms == null) {
            throw new NameParsingException("BcsdbImporter.parseMsString(String, Monosaccharide): Monosaccharide must not be null.");
        }
        if (name == null) {
            throw new NameParsingException("BcsdbImporter.parseMsString(String, Monosaccharide): Name must not be null.");
        }
        if (name.length() == 0) {
            throw new NameParsingException("BcsdbImporter.parseMsString(String, Monosaccharide): Name must not be empty.");
        }
        ms.init();
        ms.setCheckPositionsOnTheFly(false);
        this.setInputName(name);
        this.setFoundMs(false);
        this.setParsingPosition(0);
        ArrayList<CoreModification> coreModList = new ArrayList<CoreModification>();
        BasetypeTemplate trivTmpl = null;
        BasetypeTemplate btTmpl = null;
        Anomer anomer = Anomer.forBcsdbSymbol(this.getCurrentToken());
        if (anomer == null) {
            if (!BcsdbImporter.isBcsdbConfigSymbol(this.getCurrentToken())) {
                throw new NameParsingException("illegal anomer symbol: '" + this.getCurrentToken() + "'", name, 0);
            }
        } else {
            ms.setAnomer(anomer);
            this.increaseParsingPosition();
        }
        while (BcsdbImporter.isBcsdbConfigSymbol(this.getCurrentToken()) && (name.length() - this.getParsingPosition() < 3 || this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(name.substring(this.getParsingPosition(), this.getParsingPosition() + 3)) == null)) {
            trivName = this.checkForTrivialname();
            if (trivName != null) {
                trivTmpl = this.getTemplateContainer().getTrivialnameTemplateContainer().forBasetypeName(this.getNamescheme(), trivName);
                this.increaseParsingPosition(trivName.length());
                break;
            }
            this.addConfigurationSymbol(this.getCurrentToken());
            this.increaseParsingPosition();
        }
        if (trivTmpl == null) {
            while (Character.isDigit(this.getCurrentToken())) {
                trivName = this.checkForTrivialname();
                if (trivName != null) {
                    trivTmpl = this.getTemplateContainer().getTrivialnameTemplateContainer().forBasetypeName(this.getNamescheme(), trivName);
                    this.increaseParsingPosition(trivName.length());
                    break;
                }
                ArrayList<Integer> modPosList = new ArrayList<Integer>();
                int pos = this.parseIntNumber();
                modPosList.add(pos);
                while (this.getCurrentToken() == ',') {
                    this.increaseParsingPosition();
                    pos = this.parseIntNumber();
                    modPosList.add(pos);
                }
                String deoxyName = CoreModificationTemplate.DEOXY.getBcsdbName();
                String anhydroName = CoreModificationTemplate.ANHYDRO.getBcsdbName();
                if (this.getCurrentSubstring(deoxyName.length()).equals(deoxyName)) {
                    for (Integer dPos : modPosList) {
                        CoreModification mod = new CoreModification(CoreModificationTemplate.DEOXY, dPos);
                        coreModList.add(mod);
                    }
                    this.increaseParsingPosition();
                    continue;
                }
                if (this.getCurrentSubstring(anhydroName.length()).equals(anhydroName)) {
                    if (modPosList.size() != 2) {
                        throw new NameParsingException("anhydro modification requires two positions", this.getInputName(), this.getParsingPosition());
                    }
                    CoreModification mod = new CoreModification(CoreModificationTemplate.ANHYDRO, (Integer)modPosList.get(0), (Integer)modPosList.get(1));
                    coreModList.add(mod);
                    this.increaseParsingPosition(3);
                    continue;
                }
                throw new NameParsingException("invalid modification name", this.getInputName(), this.getParsingPosition());
            }
            if ((trivName = this.checkForTrivialname()) != null) {
                trivTmpl = this.getTemplateContainer().getTrivialnameTemplateContainer().forBasetypeName(this.getNamescheme(), trivName);
                this.increaseParsingPosition(trivName.length());
            }
        }
        if (trivTmpl == null) {
            String btName = this.getCurrentSubstring(3);
            if (btName.equalsIgnoreCase("thr")) {
                btName = "tro";
            }
            if ((btTmpl = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(btName)) == null) {
                throw new NameParsingException("basetype name expected", this.getInputName(), this.getParsingPosition());
            }
            if (btTmpl.isSuperclass().booleanValue()) {
                if (this.getDetectedSuperclass() != null) {
                    throw new NameParsingException("multiple basetype superclasses found", this.getInputName(), this.getParsingPosition());
                }
            } else {
                this.addBasetypeToBtList(btTmpl);
            }
            this.increaseParsingPosition(3);
            while (this.countRemainingTokens() >= 3) {
                btName = this.getCurrentSubstring(3);
                if (btName.equalsIgnoreCase("thr")) {
                    btName = "tro";
                }
                if ((btTmpl = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(btName)) == null) break;
                if (btTmpl.isSuperclass().booleanValue()) {
                    if (this.getDetectedSuperclass() != null) {
                        throw new NameParsingException("multiple basetype superclasses found", this.getInputName(), this.getParsingPosition());
                    }
                    this.setDetectedSuperclass(btTmpl);
                } else {
                    this.addBasetypeToBtList(btTmpl);
                }
                this.increaseParsingPosition(3);
            }
            if (this.getDetectedSuperclass() != null) {
                ms.setSize(this.getDetectedSuperclass().getSize());
            } else if (this.getBtList().size() == 1) {
                ms.setSize(this.getBtList().get(0).getSize());
            }
        } else {
            ms.setSize(trivTmpl.getSize());
            this.setDetectedTrivialname((TrivialnameTemplate)trivTmpl);
        }
        if (this.hasCurrentToken() && BcsdbImporter.isBcsdbRingtypeSymbol(this.getCurrentToken())) {
            this.setDetectedRingtype(Ringtype.forBcsdbSymbol(String.valueOf(this.getCurrentToken())));
            this.increaseParsingPosition();
        }
        for (CoreModification mod : coreModList) {
            ms.addCoreModification(mod);
        }
        this.parseModifications(ms);
        this.processParsedData(ms);
    }

    private void parseModifications(Monosaccharide ms) throws ResourcesDbException {
        while (this.hasCurrentToken()) {
            CoreModification mod;
            if (this.getCurrentToken() == '-') {
                this.increaseParsingPosition();
            }
            ArrayList<Integer> digitList = null;
            if (Character.isDigit(this.getCurrentToken())) {
                digitList = this.parseIntNumberList();
                if (this.getCurrentToken() == '-') {
                    this.increaseParsingPosition();
                }
            }
            if (this.hasCurrentSubstring("en")) {
                if (digitList == null) {
                    throw new NameParsingException("number expected", this.getInputName(), this.getParsingPosition());
                }
                for (Integer pos1 : digitList) {
                    mod = new CoreModification(CoreModificationTemplate.EN, pos1, pos1 + 1);
                    ms.addCoreModification(mod);
                }
                this.increaseParsingPosition(2);
                continue;
            }
            if (this.hasCurrentSubstring("ulo")) {
                if (digitList == null) {
                    digitList = new ArrayList();
                    digitList.add(2);
                }
                for (Integer pos1 : digitList) {
                    mod = new CoreModification(CoreModificationTemplate.KETO, pos1);
                    ms.addCoreModification(mod);
                }
                this.increaseParsingPosition(3);
                if (this.hasCurrentSubstring("sonic")) {
                    ms.setAldonic();
                    this.increaseParsingPosition(5);
                    continue;
                }
                if (!this.hasCurrentSubstring("saric")) continue;
                ms.setAldaric();
                this.increaseParsingPosition(5);
                continue;
            }
            if (this.hasCurrentSubstring("onic")) {
                if (digitList != null) {
                    throw new NameParsingException("Cannot assign given position to 'onic' modification", this.getInputName(), this.getParsingPosition());
                }
                ms.setAldonic();
                this.increaseParsingPosition(4);
                continue;
            }
            if (this.hasCurrentSubstring("aric")) {
                if (digitList != null) {
                    throw new NameParsingException("Cannot assign given position to 'aric' modification", this.getInputName(), this.getParsingPosition());
                }
                ms.setAldaric();
                this.increaseParsingPosition(4);
                continue;
            }
            String matchedSubstName = "";
            for (String substName : this.getTemplateContainer().getSubstituentTemplateContainer().getResidueIncludedNameList(this.getNamescheme())) {
                if (!this.hasCurrentSubstring(substName) || substName.length() <= matchedSubstName.length()) continue;
                matchedSubstName = substName;
            }
            if (matchedSubstName.length() > 0) {
                if (digitList == null) {
                    digitList = new ArrayList();
                    digitList.add(2);
                }
                this.addParsedSubstitution(ms, matchedSubstName, digitList);
                this.increaseParsingPosition(matchedSubstName.length());
                continue;
            }
            if (this.getCurrentToken() == 'A') {
                if (digitList != null) {
                    throw new NameParsingException("Cannot assign given position to 'A' modification", this.getInputName(), this.getParsingPosition());
                }
                ms.setUronic();
                this.increaseParsingPosition();
                continue;
            }
            if (this.hasCurrentSubstring("ol")) {
                if (digitList != null) {
                    throw new NameParsingException("Cannot assign given position to 'ol' modification", this.getInputName(), this.getParsingPosition());
                }
                ms.setAlditol(true);
                this.increaseParsingPosition(2);
                continue;
            }
            throw new NameParsingException("cannot parse substring '" + this.getInputName().substring(this.getParsingPosition()) + "'", this.getInputName(), this.getParsingPosition());
        }
    }

    private void processParsedData(Monosaccharide ms) throws ResourcesDbException {
        String stereo;
        boolean expandChiralonly = false;
        if (this.getDetectedTrivialname() != null) {
            ms.init(this.getDetectedTrivialname());
            stereo = this.getDetectedTrivialname().getStereocode();
            if (this.getDetectedTrivialname().isDefaultConfigIsCompulsory()) {
                if (!(this.getConfigurationSymbolsStr().equals(String.valueOf(StereoConfiguration.Nonchiral.getBcsdbSymbol())) || this.getConfigurationSymbolsStr().equals(String.valueOf(this.getDetectedTrivialname().getDefaultConfiguration().getBcsdbSymbol())) || this.getConfigurationSymbolsStr().equals(""))) {
                    throw new NameParsingException("trivial name " + this.getDetectedTrivialname().getLongName() + " requires absolute configuration " + StereoConfiguration.Nonchiral.getBcsdbSymbol());
                }
                if (this.getDetectedTrivialname().getDefaultConfiguration().equals((Object)StereoConfiguration.Laevus)) {
                    stereo = Stereocode.changeDLinStereoString(stereo);
                }
            } else if (this.getConfigurationSymbolsStr().equals(String.valueOf(StereoConfiguration.Unknown.getBcsdbSymbol()))) {
                stereo = Stereocode.absoluteToRelative(stereo);
            } else if (this.getConfigurationSymbolsStr().equals(String.valueOf(StereoConfiguration.Laevus.getBcsdbSymbol()))) {
                stereo = Stereocode.changeDLinStereoString(stereo);
            }
            ms.setDefaultCarbonylPosition(this.getDetectedTrivialname().getCarbonylPosition());
            this.setTmpStereocode(stereo);
        } else {
            if (this.getDetectedSuperclass() == null) {
                if (this.getBtList().size() > 1) {
                    throw new NameParsingException("multiple basetypes but no superclass found", this.getInputName(), 0);
                }
                if (this.getBtList().size() == 0) {
                    throw new NameParsingException("no monosaccharide basetype detected", this.getInputName(), 0);
                }
                ms.setSize(this.getBtList().get(0).getSize());
                stereo = this.getBtList().get(0).getStereocode();
                if (this.getConfigurationSymbolsStr().length() == 0 || this.getConfigurationSymbolsStr().equals(String.valueOf(StereoConfiguration.Unknown.getBcsdbSymbol()))) {
                    stereo = Stereocode.absoluteToRelative(stereo);
                } else if (this.getConfigurationSymbolsStr().equals(String.valueOf(StereoConfiguration.Laevus.getBcsdbSymbol()))) {
                    stereo = Stereocode.changeDLinStereoString(stereo);
                } else if (!this.getConfigurationSymbolsStr().equals(String.valueOf(StereoConfiguration.Dexter.getBcsdbSymbol()))) {
                    throw new NameParsingException("cannot apply stereoconfiguration " + this.getConfigurationSymbolsStr() + " to basetype " + this.getBtList().get(0).getBaseName());
                }
                this.setTmpStereocode(stereo);
            } else {
                expandChiralonly = true;
                ms.setSize(this.getDetectedSuperclass().getSize());
                stereo = "";
                if (this.getConfigurationSymbolsStr().length() > 2 && this.getConfigurationSymbolsStr().charAt(0) == StereoConfiguration.Nonchiral.getBcsdbSymbol()) {
                    this.setConfigurationSymbolsStr(this.getConfigurationSymbolsStr().substring(1));
                }
                if (this.getBtList().size() == 0) {
                    stereo = StringUtils.multiplyChar(StereoConfiguration.Unknown.getStereosymbol(), ms.getSize() - 2);
                    expandChiralonly = false;
                } else {
                    if (this.getConfigurationSymbolsStr().length() == this.getBtList().size() + 1) {
                        stereo = stereo + StereoConfiguration.forBcsdbSymbol(this.getConfigurationSymbolsStr().charAt(0)).getStereosymbol();
                        this.setConfigurationSymbolsStr(this.getConfigurationSymbolsStr().substring(1));
                    }
                    if (this.getConfigurationSymbolsStr().length() != this.getBtList().size()) {
                        throw new NameParsingException("number of configuration symbols does not match number of basetypes", this.getInputName(), 0);
                    }
                    for (int i = 0; i < this.getBtList().size(); ++i) {
                        String tmpStereo = this.getBtList().get(i).getStereocode();
                        if (this.getConfigurationSymbolsStr().charAt(i) == StereoConfiguration.Laevus.getBcsdbSymbol()) {
                            tmpStereo = Stereocode.changeDLinStereoString(tmpStereo);
                        } else if (this.getConfigurationSymbolsStr().charAt(i) == StereoConfiguration.Unknown.getBcsdbSymbol()) {
                            tmpStereo = Stereocode.absoluteToRelative(tmpStereo);
                        }
                        stereo = tmpStereo + stereo;
                    }
                    this.setTmpStereocode(stereo);
                }
            }
            ArrayList<CoreModification> ketoList = ms.getCoreModifications(CoreModificationTemplate.KETO);
            if (ketoList != null && ketoList.size() > 0) {
                for (CoreModification mod : ketoList) {
                    if (mod.getIntValuePosition1() <= 0) continue;
                    if (ms.getDefaultCarbonylPosition() == 0) {
                        ms.setDefaultCarbonylPosition(mod.getIntValuePosition1());
                        continue;
                    }
                    if (mod.getIntValuePosition1() >= ms.getDefaultCarbonylPosition()) continue;
                    ms.setDefaultCarbonylPosition(mod.getIntValuePosition1());
                }
            } else {
                ms.setDefaultCarbonylPosition(1);
            }
        }
        if (ms.getRingStart() == 0) {
            if (ms.isAlditol()) {
                ms.setRingStart(-1);
            } else {
                ms.setRingStart(ms.getDefaultCarbonylPosition());
            }
        }
        if (this.getDetectedRingtype() != null) {
            if (ms.isAlditol()) {
                if (this.getDetectedRingtype().equals((Object)Ringtype.PYRANOSE) || this.getDetectedRingtype().equals((Object)Ringtype.FURANOSE)) {
                    throw new MonosaccharideException("Ringtype " + this.getDetectedRingtype().getName() + " is not allowed together with alditol modification.");
                }
            } else {
                ms.setRingtype(this.getDetectedRingtype());
            }
        }
        if (!Anomer.ALPHA.equals((Object)ms.getAnomer()) && !Anomer.BETA.equals((Object)ms.getAnomer())) {
            if (ms.getRingStart() > 0) {
                if (ms.isStereolossPositionWithIgnoreType(ms.getRingStart(), CoreModificationTemplate.KETO)) {
                    ms.setAnomer(Anomer.NONE);
                } else {
                    ms.setAnomer(Anomer.UNKNOWN);
                }
            } else if (ms.getRingStart() == -1) {
                ms.setAnomer(Anomer.OPEN_CHAIN);
            } else {
                ms.setAnomer(Anomer.UNKNOWN);
            }
        }
        stereo = this.getTmpStereocode();
        if (expandChiralonly) {
            stereo = Stereocode.expandChiralonlyStereoString(stereo, ms);
        } else {
            stereo = StereoConfiguration.Nonchiral.getStereosymbol() + this.getTmpStereocode() + StereoConfiguration.Nonchiral.getStereosymbol();
            stereo = Stereocode.markNonchiralPositionsInStereoString(stereo, ms);
        }
        ms.setStereoStr(stereo);
        ms.setAnomerInStereocode();
        MonosaccharideValidation.checkMonosaccharideConsistency(ms, this.getTemplateContainer(), this.getConfig());
        ms.buildName();
    }

    public static boolean isBcsdbConfigSymbol(char symbol) {
        return StereoConfiguration.forBcsdbSymbol(symbol) != null;
    }

    public static boolean isBcsdbRingtypeSymbol(char symbol) {
        return Ringtype.forBcsdbSymbol(String.valueOf(symbol)) != null;
    }

    @Override
    public void init() {
        super.init();
        this.setDetectedRingtype(null);
        this.setDetectedSuperclass(null);
        this.setConfigurationSymbolsStr("");
        this.btList.clear();
    }
}

