/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.PeakData;
import org.eurocarbdb.application.glycoworkbench.SpectraDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportOptions;
import org.jdesktop.layout.GroupLayout;

public class AnnotationReportChoiceDialog
extends EscapeDialog
implements ActionListener {
    private GlycanWorkspace theWorkspace;
    private AnnotatedPeakList theAnnotations;
    private SpectraDocument theSpectra;
    private GlycanRenderer theGlycanRenderer;
    private AnnotationReportOptions theOptions;
    private double return_start_mz;
    private double return_end_mz;
    private Glycan return_parent;
    private PeakAnnotationCollection return_pac;
    private PeakData return_pd;
    private JButton button_cancel;
    private JButton button_ok;
    private JTextField field_end_mz;
    private JCheckBox field_show_empty_ann;
    private JCheckBox field_show_max_int;
    private JCheckBox field_show_raw_spectrum;
    private JCheckBox field_show_complete_peak_list;
    private JCheckBox field_show_rel_int;
    private JList field_spectra_list;
    private JTextField field_start_mz;
    private JList field_structures_list;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;

    public AnnotationReportChoiceDialog(Frame parent, GlycanWorkspace workspace, AnnotationReportOptions opt) {
        super(parent, true);
        this.theWorkspace = workspace;
        this.theAnnotations = this.theWorkspace.getAnnotatedPeakList();
        this.theSpectra = this.theWorkspace.getSpectra();
        this.theGlycanRenderer = this.theWorkspace.getGlycanRenderer();
        this.theOptions = opt;
        this.initComponents();
        this.setTraversal();
        this.setData();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    public Double getStartMZ() {
        return this.return_start_mz;
    }

    public Double getEndMZ() {
        return this.return_end_mz;
    }

    public Glycan getParentStructure() {
        return this.return_parent;
    }

    public PeakAnnotationCollection getPeakAnnotationCollection() {
        return this.return_pac;
    }

    public PeakData getPeakData() {
        return this.return_pd;
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_start_mz);
        tp.addComponent((Component)this.field_end_mz);
        tp.addComponent((Component)this.field_structures_list);
        tp.addComponent((Component)this.field_spectra_list);
        tp.addComponent((Component)this.field_show_raw_spectrum);
        tp.addComponent((Component)this.field_show_rel_int);
        tp.addComponent((Component)this.field_show_empty_ann);
        tp.addComponent((Component)this.field_show_max_int);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setData() {
        this.field_start_mz.setText("");
        this.field_end_mz.setText("");
        this.field_structures_list.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Glycan s = (Glycan)value;
                if (s == null) {
                    this.setIcon(null);
                    this.setText("null");
                } else if (s.isEmpty()) {
                    this.setIcon(null);
                    this.setText("profile " + (index + 1));
                } else {
                    this.setIcon(new ImageIcon(AnnotationReportChoiceDialog.this.theGlycanRenderer.getImage((Glycan)value, false, false, true, 0.333)));
                    this.setText("");
                }
                return this;
            }
        });
        this.field_structures_list.setListData(this.theAnnotations.getStructures());
        this.field_structures_list.setSelectionMode(0);
        if (this.theAnnotations.size() > 0) {
            this.field_structures_list.setSelectedIndex(0);
        }
        this.field_spectra_list.setListData(this.theSpectra.getScans());
        this.field_spectra_list.setSelectionMode(0);
        if (this.theSpectra.size() > 0) {
            this.field_spectra_list.setSelectedIndex(0);
        }
        if (this.theSpectra.size() > 0) {
            this.field_show_raw_spectrum.setSelected(this.theOptions.SHOW_RAW_SPECTRUM);
        }
        this.field_show_complete_peak_list.setSelected(this.theOptions.SHOW_COMPLETE_PEAK_LIST);
        this.field_show_rel_int.setSelected(this.theOptions.SHOW_RELATIVE_INTENSITIES);
        this.field_show_empty_ann.setSelected(this.theOptions.SHOW_EMPTY_ANNOTATIONS);
        this.field_show_max_int.setSelected(this.theOptions.SHOW_MAX_INTENSITY);
        this.pack();
    }

    private void setActions() {
        this.field_show_raw_spectrum.addActionListener(this);
        this.field_show_rel_int.addActionListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
        this.field_spectra_list.setEnabled(this.theSpectra.size() > 0 && this.field_show_raw_spectrum.isSelected());
        this.field_show_raw_spectrum.setEnabled(this.theSpectra.size() > 0);
        this.field_show_max_int.setEnabled(this.field_show_rel_int.isSelected());
        if (this.field_show_raw_spectrum.isEnabled()) {
            this.field_show_raw_spectrum.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    if (AnnotationReportChoiceDialog.this.field_show_raw_spectrum.isSelected()) {
                        AnnotationReportChoiceDialog.this.field_show_complete_peak_list.setSelected(false);
                        AnnotationReportChoiceDialog.this.field_show_complete_peak_list.setEnabled(false);
                    } else {
                        AnnotationReportChoiceDialog.this.field_show_complete_peak_list.setEnabled(true);
                    }
                }
            });
            this.field_show_complete_peak_list.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (AnnotationReportChoiceDialog.this.field_show_complete_peak_list.isSelected()) {
                        AnnotationReportChoiceDialog.this.field_show_raw_spectrum.setSelected(false);
                        AnnotationReportChoiceDialog.this.field_show_raw_spectrum.setEnabled(false);
                    } else {
                        AnnotationReportChoiceDialog.this.field_show_raw_spectrum.setEnabled(true);
                    }
                }
            });
        }
    }

    private void retrieveData() {
        try {
            this.return_start_mz = Double.valueOf(this.field_start_mz.getText());
            this.return_end_mz = Double.valueOf(this.field_end_mz.getText());
        }
        catch (Exception e) {
            this.return_end_mz = 0.0;
            this.return_start_mz = 0.0;
        }
        if (this.field_structures_list.getSelectedIndex() >= 0) {
            this.return_parent = this.theAnnotations.getStructure(this.field_structures_list.getSelectedIndex());
            this.return_pac = this.theAnnotations.getPeakAnnotationCollection(this.field_structures_list.getSelectedIndex());
        } else if (this.theAnnotations.size() > 0) {
            this.return_parent = this.theAnnotations.getStructure(0);
            this.return_pac = this.theAnnotations.getPeakAnnotationCollection(0);
        } else {
            this.return_parent = null;
            this.return_pac = null;
        }
        this.return_pd = this.field_spectra_list.getSelectedIndex() >= 0 ? this.theSpectra.getPeakDataAt(this.field_spectra_list.getSelectedIndex()) : (this.theSpectra.size() > 0 ? this.theSpectra.getPeakDataAt(0) : null);
        this.theOptions.SHOW_RAW_SPECTRUM = this.field_show_raw_spectrum.isSelected();
        this.theOptions.SHOW_COMPLETE_PEAK_LIST = this.field_show_complete_peak_list.isSelected();
        this.theOptions.SHOW_RELATIVE_INTENSITIES = this.field_show_rel_int.isSelected();
        this.theOptions.SHOW_EMPTY_ANNOTATIONS = this.field_show_empty_ann.isSelected();
        this.theOptions.SHOW_MAX_INTENSITY = this.field_show_max_int.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.return_status = action;
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        } else {
            this.enableItems();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.field_start_mz = new JTextField();
        this.jLabel2 = new JLabel();
        this.field_end_mz = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.field_structures_list = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.field_spectra_list = new JList();
        this.field_show_rel_int = new JCheckBox();
        this.field_show_raw_spectrum = new JCheckBox();
        this.field_show_complete_peak_list = new JCheckBox();
        this.field_show_empty_ann = new JCheckBox();
        this.field_show_max_int = new JCheckBox();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AnnotationReportChoiceDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Start m/z");
        this.field_start_mz.setText("jTextField1");
        this.jLabel2.setText("End m/z");
        this.field_end_mz.setText("jTextField2");
        this.jLabel3.setText("Choose a structure");
        this.jLabel4.setText("Choose a spectrum");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.field_structures_list.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.field_structures_list);
        this.field_spectra_list.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.field_spectra_list);
        this.field_show_rel_int.setText("Show relative intensities");
        this.field_show_rel_int.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_show_raw_spectrum.setText("Show raw spectrum");
        this.field_show_raw_spectrum.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_show_complete_peak_list.setText("Show complete peak list");
        this.field_show_complete_peak_list.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_show_empty_ann.setText("Show empty annotations");
        this.field_show_empty_ann.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_show_max_int.setText("Show max intensity");
        this.field_show_max_int.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 286, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jScrollPane2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.field_start_mz, -2, 69, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.field_end_mz, -1, 69, Short.MAX_VALUE)).add((Component)this.jLabel3).add((Component)this.jLabel4)).add((Component)this.field_show_rel_int).add((Component)this.field_show_raw_spectrum).add((Component)this.field_show_complete_peak_list).add((Component)this.field_show_empty_ann))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -1, 286, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.field_show_max_int)).add((GroupLayout.Group)layout.createSequentialGroup().add(96, 96, 96).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_start_mz, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.field_end_mz, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 100, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 100, -2).addPreferredGap(0).add((Component)this.field_show_raw_spectrum).addPreferredGap(0).add((Component)this.field_show_complete_peak_list).addPreferredGap(0).add((Component)this.field_show_rel_int).addPreferredGap(0).add((Component)this.field_show_empty_ann).addPreferredGap(0).add((Component)this.field_show_max_int).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

