/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.text.DecimalFormat;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.proteomecommons.io.PeakList;
import org.proteomecommons.io.mzxml.v2_0.MzXMLPeakList;
import org.systemsbiology.jrap.Scan;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ScanData
implements SAXUtils.SAXWriter {
    protected int num = 0;
    protected Integer parent_num = null;
    protected Integer ms_level = null;
    protected Double precursor_mz = null;
    protected Integer precursor_charge = null;
    protected Boolean positive_mode = null;
    protected Boolean centroided = null;
    protected Boolean deisotoped = null;
    protected Boolean charge_deconvoluted = null;
    protected Double retention_time = null;
    protected Double base_peak_mz = null;
    protected Double base_peak_intensity = null;
    protected Double start_mz = null;
    protected Double end_mz = null;
    protected Double low_mz = null;
    protected Double high_mz = null;
    protected Double total_ion_current = null;

    public ScanData() {
    }

    public ScanData(int _num) {
        this.num = _num;
        this.ms_level = 1;
        this.precursor_mz = 0.0;
        this.precursor_charge = 0;
        this.parent_num = 0;
    }

    public ScanData(Scan s) {
        this.num = s.getNum();
        this.ms_level = s.getMsLevel();
        this.precursor_mz = s.getPrecursorMz();
        this.precursor_charge = s.getPrecursorCharge();
        this.parent_num = s.getPrecursorScanNum();
        this.positive_mode = s.getPolarity() != null ? Boolean.valueOf(s.getPolarity().equals("+")) : null;
        this.centroided = s.getCentroided() == 1;
        this.charge_deconvoluted = s.getChargeDeconvoluted() == 1;
        this.deisotoped = s.getDeisotoped() == 1;
        this.retention_time = s.getRetentionTime() != null ? Double.valueOf(s.getDoubleRetentionTime()) : null;
        this.base_peak_intensity = s.getBasePeakIntensity();
        this.base_peak_mz = s.getBasePeakMz();
        this.start_mz = s.getStartMz();
        this.end_mz = s.getEndMz();
        this.low_mz = s.getLowMz();
        this.high_mz = s.getHighMz();
        this.total_ion_current = s.getTotIonCurrent();
    }

    public ScanData(int _num, PeakList p) {
        this.num = _num;
        this.ms_level = p.getTandemCount();
        this.precursor_mz = p.getParentPeak() != null ? Double.valueOf(p.getParentPeak().getMassOverCharge()) : null;
        Integer n = this.precursor_charge = p.getParentPeak() != null ? Integer.valueOf(p.getParentPeak().getCharge()) : null;
        if (p instanceof org.proteomecommons.io.mzxml.v2_1.MzXMLPeakList) {
            org.proteomecommons.io.mzxml.v2_1.MzXMLPeakList s = (org.proteomecommons.io.mzxml.v2_1.MzXMLPeakList)p;
            this.num = s.getNum() != null ? Integer.valueOf(s.getNum()) : _num;
            this.parent_num = s.getPrecursorScanNum() != null ? Integer.valueOf(s.getPrecursorScanNum()) : -1;
            this.positive_mode = s.getPolarity() != null ? Boolean.valueOf(s.getPolarity().equals("+")) : null;
            this.centroided = s.getCentroided() != null ? Boolean.valueOf(s.getCentroided().equals("1")) : null;
            this.charge_deconvoluted = s.getChargeDeconvoluted() != null ? Boolean.valueOf(s.getChargeDeconvoluted().equals("1")) : null;
            this.deisotoped = s.getDeisotoped() != null ? Boolean.valueOf(s.getDeisotoped().equals("1")) : null;
            this.retention_time = s.getRetentionTime() != null ? Double.valueOf(s.getRetentionTime()) : null;
            this.base_peak_intensity = s.getBasePeakIntensity() != null ? Double.valueOf(s.getBasePeakIntensity()) : null;
            this.base_peak_mz = s.getBasePeakMz() != null ? Double.valueOf(s.getBasePeakMz()) : null;
            this.start_mz = s.getStartMz() != null ? Double.valueOf(s.getStartMz()) : null;
            this.end_mz = s.getEndMz() != null ? Double.valueOf(s.getEndMz()) : null;
            this.low_mz = s.getLowMz() != null ? Double.valueOf(s.getLowMz()) : null;
            this.high_mz = s.getHighMz() != null ? Double.valueOf(s.getHighMz()) : null;
            this.total_ion_current = s.getTotIonCurrent() != null ? Double.valueOf(s.getTotIonCurrent()) : null;
        } else if (p instanceof MzXMLPeakList) {
            MzXMLPeakList s = (MzXMLPeakList)p;
            this.num = s.getNum() != null ? Integer.valueOf(s.getNum()) : _num;
            this.parent_num = s.getPrecursorScanNum() != null ? Integer.valueOf(s.getPrecursorScanNum()) : -1;
            this.positive_mode = s.getPolarity() != null ? Boolean.valueOf(s.getPolarity().equals("+")) : null;
            this.centroided = s.getCentroided() != null ? Boolean.valueOf(s.getCentroided().equals("1")) : null;
            this.charge_deconvoluted = s.getChargeDeconvoluted() != null ? Boolean.valueOf(s.getChargeDeconvoluted().equals("1")) : null;
            this.deisotoped = s.getDeisotoped() != null ? Boolean.valueOf(s.getDeisotoped().equals("1")) : null;
            this.retention_time = s.getRetentionTime() != null ? Double.valueOf(s.getRetentionTime()) : null;
            this.base_peak_intensity = s.getBasePeakIntensity() != null ? Double.valueOf(s.getBasePeakIntensity()) : null;
            this.base_peak_mz = s.getBasePeakMz() != null ? Double.valueOf(s.getBasePeakMz()) : null;
            this.start_mz = s.getStartMz() != null ? Double.valueOf(s.getStartMz()) : null;
            this.end_mz = s.getEndMz() != null ? Double.valueOf(s.getEndMz()) : null;
            this.low_mz = s.getLowMz() != null ? Double.valueOf(s.getLowMz()) : null;
            this.high_mz = s.getHighMz() != null ? Double.valueOf(s.getHighMz()) : null;
            this.total_ion_current = s.getTotIonCurrent() != null ? Double.valueOf(s.getTotIonCurrent()) : null;
        } else if (p instanceof org.proteomecommons.io.mzxml.v1_1_1.MzXMLPeakList) {
            org.proteomecommons.io.mzxml.v1_1_1.MzXMLPeakList s = (org.proteomecommons.io.mzxml.v1_1_1.MzXMLPeakList)p;
            this.num = s.getNum() != null ? Integer.valueOf(s.getNum()) : _num;
            this.parent_num = s.getPrecursorScanNum() != null ? Integer.valueOf(s.getPrecursorScanNum()) : -1;
            this.positive_mode = s.getPolarity() != null ? Boolean.valueOf(s.getPolarity().equals("+")) : null;
            this.centroided = s.getCentroided() != null ? Boolean.valueOf(s.getCentroided().equals("1")) : null;
            this.charge_deconvoluted = s.getChargeDeconvoluted() != null ? Boolean.valueOf(s.getChargeDeconvoluted().equals("1")) : null;
            this.deisotoped = s.getDeisotoped() != null ? Boolean.valueOf(s.getDeisotoped().equals("1")) : null;
            this.retention_time = s.getRetentionTime() != null ? Double.valueOf(s.getRetentionTime()) : null;
            this.base_peak_intensity = s.getBasePeakIntensity() != null ? Double.valueOf(s.getBasePeakIntensity()) : null;
            this.base_peak_mz = s.getBasePeakMz() != null ? Double.valueOf(s.getBasePeakMz()) : null;
            this.start_mz = s.getStartMz() != null ? Double.valueOf(s.getStartMz()) : null;
            this.end_mz = s.getEndMz() != null ? Double.valueOf(s.getEndMz()) : null;
            this.low_mz = s.getLowMz() != null ? Double.valueOf(s.getLowMz()) : null;
            this.high_mz = s.getHighMz() != null ? Double.valueOf(s.getHighMz()) : null;
            this.total_ion_current = s.getTotIonCurrent() != null ? Double.valueOf(s.getTotIonCurrent()) : null;
        }
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int n) {
        this.num = n;
    }

    public Integer getParentNum() {
        return this.parent_num;
    }

    public void setParentNum(Integer v) {
        this.parent_num = v;
    }

    public Integer getMSLevel() {
        return this.ms_level;
    }

    public void setMSLevel(Integer v) {
        this.ms_level = v;
    }

    public Double getPrecursorMZ() {
        return this.precursor_mz;
    }

    public void setPrecursorMZ(Double v) {
        this.precursor_mz = v;
    }

    public Integer getPrecursorCharge() {
        return this.precursor_charge;
    }

    public void setPrecursorCharge(Integer v) {
        this.precursor_charge = v;
    }

    public Boolean getPositiveMode() {
        return this.positive_mode;
    }

    public void setPositiveMode(Boolean v) {
        this.positive_mode = v;
    }

    public Boolean getCentroided() {
        return this.centroided;
    }

    public void setCentroided(Boolean v) {
        this.centroided = v;
    }

    public Boolean getDeisotoped() {
        return this.deisotoped;
    }

    public void setDeisotoped(Boolean v) {
        this.deisotoped = v;
    }

    public Boolean getChargeDeconvoluted() {
        return this.charge_deconvoluted;
    }

    public void setChargeDeconvoluted(Boolean v) {
        this.charge_deconvoluted = v;
    }

    public Double getRetentionTime() {
        return this.retention_time;
    }

    public void setRetentionTime(Double v) {
        this.retention_time = v;
    }

    public Double getBasePeakMZ() {
        return this.base_peak_mz;
    }

    public void setBasePeakMZ(Double v) {
        this.base_peak_mz = v;
    }

    public Double getBasePeakIntensity() {
        return this.base_peak_intensity;
    }

    public void setBasePeakIntensity(Double v) {
        this.base_peak_intensity = v;
    }

    public Double getStartMZ() {
        return this.start_mz;
    }

    public void setStartMZ(Double v) {
        this.start_mz = v;
    }

    public Double getEndMZ() {
        return this.end_mz;
    }

    public void setEndMZ(Double v) {
        this.end_mz = v;
    }

    public Double getLowMZ() {
        return this.low_mz;
    }

    public void setLowMZ(Double v) {
        this.low_mz = v;
    }

    public Double getHighMZ() {
        return this.high_mz;
    }

    public void setHighMZ(Double v) {
        this.high_mz = v;
    }

    public Double getTotalIonCurrent() {
        return this.total_ion_current;
    }

    public void setTotalIonCurrent(Double v) {
        this.total_ion_current = v;
    }

    public String toString() {
        String ret = "Scan " + this.num;
        if (this.ms_level == 1) {
            ret = ret + ", MS";
        } else if (this.ms_level == 2) {
            ret = ret + ", MS/MS";
        } else if (this.ms_level > 2) {
            ret = ret + ", MS" + this.ms_level;
        }
        if (this.ms_level > 1) {
            ret = ret + ", precursor= ";
            if (this.precursor_mz != null) {
                ret = ret + new DecimalFormat("0.0000").format(this.precursor_mz) + " Da";
            }
        }
        return ret;
    }

    public static ScanData fromXML(Node sd_node) throws Exception {
        if (sd_node == null) {
            throw new Exception("empty node");
        }
        ScanData ret = new ScanData();
        ret.num = XMLUtils.getIntegerAttribute((Node)sd_node, (String)"num");
        ret.parent_num = XMLUtils.getIntegerAttribute((Node)sd_node, (String)"parent_num");
        ret.ms_level = XMLUtils.getIntegerAttribute((Node)sd_node, (String)"ms_level");
        ret.precursor_mz = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"precursor_mz");
        if (ret.precursor_mz == null) {
            ret.precursor_mz = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"parent_mz");
        }
        ret.precursor_charge = XMLUtils.getIntegerAttribute((Node)sd_node, (String)"precursor_charge");
        ret.positive_mode = XMLUtils.getBooleanAttribute((Node)sd_node, (String)"positive_mode");
        ret.centroided = XMLUtils.getBooleanAttribute((Node)sd_node, (String)"centroided");
        ret.deisotoped = XMLUtils.getBooleanAttribute((Node)sd_node, (String)"deisotoped");
        ret.charge_deconvoluted = XMLUtils.getBooleanAttribute((Node)sd_node, (String)"charge_deconvoluted");
        ret.retention_time = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"retention_time");
        ret.base_peak_mz = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"base_peak_mz");
        ret.base_peak_intensity = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"base_peak_intensity");
        ret.start_mz = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"start_mz");
        ret.end_mz = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"end_mz");
        ret.low_mz = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"low_mz");
        ret.high_mz = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"high_mz");
        ret.total_ion_current = XMLUtils.getDoubleAttribute((Node)sd_node, (String)"total_ion_current");
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element sd_node = document.createElement("ScanData");
        sd_node.setAttribute("num", "" + this.num);
        if (this.parent_num != null) {
            sd_node.setAttribute("parent_num", "" + this.parent_num);
        }
        if (this.ms_level != null) {
            sd_node.setAttribute("ms_level", "" + this.ms_level);
        }
        if (this.precursor_mz != null) {
            sd_node.setAttribute("precursor_mz", "" + this.precursor_mz);
        }
        if (this.precursor_charge != null) {
            sd_node.setAttribute("precursor_charge", "" + this.precursor_charge);
        }
        if (this.positive_mode != null) {
            sd_node.setAttribute("positive_mode", "" + this.positive_mode);
        }
        if (this.centroided != null) {
            sd_node.setAttribute("centroided", "" + this.centroided);
        }
        if (this.deisotoped != null) {
            sd_node.setAttribute("deisotoped", "" + this.deisotoped);
        }
        if (this.charge_deconvoluted != null) {
            sd_node.setAttribute("charge_deconvoluted", "" + this.charge_deconvoluted);
        }
        if (this.retention_time != null) {
            sd_node.setAttribute("retention_time", "" + this.retention_time);
        }
        if (this.base_peak_mz != null) {
            sd_node.setAttribute("base_peak_mz", "" + this.base_peak_mz);
        }
        if (this.base_peak_intensity != null) {
            sd_node.setAttribute("base_peak_intensity", "" + this.base_peak_intensity);
        }
        if (this.start_mz != null) {
            sd_node.setAttribute("start_mz", "" + this.start_mz);
        }
        if (this.end_mz != null) {
            sd_node.setAttribute("end_mz", "" + this.end_mz);
        }
        if (this.low_mz != null) {
            sd_node.setAttribute("low_mz", "" + this.low_mz);
        }
        if (this.high_mz != null) {
            sd_node.setAttribute("high_mz", "" + this.high_mz);
        }
        if (this.total_ion_current != null) {
            sd_node.setAttribute("total_ion_current", "" + this.total_ion_current);
        }
        return sd_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "num", "CDATA", "" + this.num);
        if (this.parent_num != null) {
            atts.addAttribute("", "", "parent_num", "CDATA", "" + this.parent_num);
        }
        if (this.ms_level != null) {
            atts.addAttribute("", "", "ms_level", "CDATA", "" + this.ms_level);
        }
        if (this.precursor_mz != null) {
            atts.addAttribute("", "", "precursor_mz", "CDATA", "" + this.precursor_mz);
        }
        if (this.precursor_charge != null) {
            atts.addAttribute("", "", "precursor_charge", "CDATA", "" + this.precursor_charge);
        }
        if (this.positive_mode != null) {
            atts.addAttribute("", "", "positive_mode", "CDATA", "" + this.positive_mode);
        }
        if (this.centroided != null) {
            atts.addAttribute("", "", "centroided", "CDATA", "" + this.centroided);
        }
        if (this.deisotoped != null) {
            atts.addAttribute("", "", "deisotoped", "CDATA", "" + this.deisotoped);
        }
        if (this.charge_deconvoluted != null) {
            atts.addAttribute("", "", "charge_deconvoluted", "CDATA", "" + this.charge_deconvoluted);
        }
        if (this.retention_time != null) {
            atts.addAttribute("", "", "retention_time", "CDATA", "" + this.retention_time);
        }
        if (this.base_peak_mz != null) {
            atts.addAttribute("", "", "base_peak_mz", "CDATA", "" + this.base_peak_mz);
        }
        if (this.base_peak_intensity != null) {
            atts.addAttribute("", "", "base_peak_intensity", "CDATA", "" + this.base_peak_intensity);
        }
        if (this.start_mz != null) {
            atts.addAttribute("", "", "start_mz", "CDATA", "" + this.start_mz);
        }
        if (this.end_mz != null) {
            atts.addAttribute("", "", "end_mz", "CDATA", "" + this.end_mz);
        }
        if (this.low_mz != null) {
            atts.addAttribute("", "", "low_mz", "CDATA", "" + this.low_mz);
        }
        if (this.high_mz != null) {
            atts.addAttribute("", "", "high_mz", "CDATA", "" + this.high_mz);
        }
        if (this.total_ion_current != null) {
            atts.addAttribute("", "", "total_ion_current", "CDATA", "" + this.total_ion_current);
        }
        th.startElement("", "", "ScanData", atts);
        th.endElement("", "", "ScanData");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "ScanData";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            ScanData ret = new ScanData();
            ret.num = this.integerAttribute(atts, "num");
            ret.parent_num = this.integerAttribute(atts, "parent_num");
            ret.ms_level = this.integerAttribute(atts, "ms_level");
            ret.precursor_mz = this.doubleAttribute(atts, "precursor_mz");
            if (ret.precursor_mz == null) {
                ret.precursor_mz = this.doubleAttribute(atts, "parent_mz");
            }
            ret.precursor_charge = this.integerAttribute(atts, "precursor_charge");
            ret.positive_mode = this.booleanAttribute(atts, "positive_mode");
            ret.centroided = this.booleanAttribute(atts, "centroided");
            ret.deisotoped = this.booleanAttribute(atts, "deisotoped");
            ret.charge_deconvoluted = this.booleanAttribute(atts, "charge_deconvoluted");
            ret.retention_time = this.doubleAttribute(atts, "retention_time");
            ret.base_peak_mz = this.doubleAttribute(atts, "base_peak_mz");
            ret.base_peak_intensity = this.doubleAttribute(atts, "base_peak_intensity");
            ret.start_mz = this.doubleAttribute(atts, "start_mz");
            ret.end_mz = this.doubleAttribute(atts, "end_mz");
            ret.low_mz = this.doubleAttribute(atts, "low_mz");
            ret.high_mz = this.doubleAttribute(atts, "high_mz");
            ret.total_ion_current = this.doubleAttribute(atts, "total_ion_current");
            this.object = ret;
        }
    }
}

