/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.encoding.Encoding;
import org.apache.fontbox.encoding.MacRomanEncoding;
import org.apache.fontbox.ttf.CMAPEncodingEntry;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class TTFSubFont {
    private static final Log LOG = LogFactory.getLog(TTFSubFont.class);
    private static final byte[] PAD_BUF = new byte[]{0, 0, 0};
    private final TrueTypeFont baseTTF;
    private final String nameSuffix;
    private final CMAPEncodingEntry baseCmap;
    private final SortedMap<Integer, Integer> characters;
    private final SortedSet<Integer> glyphIds;

    public TTFSubFont(TrueTypeFont baseFont, String suffix) {
        this.baseTTF = baseFont;
        this.nameSuffix = suffix;
        this.characters = new TreeMap<Integer, Integer>();
        this.glyphIds = new TreeSet<Integer>();
        CMAPEncodingEntry[] cmaps = this.baseTTF.getCMAP().getCmaps();
        CMAPEncodingEntry unicodeCmap = null;
        for (CMAPEncodingEntry cmap : cmaps) {
            if (cmap.getPlatformId() != 0 && (cmap.getPlatformId() != 3 || cmap.getPlatformEncodingId() != 1)) continue;
            unicodeCmap = cmap;
            break;
        }
        this.baseCmap = unicodeCmap;
        this.addCharCode(0);
    }

    public void addCharCode(int charCode) {
        Integer gid = this.baseCmap.getGlyphId(charCode);
        if (charCode == 0 || gid != 0) {
            this.characters.put(charCode, gid);
            this.glyphIds.add(gid);
        }
    }

    private static int log2i(int i) {
        int ret = -1;
        if ((i & 0xFFFF0000) != 0) {
            i >>>= 16;
            ret += 16;
        }
        if ((i & 0xFF00) != 0) {
            i >>>= 8;
            ret += 8;
        }
        if ((i & 0xF0) != 0) {
            i >>>= 4;
            ret += 4;
        }
        if ((i & 0xC) != 0) {
            i >>>= 2;
            ret += 2;
        }
        if ((i & 2) != 0) {
            i >>>= 1;
            ++ret;
        }
        if (i != 0) {
            ++ret;
        }
        return ret;
    }

    private static long buildUint32(int high, int low) {
        return ((long)high & 0xFFFFL) << 16 | (long)low & 0xFFFFL;
    }

    private static long buildUint32(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL;
    }

    private static long writeFileHeader(DataOutputStream dos, int nTables) throws IOException {
        dos.writeInt(65536);
        dos.writeShort(nTables);
        int mask = Integer.highestOneBit(nTables);
        int searchRange = mask * 16;
        dos.writeShort(searchRange);
        int entrySelector = TTFSubFont.log2i(mask);
        dos.writeShort(entrySelector);
        int last = 16 * nTables - searchRange;
        dos.writeShort(last);
        return 65536L + TTFSubFont.buildUint32(nTables, searchRange) + TTFSubFont.buildUint32(entrySelector, last);
    }

    private static long writeTableHeader(DataOutputStream dos, String tag, long offset, byte[] bytes) throws IOException {
        int n = bytes.length;
        long checksum = 0L;
        for (int nup = 0; nup < n; ++nup) {
            checksum += ((long)bytes[nup] & 0xFFL) << 24 - nup % 4 * 8;
        }
        LOG.debug(String.format("Writing table header [%s,%08x,%08x,%08x]", tag, checksum &= 0xFFFFFFFFL, offset, bytes.length));
        byte[] tagbytes = tag.getBytes("US-ASCII");
        dos.write(tagbytes, 0, 4);
        dos.writeInt((int)checksum);
        dos.writeInt((int)offset);
        dos.writeInt(bytes.length);
        return TTFSubFont.buildUint32(tagbytes) + checksum + checksum + offset + (long)bytes.length;
    }

    private static void writeTableBody(OutputStream os, byte[] bytes) throws IOException {
        int n = bytes.length;
        os.write(bytes);
        if (n % 4 != 0) {
            os.write(PAD_BUF, 0, 4 - n % 4);
        }
    }

    private static void writeFixed(DataOutputStream dos, double f) throws IOException {
        double ip = Math.floor(f);
        double fp = (f - ip) * 65536.0;
        dos.writeShort((int)ip);
        dos.writeShort((int)fp);
    }

    private static void writeUint32(DataOutputStream dos, long l) throws IOException {
        dos.writeInt((int)l);
    }

    private static void writeUint16(DataOutputStream dos, int i) throws IOException {
        dos.writeShort(i);
    }

    private static void writeSint16(DataOutputStream dos, short i) throws IOException {
        dos.writeShort(i);
    }

    private static void writeUint8(DataOutputStream dos, int i) throws IOException {
        dos.writeByte(i);
    }

    private static void writeLongDateTime(DataOutputStream dos, Calendar calendar) throws IOException {
        GregorianCalendar cal = new GregorianCalendar(1904, 0, 1);
        long millisFor1904 = cal.getTimeInMillis();
        long secondsSince1904 = (calendar.getTimeInMillis() - millisFor1904) / 1000L;
        dos.writeLong(secondsSince1904);
    }

    private byte[] buildHeadTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        LOG.debug("Building table [head]...");
        HeaderTable h = this.baseTTF.getHeader();
        TTFSubFont.writeFixed(dos, h.getVersion());
        TTFSubFont.writeFixed(dos, h.getFontRevision());
        TTFSubFont.writeUint32(dos, 0L);
        TTFSubFont.writeUint32(dos, h.getMagicNumber());
        TTFSubFont.writeUint16(dos, h.getFlags());
        TTFSubFont.writeUint16(dos, h.getUnitsPerEm());
        TTFSubFont.writeLongDateTime(dos, h.getCreated());
        TTFSubFont.writeLongDateTime(dos, h.getModified());
        TTFSubFont.writeSint16(dos, h.getXMin());
        TTFSubFont.writeSint16(dos, h.getYMin());
        TTFSubFont.writeSint16(dos, h.getXMax());
        TTFSubFont.writeSint16(dos, h.getYMax());
        TTFSubFont.writeUint16(dos, h.getMacStyle());
        TTFSubFont.writeUint16(dos, h.getLowestRecPPEM());
        TTFSubFont.writeSint16(dos, h.getFontDirectionHint());
        TTFSubFont.writeSint16(dos, (short)1);
        TTFSubFont.writeSint16(dos, h.getGlyphDataFormat());
        dos.flush();
        LOG.debug("Finished table [head].");
        return bos.toByteArray();
    }

    private byte[] buildHheaTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        LOG.debug("Building table [hhea]...");
        HorizontalHeaderTable h = this.baseTTF.getHorizontalHeader();
        TTFSubFont.writeFixed(dos, h.getVersion());
        TTFSubFont.writeSint16(dos, h.getAscender());
        TTFSubFont.writeSint16(dos, h.getDescender());
        TTFSubFont.writeSint16(dos, h.getLineGap());
        TTFSubFont.writeUint16(dos, h.getAdvanceWidthMax());
        TTFSubFont.writeSint16(dos, h.getMinLeftSideBearing());
        TTFSubFont.writeSint16(dos, h.getMinRightSideBearing());
        TTFSubFont.writeSint16(dos, h.getXMaxExtent());
        TTFSubFont.writeSint16(dos, h.getCaretSlopeRise());
        TTFSubFont.writeSint16(dos, h.getCaretSlopeRun());
        TTFSubFont.writeSint16(dos, h.getReserved1());
        TTFSubFont.writeSint16(dos, h.getReserved2());
        TTFSubFont.writeSint16(dos, h.getReserved3());
        TTFSubFont.writeSint16(dos, h.getReserved4());
        TTFSubFont.writeSint16(dos, h.getReserved5());
        TTFSubFont.writeSint16(dos, h.getMetricDataFormat());
        TTFSubFont.writeUint16(dos, this.glyphIds.subSet(0, h.getNumberOfHMetrics()).size());
        dos.flush();
        LOG.debug("Finished table [hhea].");
        return bos.toByteArray();
    }

    private static boolean replicateNameRecord(NameRecord nr) {
        return nr.getPlatformId() == 3 && nr.getPlatformEncodingId() == 1 && nr.getLanguageId() == 0 && nr.getNameId() >= 0 && nr.getNameId() < 7;
    }

    private byte[] buildNameTable() throws IOException {
        int i;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        LOG.debug("Building table [name]...");
        NamingTable n = this.baseTTF.getNaming();
        List<NameRecord> nameRecords = null;
        if (n != null) {
            nameRecords = n.getNameRecords();
        } else {
            nameRecords = new ArrayList<NameRecord>();
            NameRecord nr = new NameRecord();
            nr.setPlatformId(3);
            nr.setPlatformEncodingId(1);
            nr.setLanguageId(0);
            nr.setNameId(1);
            nr.setString("PDFBox-Dummy-Familyname");
            nameRecords.add(nr);
            nr = new NameRecord();
            nr.setPlatformId(3);
            nr.setPlatformEncodingId(1);
            nr.setLanguageId(0);
            nr.setNameId(4);
            nr.setString("PDFBox-Dummy-Fullname");
            nameRecords.add(nr);
        }
        int numberOfRecords = nameRecords.size();
        int nrep = 0;
        for (int i2 = 0; i2 < numberOfRecords; ++i2) {
            NameRecord nr = nameRecords.get(i2);
            if (!TTFSubFont.replicateNameRecord(nr)) continue;
            LOG.debug("Writing name record [" + nr.getNameId() + "], [" + nr.getString() + "],");
            ++nrep;
        }
        TTFSubFont.writeUint16(dos, 0);
        TTFSubFont.writeUint16(dos, nrep);
        TTFSubFont.writeUint16(dos, 6 + 12 * nrep);
        byte[][] names = new byte[nrep][];
        int j = 0;
        for (int i3 = 0; i3 < numberOfRecords; ++i3) {
            NameRecord nr = nameRecords.get(i3);
            if (!TTFSubFont.replicateNameRecord(nr)) continue;
            int platform = nr.getPlatformId();
            int encoding = nr.getPlatformEncodingId();
            String charset = "ISO-8859-1";
            if (platform == 3 && encoding == 1) {
                charset = "UTF-16BE";
            } else if (platform == 2) {
                if (encoding == 0) {
                    charset = "US-ASCII";
                } else if (encoding == 1) {
                    charset = "UTF16-BE";
                } else if (encoding == 2) {
                    charset = "ISO-8859-1";
                }
            }
            String value = nr.getString();
            if (nr.getNameId() == 6 && this.nameSuffix != null) {
                value = value + this.nameSuffix;
            }
            names[j] = value.getBytes(charset);
            ++j;
        }
        int offset = 0;
        j = 0;
        for (i = 0; i < numberOfRecords; ++i) {
            NameRecord nr = nameRecords.get(i);
            if (!TTFSubFont.replicateNameRecord(nr)) continue;
            TTFSubFont.writeUint16(dos, nr.getPlatformId());
            TTFSubFont.writeUint16(dos, nr.getPlatformEncodingId());
            TTFSubFont.writeUint16(dos, nr.getLanguageId());
            TTFSubFont.writeUint16(dos, nr.getNameId());
            TTFSubFont.writeUint16(dos, names[j].length);
            TTFSubFont.writeUint16(dos, offset);
            offset += names[j].length;
            ++j;
        }
        for (i = 0; i < nrep; ++i) {
            dos.write(names[i]);
        }
        dos.flush();
        LOG.debug("Finished table [name].");
        return bos.toByteArray();
    }

    private byte[] buildMaxpTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        LOG.debug("Building table [maxp]...");
        MaximumProfileTable p = this.baseTTF.getMaximumProfile();
        TTFSubFont.writeFixed(dos, 1.0);
        TTFSubFont.writeUint16(dos, this.glyphIds.size());
        TTFSubFont.writeUint16(dos, p.getMaxPoints());
        TTFSubFont.writeUint16(dos, p.getMaxContours());
        TTFSubFont.writeUint16(dos, p.getMaxCompositePoints());
        TTFSubFont.writeUint16(dos, p.getMaxCompositeContours());
        TTFSubFont.writeUint16(dos, p.getMaxZones());
        TTFSubFont.writeUint16(dos, p.getMaxTwilightPoints());
        TTFSubFont.writeUint16(dos, p.getMaxStorage());
        TTFSubFont.writeUint16(dos, p.getMaxFunctionDefs());
        TTFSubFont.writeUint16(dos, 0);
        TTFSubFont.writeUint16(dos, p.getMaxStackElements());
        TTFSubFont.writeUint16(dos, 0);
        TTFSubFont.writeUint16(dos, p.getMaxComponentElements());
        TTFSubFont.writeUint16(dos, p.getMaxComponentDepth());
        dos.flush();
        LOG.debug("Finished table [maxp].");
        return bos.toByteArray();
    }

    private byte[] buildOS2Table() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        OS2WindowsMetricsTable os2 = this.baseTTF.getOS2Windows();
        if (os2 == null) {
            os2 = new OS2WindowsMetricsTable();
        }
        LOG.debug("Building table [OS/2]...");
        TTFSubFont.writeUint16(dos, 0);
        TTFSubFont.writeSint16(dos, os2.getAverageCharWidth());
        TTFSubFont.writeUint16(dos, os2.getWeightClass());
        TTFSubFont.writeUint16(dos, os2.getWidthClass());
        TTFSubFont.writeSint16(dos, os2.getFsType());
        TTFSubFont.writeSint16(dos, os2.getSubscriptXSize());
        TTFSubFont.writeSint16(dos, os2.getSubscriptYSize());
        TTFSubFont.writeSint16(dos, os2.getSubscriptXOffset());
        TTFSubFont.writeSint16(dos, os2.getSubscriptYOffset());
        TTFSubFont.writeSint16(dos, os2.getSuperscriptXSize());
        TTFSubFont.writeSint16(dos, os2.getSuperscriptYSize());
        TTFSubFont.writeSint16(dos, os2.getSuperscriptXOffset());
        TTFSubFont.writeSint16(dos, os2.getSuperscriptYOffset());
        TTFSubFont.writeSint16(dos, os2.getStrikeoutSize());
        TTFSubFont.writeSint16(dos, os2.getStrikeoutPosition());
        TTFSubFont.writeUint8(dos, os2.getFamilyClass());
        TTFSubFont.writeUint8(dos, os2.getFamilySubClass());
        dos.write(os2.getPanose());
        TTFSubFont.writeUint32(dos, 0L);
        TTFSubFont.writeUint32(dos, 0L);
        TTFSubFont.writeUint32(dos, 0L);
        TTFSubFont.writeUint32(dos, 0L);
        dos.write(os2.getAchVendId().getBytes("ISO-8859-1"));
        Iterator<Map.Entry<Integer, Integer>> it = this.characters.entrySet().iterator();
        it.next();
        Map.Entry<Integer, Integer> first = it.next();
        TTFSubFont.writeUint16(dos, os2.getFsSelection());
        TTFSubFont.writeUint16(dos, first.getKey());
        TTFSubFont.writeUint16(dos, this.characters.lastKey());
        TTFSubFont.writeUint16(dos, os2.getTypoAscender());
        TTFSubFont.writeUint16(dos, os2.getTypoDescender());
        TTFSubFont.writeUint16(dos, os2.getTypeLineGap());
        TTFSubFont.writeUint16(dos, os2.getWinAscent());
        TTFSubFont.writeUint16(dos, os2.getWinDescent());
        dos.flush();
        LOG.debug("Finished table [OS/2].");
        return bos.toByteArray();
    }

    private byte[] buildLocaTable(long[] newOffsets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        LOG.debug("Building table [loca]...");
        for (long newOff : newOffsets) {
            TTFSubFont.writeUint32(dos, newOff);
        }
        dos.flush();
        LOG.debug("Finished table [loca].");
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addCompoundReferences() throws IOException {
        GlyphTable g = this.baseTTF.getGlyph();
        long[] offsets = this.baseTTF.getIndexToLocation().getOffsets();
        InputStream is = this.baseTTF.getOriginalData();
        TreeSet<Integer> glyphIdsToAdd = null;
        try {
            is.skip(g.getOffset());
            long lastOff = 0L;
            for (Integer glyphId : this.glyphIds) {
                long offset = offsets[glyphId];
                long len = offsets[glyphId + 1] - offset;
                is.skip(offset - lastOff);
                byte[] buf = new byte[(int)len];
                is.read(buf);
                if (buf.length >= 2 && buf[0] == -1 && buf[1] == -1) {
                    int off = 10;
                    int flags = 0;
                    do {
                        int ogid;
                        flags = (buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF;
                        if (!this.glyphIds.contains(ogid = (buf[off += 2] & 0xFF) << 8 | buf[off + 1] & 0xFF)) {
                            LOG.debug("Adding referenced glyph " + ogid + " of compound glyph " + glyphId);
                            if (glyphIdsToAdd == null) {
                                glyphIdsToAdd = new TreeSet<Integer>();
                            }
                            glyphIdsToAdd.add(ogid);
                        }
                        off += 2;
                        off = (flags & 1) != 0 ? (off += 4) : (off += 2);
                        if ((flags & 0x80) != 0) {
                            off += 8;
                            continue;
                        }
                        if ((flags & 0x40) != 0) {
                            off += 4;
                            continue;
                        }
                        if ((flags & 8) == 0) continue;
                        off += 2;
                    } while ((flags & 0x20) != 0);
                }
                lastOff = offsets[glyphId + 1];
            }
        }
        finally {
            is.close();
        }
        if (glyphIdsToAdd != null) {
            this.glyphIds.addAll(glyphIdsToAdd);
        }
        return glyphIdsToAdd == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildGlyfTable(long[] newOffsets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LOG.debug("Building table [glyf]...");
        GlyphTable g = this.baseTTF.getGlyph();
        long[] offsets = this.baseTTF.getIndexToLocation().getOffsets();
        InputStream is = this.baseTTF.getOriginalData();
        try {
            is.skip(g.getOffset());
            long lastOff = 0L;
            long newOff = 0L;
            int ioff = 0;
            for (Integer glyphId : this.glyphIds) {
                long offset = offsets[glyphId];
                long len = offsets[glyphId + 1] - offset;
                newOffsets[ioff++] = newOff;
                is.skip(offset - lastOff);
                byte[] buf = new byte[(int)len];
                is.read(buf);
                if (buf.length >= 2 && buf[0] == -1 && buf[1] == -1) {
                    LOG.debug("Compound glyph " + glyphId);
                    int off = 10;
                    int flags = 0;
                    do {
                        int ogid;
                        int n = off;
                        buf[n] = (byte)(buf[n] & 0xFE);
                        flags = (buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF;
                        if (!this.glyphIds.contains(ogid = (buf[off += 2] & 0xFF) << 8 | buf[off + 1] & 0xFF)) {
                            this.glyphIds.add(ogid);
                        }
                        int ngid = this.getNewGlyphId(ogid);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("mapped glyph  %d to %d in compound reference (flags=%04x)", ogid, ngid, flags));
                        }
                        buf[off] = (byte)(ngid >>> 8);
                        buf[off + 1] = (byte)ngid;
                        off += 2;
                        off = (flags & 1) != 0 ? (off += 4) : (off += 2);
                        if ((flags & 0x80) != 0) {
                            off += 8;
                            continue;
                        }
                        if ((flags & 0x40) != 0) {
                            off += 4;
                            continue;
                        }
                        if ((flags & 8) == 0) continue;
                        off += 2;
                    } while ((flags & 0x20) != 0);
                    bos.write(buf, 0, off);
                    newOff += (long)off;
                } else if (buf.length > 0) {
                    int numberOfContours = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
                    int off = 10 + numberOfContours * 2;
                    bos.write(buf, 0, off);
                    newOff += (long)off;
                    int instructionLength = (buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF;
                    bos.write(0);
                    bos.write(0);
                    newOff += 2L;
                    bos.write(buf, off += 2 + instructionLength, buf.length - off);
                    newOff += (long)(buf.length - off);
                }
                if (newOff % 4L != 0L) {
                    int np = (int)(4L - newOff % 4L);
                    bos.write(PAD_BUF, 0, np);
                    newOff += (long)np;
                }
                lastOff = offsets[glyphId + 1];
            }
            newOffsets[ioff++] = newOff;
        }
        finally {
            is.close();
        }
        LOG.debug("Finished table [glyf].");
        return bos.toByteArray();
    }

    private int getNewGlyphId(Integer oldGid) {
        return this.glyphIds.headSet(oldGid).size();
    }

    private byte[] buildCmapTable() throws IOException {
        int i;
        Map.Entry<Integer, Integer> lastChar;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        LOG.debug("Building table [cmap]...");
        TTFSubFont.writeUint16(dos, 0);
        TTFSubFont.writeUint16(dos, 1);
        TTFSubFont.writeUint16(dos, 3);
        TTFSubFont.writeUint16(dos, 1);
        TTFSubFont.writeUint32(dos, 12L);
        Iterator<Map.Entry<Integer, Integer>> it = this.characters.entrySet().iterator();
        it.next();
        Map.Entry<Integer, Integer> prevChar = lastChar = it.next();
        int lastGid = this.getNewGlyphId(lastChar.getValue());
        int[] startCode = new int[this.characters.size()];
        int[] endCode = new int[this.characters.size()];
        int[] idDelta = new int[this.characters.size()];
        int nseg = 0;
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> curChar = it.next();
            int curGid = this.getNewGlyphId(curChar.getValue());
            if (curChar.getKey() != prevChar.getKey() + 1 || curGid - lastGid != curChar.getKey() - lastChar.getKey()) {
                if (lastGid != 0) {
                    startCode[nseg] = lastChar.getKey();
                    endCode[nseg] = prevChar.getKey();
                    idDelta[nseg] = lastGid - lastChar.getKey();
                    ++nseg;
                } else if (!lastChar.getKey().equals(prevChar.getKey())) {
                    startCode[nseg] = lastChar.getKey() + 1;
                    endCode[nseg] = prevChar.getKey();
                    idDelta[nseg] = lastGid - lastChar.getKey();
                    ++nseg;
                }
                lastGid = curGid;
                lastChar = curChar;
            }
            prevChar = curChar;
        }
        startCode[nseg] = lastChar.getKey();
        endCode[nseg] = prevChar.getKey();
        idDelta[nseg] = lastGid - lastChar.getKey();
        startCode[++nseg] = 65535;
        endCode[nseg] = 65535;
        idDelta[nseg] = 1;
        TTFSubFont.writeUint16(dos, 4);
        TTFSubFont.writeUint16(dos, 16 + ++nseg * 8);
        TTFSubFont.writeUint16(dos, 0);
        TTFSubFont.writeUint16(dos, nseg * 2);
        int nsegHigh = Integer.highestOneBit(nseg);
        TTFSubFont.writeUint16(dos, nsegHigh * 2);
        TTFSubFont.writeUint16(dos, TTFSubFont.log2i(nsegHigh));
        TTFSubFont.writeUint16(dos, 2 * (nseg - nsegHigh));
        for (i = 0; i < nseg; ++i) {
            TTFSubFont.writeUint16(dos, endCode[i]);
        }
        TTFSubFont.writeUint16(dos, 0);
        for (i = 0; i < nseg; ++i) {
            TTFSubFont.writeUint16(dos, startCode[i]);
        }
        for (i = 0; i < nseg; ++i) {
            TTFSubFont.writeUint16(dos, idDelta[i]);
        }
        for (i = 0; i < nseg; ++i) {
            TTFSubFont.writeUint16(dos, 0);
        }
        LOG.debug("Finished table [cmap].");
        return bos.toByteArray();
    }

    private byte[] buildPostTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        LOG.debug("Building table [post]...");
        PostScriptTable p = this.baseTTF.getPostScript();
        if (p == null) {
            p = new PostScriptTable();
        }
        String[] glyphNames = p.getGlyphNames();
        TTFSubFont.writeFixed(dos, 2.0);
        TTFSubFont.writeFixed(dos, p.getItalicAngle());
        TTFSubFont.writeSint16(dos, p.getUnderlinePosition());
        TTFSubFont.writeSint16(dos, p.getUnderlineThickness());
        TTFSubFont.writeUint32(dos, p.getIsFixedPitch());
        TTFSubFont.writeUint32(dos, p.getMinMemType42());
        TTFSubFont.writeUint32(dos, p.getMaxMemType42());
        TTFSubFont.writeUint32(dos, p.getMimMemType1());
        TTFSubFont.writeUint32(dos, p.getMaxMemType1());
        TTFSubFont.writeUint16(dos, this.baseTTF.getHorizontalHeader().getNumberOfHMetrics());
        ArrayList<String> additionalNames = new ArrayList<String>();
        HashMap<String, Integer> additionalNamesIndices = new HashMap<String, Integer>();
        if (glyphNames == null) {
            MacRomanEncoding enc = MacRomanEncoding.INSTANCE;
            int[] gidToUC = this.baseCmap.getGlyphIdToCharacterCode();
            for (Integer glyphId : this.glyphIds) {
                Integer macId;
                int uc = gidToUC[glyphId];
                String name = null;
                if (uc < 32768) {
                    try {
                        name = enc.getNameFromCharacter((char)uc);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (name == null) {
                    name = String.format(Locale.ENGLISH, "uni%04X", uc);
                }
                if ((macId = Encoding.MAC_GLYPH_NAMES_INDICES.get(name)) == null) {
                    Integer idx = (Integer)additionalNamesIndices.get(name);
                    if (idx == null) {
                        idx = additionalNames.size();
                        additionalNames.add(name);
                        additionalNamesIndices.put(name, idx);
                    }
                    TTFSubFont.writeUint16(dos, idx + 258);
                    continue;
                }
                TTFSubFont.writeUint16(dos, macId);
            }
        } else {
            for (Integer glyphId : this.glyphIds) {
                String name = glyphNames[glyphId];
                Integer macId = Encoding.MAC_GLYPH_NAMES_INDICES.get(name);
                if (macId == null) {
                    Integer idx = (Integer)additionalNamesIndices.get(name);
                    if (idx == null) {
                        idx = additionalNames.size();
                        additionalNames.add(name);
                        additionalNamesIndices.put(name, idx);
                    }
                    TTFSubFont.writeUint16(dos, idx + 258);
                    continue;
                }
                TTFSubFont.writeUint16(dos, macId);
            }
        }
        for (String name : additionalNames) {
            LOG.debug("additionalName=[" + name + "].");
            byte[] buf = name.getBytes("US-ASCII");
            TTFSubFont.writeUint8(dos, buf.length);
            dos.write(buf);
        }
        dos.flush();
        LOG.debug("Finished table [post].");
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildHmtxTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LOG.debug("Building table [hmtx]...");
        HorizontalHeaderTable h = this.baseTTF.getHorizontalHeader();
        HorizontalMetricsTable hm = this.baseTTF.getHorizontalMetrics();
        byte[] buf = new byte[4];
        InputStream is = this.baseTTF.getOriginalData();
        try {
            is.skip(hm.getOffset());
            long lastOff = 0L;
            for (Integer glyphId : this.glyphIds) {
                int n;
                long nskip;
                long off = glyphId < h.getNumberOfHMetrics() ? (long)(glyphId * 4) : (long)(h.getNumberOfHMetrics() * 4 + (glyphId - h.getNumberOfHMetrics()) * 2);
                if (off != lastOff && (nskip = off - lastOff) != is.skip(nskip)) {
                    throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
                }
                int n2 = n = glyphId < h.getNumberOfHMetrics() ? 4 : 2;
                if (n != is.read(buf, 0, n)) {
                    throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
                }
                bos.write(buf, 0, n);
                lastOff = off + (long)n;
            }
            LOG.debug("Finished table [hmtx].");
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream os) throws IOException {
        LOG.debug("glyphIds=[" + this.glyphIds + "]");
        LOG.debug("numGlyphs=[" + this.glyphIds.size() + "]");
        while (!this.addCompoundReferences()) {
        }
        DataOutputStream dos = new DataOutputStream(os);
        try {
            int i;
            String[] tableNames = new String[]{"OS/2", "cmap", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name", "post"};
            byte[][] tables = new byte[tableNames.length][];
            long[] newOffsets = new long[this.glyphIds.size() + 1];
            tables[3] = this.buildHeadTable();
            tables[4] = this.buildHheaTable();
            tables[7] = this.buildMaxpTable();
            tables[8] = this.buildNameTable();
            tables[0] = this.buildOS2Table();
            tables[2] = this.buildGlyfTable(newOffsets);
            tables[6] = this.buildLocaTable(newOffsets);
            tables[1] = this.buildCmapTable();
            tables[5] = this.buildHmtxTable();
            tables[9] = this.buildPostTable();
            long checksum = TTFSubFont.writeFileHeader(dos, tableNames.length);
            long offset = 12L + 16L * (long)tableNames.length;
            for (i = 0; i < tableNames.length; ++i) {
                checksum += TTFSubFont.writeTableHeader(dos, tableNames[i], offset, tables[i]);
                offset += (long)((tables[i].length + 3) / 4 * 4);
            }
            checksum = 2981146554L - (checksum & 0xFFFFFFFFL);
            tables[3][8] = (byte)(checksum >>> 24);
            tables[3][9] = (byte)(checksum >>> 16);
            tables[3][10] = (byte)(checksum >>> 8);
            tables[3][11] = (byte)checksum;
            for (i = 0; i < tableNames.length; ++i) {
                TTFSubFont.writeTableBody(dos, tables[i]);
            }
        }
        finally {
            dos.close();
        }
    }
}

