/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultiSelectionCombo
extends Composite {
    private Shell shell = null;
    private List list = null;
    private Text txtCurrentSelection = null;
    private Button btnArrow = null;
    private String[] textItems = null;
    private int[] currentSelection = null;
    private ArrayList<MouseListener> lMouseListener;

    public MultiSelectionCombo(Composite parent, String[] items, int[] selection, int style) {
        super(parent, style);
        this.currentSelection = selection;
        this.textItems = items;
        this.init();
    }

    public MultiSelectionCombo(Composite parent, int style) {
        this(parent, new String[0], new int[0], style);
    }

    private void init() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        this.txtCurrentSelection = new Text((Composite)this, 8);
        this.txtCurrentSelection.setEditable(false);
        this.txtCurrentSelection.setLayoutData((Object)new GridData(1808));
        this.displayText();
        this.btnArrow = new Button((Composite)this, 1028);
        this.btnArrow.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                super.mouseDown(event);
                MultiSelectionCombo.this.initFloatShell();
            }
        });
        this.lMouseListener = new ArrayList();
        this.txtCurrentSelection.setBackground(this.getDisplay().getSystemColor(1));
    }

    private void initFloatShell() {
        Point p = this.txtCurrentSelection.getParent().toDisplay(this.txtCurrentSelection.getLocation());
        Point size = this.txtCurrentSelection.getSize();
        if (size.x < 50) {
            size.x = 50;
        }
        Rectangle shellRect = new Rectangle(p.x, p.y + size.y, size.x, 0);
        this.shell = new Shell(this.getShell(), 8);
        GridLayout gl = new GridLayout();
        gl.marginBottom = 0;
        gl.marginTop = 0;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.shell.setLayout((Layout)gl);
        this.list = new List((Composite)this.shell, 2818);
        String[] stringArray = this.textItems;
        int n = this.textItems.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.list.add(value);
            ++n2;
        }
        this.list.setSelection(this.currentSelection);
        GridData gd = new GridData(1808);
        this.list.setLayoutData((Object)gd);
        size = this.list.computeSize(shellRect.width, 60);
        this.shell.setSize(size);
        this.shell.setLocation(shellRect.x, p.y - size.y);
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                super.mouseUp(event);
                MultiSelectionCombo.this.currentSelection = MultiSelectionCombo.this.list.getSelectionIndices();
                if ((event.stateMask & 0x40000) == 0) {
                    MultiSelectionCombo.this.shell.dispose();
                    MultiSelectionCombo.this.displayText();
                }
            }
        });
        for (MouseListener listener : this.lMouseListener) {
            this.list.addMouseListener(listener);
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent arg0) {
                if (MultiSelectionCombo.this.shell != null && !MultiSelectionCombo.this.shell.isDisposed()) {
                    MultiSelectionCombo.this.currentSelection = MultiSelectionCombo.this.list.getSelectionIndices();
                    MultiSelectionCombo.this.displayText();
                    MultiSelectionCombo.this.shell.dispose();
                }
            }
        });
        this.shell.open();
    }

    private void displayText() {
        if (this.currentSelection != null && this.currentSelection.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.currentSelection.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.textItems[this.currentSelection[i]]);
                ++i;
            }
            this.txtCurrentSelection.setText(sb.toString());
        } else {
            this.txtCurrentSelection.setText("---");
        }
        this.getParent().layout();
    }

    public String[] getItems() {
        return this.textItems;
    }

    public void setItems(String[] items) {
        this.textItems = items;
    }

    public void add(String item) {
        String[] textItemsNew = new String[this.textItems.length + 1];
        int i = 0;
        while (i < textItemsNew.length - 1) {
            textItemsNew[i] = this.textItems[i];
            ++i;
        }
        textItemsNew[textItemsNew.length - 1] = item;
        this.textItems = textItemsNew;
    }

    public int getItemCount() {
        return this.textItems.length;
    }

    public int[] getSelectionIndices() {
        return this.currentSelection;
    }

    public String[] getSelections() {
        String[] selections = new String[this.currentSelection.length];
        int i = 0;
        int[] nArray = this.currentSelection;
        int n = this.currentSelection.length;
        int n2 = 0;
        while (n2 < n) {
            int item = nArray[n2];
            selections[i++] = this.textItems[item];
            ++n2;
        }
        return selections;
    }

    public void setSelectionIndices(int[] selection) {
        this.currentSelection = selection;
        this.displayText();
    }

    public void select(int selection) {
        this.currentSelection = new int[]{selection};
        this.displayText();
    }

    public void addMouseListener(MouseListener listener) {
        this.lMouseListener.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.lMouseListener.remove(listener);
    }

    public void resetMouseListener() {
        this.lMouseListener = new ArrayList();
    }

    public void removeAll() {
        this.textItems = new String[0];
        this.currentSelection = new int[0];
        this.lMouseListener = new ArrayList();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.txtCurrentSelection.setEnabled(enabled);
        this.btnArrow.setEnabled(enabled);
        if (enabled) {
            this.txtCurrentSelection.setBackground(this.getDisplay().getSystemColor(1));
        } else {
            this.txtCurrentSelection.setBackground(this.getBackground());
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout());
        shell.setText("MultiSelectionCombo Demo");
        String[] items = new String[]{"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa"};
        int[] nArray = new int[2];
        nArray[1] = 2;
        int[] selection = nArray;
        final MultiSelectionCombo combo = new MultiSelectionCombo((Composite)shell, items, selection, 2048);
        combo.setLayoutData(new GridData(16384, 0x1000000, true, false));
        ((GridData)combo.getLayoutData()).widthHint = 300;
        Button button = new Button((Composite)shell, 0);
        button.setText("What is selected?");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                System.out.println("Selected items: " + Arrays.toString(combo.getSelectionIndices()));
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

