/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.dialog;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.grits.toolbox.tools.glycanbuilder.core.config.GraphicOptionsSWT;

public class DisplaySettingsDialog
extends TitleAreaDialog {
    private GraphicOptionsSWT m_options;
    private Combo m_cmbDisplay;
    private Button m_btnShowInfo;
    private Spinner m_spnNodeSize;
    private Spinner m_spnNodeFontSize;
    private Combo m_cmbNodeFontFace;
    private Spinner m_spnCompositionFontSize;
    private Combo m_cmbCompositionFontFace;
    private Spinner m_spnLinkageInfoSize;
    private Combo m_cmbLinkageInfoFontFace;
    private Spinner m_spnNodeSpace;
    private Spinner m_spnNodeSubSpace;
    private Spinner m_spnStructuresSpace;
    private Spinner m_spnMassTextSpace;
    private Spinner m_spnMassTextSize;
    private Combo m_cmbMassTextFontFace;

    public DisplaySettingsDialog(Shell parentShell, GraphicOptionsSWT options) {
        super(parentShell);
        this.m_options = options;
    }

    public void create() {
        super.create();
        this.setTitle("Display settings");
    }

    public Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        container.setLayout((Layout)layout);
        this.createSettingsControls(container);
        this.setSettingsParams(this.m_options);
        return area;
    }

    private void createSettingsControls(Composite container) {
        String[] availableFonts = GraphicOptionsSWT.getAllFontFaces().toArray(new String[0]);
        Label lbl = new Label(container, 0);
        lbl.setText("Display type");
        this.m_cmbDisplay = this.getNewCombo(container, GraphicOptionsSWT.DISPLAYS, 0);
        this.m_cmbDisplay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String strDisplay = ((Combo)e.widget).getText();
                DisplaySettingsDialog.this.m_options.setDisplay(strDisplay);
                DisplaySettingsDialog.this.setSettingsParams(DisplaySettingsDialog.this.m_options);
            }
        });
        lbl = new Label(container, 0);
        lbl.setText("Show linkage info");
        this.m_btnShowInfo = new Button(container, 32);
        this.m_btnShowInfo.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Residue size");
        this.m_spnNodeSize = this.getNewSpinner(container, 1, 100, 1, 1);
        this.m_spnNodeSize.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Residue text size");
        this.m_spnNodeFontSize = this.getNewSpinner(container, 1, 40, 1, 1);
        this.m_spnNodeFontSize.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Residue text font");
        this.m_cmbNodeFontFace = this.getNewCombo(container, availableFonts, 0);
        this.m_cmbNodeFontFace.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Composition text size");
        this.m_spnCompositionFontSize = this.getNewSpinner(container, 1, 40, 1, 1);
        this.m_spnCompositionFontSize.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Composition text font");
        this.m_cmbCompositionFontFace = this.getNewCombo(container, availableFonts, 0);
        this.m_cmbCompositionFontFace.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Linkage info text size");
        this.m_spnLinkageInfoSize = this.getNewSpinner(container, 1, 40, 1, 1);
        this.m_spnLinkageInfoSize.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Linkage info text font");
        this.m_cmbLinkageInfoFontFace = this.getNewCombo(container, availableFonts, 0);
        this.m_cmbLinkageInfoFontFace.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Space between residues");
        this.m_spnNodeSpace = this.getNewSpinner(container, 1, 100, 1, 1);
        this.m_spnNodeSpace.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Space between border residues");
        this.m_spnNodeSubSpace = this.getNewSpinner(container, 1, 40, 1, 1);
        this.m_spnNodeSubSpace.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Space between structures");
        this.m_spnStructuresSpace = this.getNewSpinner(container, 1, 100, 1, 1);
        this.m_spnStructuresSpace.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Space before mass text");
        this.m_spnMassTextSpace = this.getNewSpinner(container, 1, 100, 1, 1);
        this.m_spnMassTextSpace.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Mass text size");
        this.m_spnMassTextSize = this.getNewSpinner(container, 1, 40, 1, 1);
        this.m_spnMassTextSize.addSelectionListener(this.getNewSelectionAdapterForCustom());
        lbl = new Label(container, 0);
        lbl.setText("Mass text font");
        this.m_cmbMassTextFontFace = this.getNewCombo(container, availableFonts, 0);
        this.m_cmbMassTextFontFace.addSelectionListener(this.getNewSelectionAdapterForCustom());
    }

    private Combo getNewCombo(Composite container, String[] items, int selection) {
        Combo cmb = new Combo(container, 0);
        cmb.setItems(items);
        cmb.select(selection);
        cmb.setLayoutData((Object)new GridData(4, 4, true, true));
        return cmb;
    }

    private Spinner getNewSpinner(Composite container, int min, int max, int increment, int selection) {
        Spinner spn = new Spinner(container, 2048);
        spn.setMinimum(min);
        spn.setMaximum(max);
        spn.setIncrement(increment);
        spn.setSelection(selection);
        spn.setLayoutData((Object)new GridData(4, 4, true, true));
        return spn;
    }

    private SelectionListener getNewSelectionAdapterForCustom() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplaySettingsDialog.this.m_cmbDisplay.select(3);
                DisplaySettingsDialog.this.saveCustom();
            }
        };
    }

    private void setSettingsParams(GraphicOptionsSWT options) {
        Vector allFontFaces = GraphicOptionsSWT.getAllFontFaces();
        double oldScale = options.SCALE;
        options.adjustSize(false);
        options.setScale(1.0);
        this.m_cmbDisplay.select(Arrays.asList(GraphicOptionsSWT.DISPLAYS).indexOf(options.DISPLAY));
        this.m_btnShowInfo.setSelection(options.SHOW_INFO);
        this.m_spnNodeSize.setSelection(options.NODE_SIZE);
        this.m_spnNodeFontSize.setSelection(options.NODE_FONT_SIZE);
        this.m_cmbNodeFontFace.select(allFontFaces.indexOf(options.NODE_FONT_FACE));
        this.m_spnCompositionFontSize.setSelection(options.COMPOSITION_FONT_SIZE);
        this.m_cmbCompositionFontFace.select(allFontFaces.indexOf(options.COMPOSITION_FONT_FACE));
        this.m_spnLinkageInfoSize.setSelection(options.LINKAGE_INFO_SIZE);
        this.m_cmbLinkageInfoFontFace.select(allFontFaces.indexOf(options.LINKAGE_INFO_FONT_FACE));
        this.m_spnNodeSpace.setSelection(options.NODE_SPACE);
        this.m_spnNodeSubSpace.setSelection(options.NODE_SUB_SPACE);
        this.m_spnStructuresSpace.setSelection(options.STRUCTURES_SPACE);
        this.m_spnMassTextSpace.setSelection(options.MASS_TEXT_SPACE);
        this.m_spnMassTextSize.setSelection(options.MASS_TEXT_SIZE);
        this.m_cmbMassTextFontFace.select(allFontFaces.indexOf(options.MASS_TEXT_FONT_FACE));
        options.adjustSize(true);
        options.setScale(oldScale);
    }

    private void saveCustom() {
        this.m_options.SHOW_INFO_CUSTOM = this.m_btnShowInfo.getSelection();
        this.m_options.NODE_SIZE_CUSTOM = this.m_spnNodeSize.getSelection();
        this.m_options.NODE_FONT_SIZE_CUSTOM = this.m_spnNodeFontSize.getSelection();
        this.m_options.NODE_FONT_FACE_CUSTOM = this.m_cmbNodeFontFace.getText();
        this.m_options.COMPOSITION_FONT_SIZE_CUSTOM = this.m_spnCompositionFontSize.getSelection();
        this.m_options.COMPOSITION_FONT_FACE_CUSTOM = this.m_cmbCompositionFontFace.getText();
        this.m_options.LINKAGE_INFO_SIZE_CUSTOM = this.m_spnLinkageInfoSize.getSelection();
        this.m_options.LINKAGE_INFO_FONT_FACE_CUSTOM = this.m_cmbLinkageInfoFontFace.getText();
        this.m_options.NODE_SPACE_CUSTOM = this.m_spnNodeSpace.getSelection();
        this.m_options.NODE_SUB_SPACE_CUSTOM = this.m_spnNodeSubSpace.getSelection();
        this.m_options.STRUCTURES_SPACE_CUSTOM = this.m_spnStructuresSpace.getSelection();
        this.m_options.MASS_TEXT_SPACE_CUSTOM = this.m_spnMassTextSpace.getSelection();
        this.m_options.MASS_TEXT_SIZE_CUSTOM = this.m_spnMassTextSize.getSelection();
        this.m_options.MASS_TEXT_FONT_FACE_CUSTOM = this.m_cmbMassTextFontFace.getText();
        this.m_options.setDisplay(this.m_cmbDisplay.getText());
    }
}

