/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato.glycan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.AnnotateFragments;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanMatcher;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScansAnnotation;

public class GlycanMatcherDirectInfusion
extends GlycanMatcher {
    private static final Logger logger = Logger.getLogger(GlycanMatcherDirectInfusion.class);
    HashMap<Integer, String> avoideDuplicateAnnotation = new HashMap();

    public GlycanMatcherDirectInfusion(int iCurScan, GlycanStructureAnnotation parent) {
        super(iCurScan, parent);
    }

    @Override
    public List<Integer> getMatchingSubScans(Data data, int iCurScanNum, Peak parentPeak) {
        ArrayList<Integer> iMatchingScans = new ArrayList<Integer>();
        Iterator iterator = data.getScans().keySet().iterator();
        while (iterator.hasNext()) {
            List<Integer> lScans;
            int iHashScanNum = (Integer)iterator.next();
            Scan scan = (Scan)data.getScans().get(iHashScanNum);
            if (scan.getScanNo() < iCurScanNum || (lScans = GelatoUtils.getSubScanForPrecursor(this.getData(), iHashScanNum, parentPeak)).isEmpty()) continue;
            for (Integer iSubScanNum : lScans) {
                iMatchingScans.add(iSubScanNum);
            }
        }
        return iMatchingScans;
    }

    @Override
    public boolean scorePeakToFeature(Data data, double analyteMz, String analyteType, GelatoAnalyte analyte, Annotation annotation, ScansAnnotation scanAnnotation, Feature parentFeature, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, AnalyteSettings settings, Peak parentPeak, int iParentScanNum, String tempPath) {
        Scan parentScan = (Scan)this.getData().getScans().get(iParentScanNum);
        if (parentScan.getMsLevel() != 1) {
            return super.scorePeakToFeature(data, analyteMz, analyteType, analyte, annotation, scanAnnotation, parentFeature, lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, settings, parentPeak, iParentScanNum, tempPath);
        }
        boolean bScored = false;
        try {
            Iterator iterator = this.getData().getScans().keySet().iterator();
            while (iterator.hasNext()) {
                int iHashScanNum = (Integer)iterator.next();
                Scan scan = (Scan)this.getData().getScans().get(iHashScanNum);
                if (scan.getMsLevel() != 1 || scan.getScanNo() < iParentScanNum) continue;
                List<Integer> lScans = GelatoUtils.getSubScanForPrecursor(this.getData(), iHashScanNum, parentPeak);
                if (lScans.isEmpty() && iHashScanNum == iParentScanNum) {
                    GlycanFeature feature = new GlycanFeature();
                    GelatoUtils.populateNewFeature((Feature)feature, data, analyte.getAnalyte().getAnalyteStringRepresentation(), parentPeak.getMz(), analyteMz, iParentCharge, analyteType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, null, parentPeak.getId(), annotation, parentFeature);
                    AnalyteMatcher.addAnnotationToScan(this.getData(), scanAnnotation, iHashScanNum, annotation, (Feature)feature);
                    continue;
                }
                if (lScans.isEmpty()) continue;
                for (Integer iSubScanNum : lScans) {
                    GlycanFeature feature = new GlycanFeature();
                    GelatoUtils.populateNewFeature((Feature)feature, data, analyte.getAnalyte().getAnalyteStringRepresentation(), parentPeak.getMz(), analyteMz, iParentCharge, analyteType, lParentAdducts, lParentAdductCounts, lParentIonExchanges, lParentExchangeCounts, lParentNeutralLosses, lParentNeutralLossCounts, iSubScanNum, parentPeak.getId(), annotation, parentFeature);
                    logger.debug((Object)("\t\tFeature id: " + parentPeak.getId() + ", Feature mz: " + feature.getMz()));
                    AnalyteMatcher.addAnnotationToScan(this.getData(), scanAnnotation, iHashScanNum, annotation, (Feature)feature);
                    if (iSubScanNum == null || this.getData().getScans().get(iSubScanNum) == null || ((Scan)this.getData().getScans().get(iSubScanNum)).getPrecursor() == null || this.avoideDuplicateAnnotation.get(iSubScanNum) != null) continue;
                    this.avoideDuplicateAnnotation.put(iSubScanNum, "seen");
                    AnnotateFragments annFragments = this.getNewAnnotateFragmentsObject();
                    annFragments.annotateFragments(scanAnnotation, iSubScanNum, (Feature)feature, lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, annotation, data, settings, tempPath);
                    this.calculateScores(scanAnnotation, annotation, (Feature)feature, iSubScanNum);
                    bScored = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error matching glycans in GlycanMatcherGlycanBased.", (Throwable)e);
        }
        return bScored;
    }
}

