/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.canvas;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasInterface;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasMenu;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.KeyActionUtils;

public class GlycanCanvasListenerProvider {
    public static void addListenersToCanvas(GlycanCanvasInterface canvas) {
        canvas.getControl().addMouseListener((MouseListener)new GlycanCanvasMouseListener(canvas));
        canvas.getControl().addKeyListener((KeyListener)new GlycanCanvasKeyListener(canvas));
    }

    private static class GlycanCanvasKeyListener
    implements KeyListener {
        private GlycanCanvasInterface m_canvas;

        private GlycanCanvasKeyListener(GlycanCanvasInterface canvas) {
            this.m_canvas = canvas;
        }

        public void keyPressed(KeyEvent e) {
            if (KeyActionUtils.isUndoTrigger(e)) {
                this.m_canvas.undo();
            } else if (KeyActionUtils.isRedoTrigger(e)) {
                this.m_canvas.redo();
            } else if (KeyActionUtils.isCopyTrigger(e)) {
                if (this.m_canvas.canCopy()) {
                    this.m_canvas.copy();
                }
            } else if (KeyActionUtils.isCutTrigger(e)) {
                if (this.m_canvas.canCut()) {
                    this.m_canvas.cut();
                }
            } else if (KeyActionUtils.isPasteTrigger(e)) {
                if (this.m_canvas.canPaste()) {
                    this.m_canvas.paste();
                }
            } else if (KeyActionUtils.isDeleteTrigger(e)) {
                if (this.m_canvas.canDelete()) {
                    this.m_canvas.delete();
                }
            } else if (KeyActionUtils.isSelectAllTrigger(e)) {
                this.m_canvas.selectAll();
            }
        }

        public void keyReleased(KeyEvent e) {
            this.m_canvas.updateView(true);
        }
    }

    private static class GlycanCanvasMouseListener
    implements MouseListener {
        private GlycanCanvasInterface m_canvas;

        private GlycanCanvasMouseListener(GlycanCanvasInterface canvas) {
            this.m_canvas = canvas;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.m_canvas.performResidueSelection(e);
            this.m_canvas.updateView(false);
            GlycanCanvasMenu.setMenu(this.m_canvas);
            if (SWT.MOD4 != 0 && (e.button == 1 && (e.stateMask & SWT.MODIFIER_MASK) == SWT.MOD4 || e.button == 3)) {
                this.m_canvas.getControl().getMenu().setVisible(true);
            }
            ((Control)e.widget).forceFocus();
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

