/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.preference.project.StringLabelProvider;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;

public class FundingPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(FundingPreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.preference.project.collaborator.funding";
    public static String lastSelection = null;
    private SingleChoicePreference fundingPreference = null;
    private List<String> allFundings = null;
    private String defaultFunding = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Fundings");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createFundingsTableViewer(container);
        Button addButton = this.createButton(container, "Add", true);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int newFundingCount = 1;
                while (FundingPreference.this.allFundings.contains("Funding " + newFundingCount)) {
                    ++newFundingCount;
                }
                String newFunding = "Funding " + newFundingCount;
                FundingPreference.this.allFundings.add(newFunding);
                if (FundingPreference.this.allFundings.size() == 1) {
                    FundingPreference.this.defaultFunding = newFunding;
                }
                FundingPreference.this.checkboxTableViewer.refresh();
                FundingPreference.this.tableColumn2.getViewer().editElement((Object)newFunding, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove", false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.remove();
            }

            private void remove() {
                StructuredSelection selection = (StructuredSelection)FundingPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String selectedFunding = (String)selection.getFirstElement();
                    int selectionIndex = FundingPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    FundingPreference.this.allFundings.remove(selectedFunding);
                    if (selectedFunding.equals(FundingPreference.this.defaultFunding)) {
                        FundingPreference.this.defaultFunding = FundingPreference.this.allFundings.isEmpty() ? null : (String)FundingPreference.this.allFundings.iterator().next();
                    }
                    FundingPreference.this.checkboxTableViewer.refresh();
                    if (!FundingPreference.this.allFundings.isEmpty()) {
                        selectionIndex = Math.min(selectionIndex, FundingPreference.this.allFundings.size() - 1);
                        FundingPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection(FundingPreference.this.checkboxTableViewer.getElementAt(selectionIndex)));
                    }
                }
            }
        });
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)FundingPreference.this.checkboxTableViewer.getSelection();
                lastSelection = selection.isEmpty() ? lastSelection : (String)selection.getFirstElement();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return element.equals(FundingPreference.this.defaultFunding);
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FundingPreference.this.defaultFunding = (String)event.getElement();
            }
        });
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.Preference.FUNDING.getPreferenceName()));
        this.fundingPreference = ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.FUNDING);
        this.allFundings = new ArrayList<String>();
        this.allFundings.addAll(this.fundingPreference.getAllValues());
        this.defaultFunding = this.fundingPreference.getDefaultValue();
    }

    private Button createButton(Composite container, String buttonText, boolean grabHorizontal) {
        Button button = new Button(container, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 80;
        buttonData.verticalSpan = 1;
        buttonData.grabExcessHorizontalSpace = grabHorizontal;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private void initializeTable() {
        Collections.sort(this.allFundings, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(this.allFundings);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createFundingsTableViewer(Composite container) {
        Table fundingsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        fundingsTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(fundingsTable, "Default", true);
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Fundings");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer, tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = new TextCellEditor((Composite)checkboxTableViewer.getTable());
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    String newValue = ((String)value).trim();
                    if (FundingPreference.this.checkboxTableViewer.getChecked(element)) {
                        FundingPreference.this.defaultFunding = newValue;
                    }
                    if (FundingPreference.this.allFundings.contains(element)) {
                        FundingPreference.this.allFundings.set(FundingPreference.this.allFundings.indexOf(element), newValue);
                    }
                    FundingPreference.this.checkboxTableViewer.refresh();
                    FundingPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof String ? this.textEditor : null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        Map<String, Boolean> allFundingsMap = this.fundingPreference.loadDefaultValues(ProjectPreferenceStore.Preference.FUNDING);
        this.allFundings = new ArrayList<String>();
        this.defaultFunding = null;
        for (String funding : allFundingsMap.keySet()) {
            this.allFundings.add(funding);
            if (!allFundingsMap.get(funding).booleanValue()) continue;
            this.defaultFunding = funding;
        }
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Funding\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        HashSet<String> uniqueFundings = new HashSet<String>();
        uniqueFundings.addAll(this.allFundings);
        String string = errorMessage = uniqueFundings.size() == this.allFundings.size() ? errorMessage : "Non-unique Fundings";
        if (uniqueFundings.contains("")) {
            errorMessage = "Empty Funding";
            this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)""));
        }
        return errorMessage;
    }

    private boolean save() {
        this.fundingPreference.setAllValues(new HashSet<String>());
        this.fundingPreference.setDefaultValue(null);
        for (String funding : this.allFundings) {
            if (this.checkboxTableViewer.getChecked(funding) && this.fundingPreference.getDefaultValue() == null) {
                this.fundingPreference.setDefaultValue(funding);
            }
            this.fundingPreference.addValue(funding);
        }
        return this.fundingPreference.savePreference();
    }
}

