/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanAnnotationFilterSetup;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.FilterSettingLibrary;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.gui.FilterChangedListener;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class MSGlycanAnnotationFilterPreferenceUI
extends Composite
implements FilterChangedListener {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationFilterPreferenceUI.class);
    private static final String PAGE_COMPLETE_PROPERTY = "Page Complete";
    MSGlycanFilterPreference preferences = null;
    MSGlycanFilterCateogoryPreference categoryPreferences = null;
    FilterSettingLibrary library = null;
    private IPropertyChangeListener listener;
    private boolean isComplete = true;
    protected String errorMessage = null;
    private Layout gridLayout;
    private Combo cmbSelectFilter;
    private Button btnCreateNew;
    private Button btnDeleteCurrent;
    private Button btnEditCurrent;
    private Text txtDescription;
    private Text txtName;
    private Label lblDescription;
    private Label lblName;
    private boolean bIsDirty;
    private FilterSetting currentFilter;
    private String sFilterName;
    private String sDescription;
    List<Filter> filterList = new ArrayList<Filter>();
    FiltersLibrary filterLibrary;
    private FilterTableSetup filterTableSetup;
    private Button btnExport;
    private Button btnImport;

    public MSGlycanAnnotationFilterPreferenceUI(Composite parent, int style, IPropertyChangeListener listener) {
        super(parent, style);
        this.listener = listener;
        this.loadFilterList();
    }

    private void loadFilterList() {
        try {
            this.filterLibrary = FilterUtils.readFilters((String)FileUtils.getFilterPath());
            this.filterList = this.filterLibrary.getFilters();
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot locate the filters file", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
    }

    public void setPreferences(MSGlycanFilterPreference preferences) {
        this.preferences = preferences;
    }

    public MSGlycanFilterPreference getPreferences() {
        return this.preferences;
    }

    public void setCategoryPreferences(MSGlycanFilterCateogoryPreference categoryPreferences) {
        this.categoryPreferences = categoryPreferences;
    }

    public MSGlycanFilterCateogoryPreference getCategoryPreferences() {
        return this.categoryPreferences;
    }

    public List<FilterSetting> getPreferenceFilterSettings() {
        return this.preferences.filterSettings.getFilterSettings();
    }

    public void setPreferenceFilterSettings(FilterSettingLibrary l) {
        this.preferences.setFilterSettings(l);
    }

    private void addCurrentFilterSetting() {
        if (this.currentFilter == null) {
            return;
        }
        if (this.library == null) {
            this.library = new FilterSettingLibrary();
        }
        if (this.library.getFilterSettings() == null) {
            this.library.add(this.currentFilter);
        } else {
            FilterSetting toBeRemoved = null;
            for (FilterSetting filter : this.library.getFilterSettings()) {
                if (!filter.equals(this.currentFilter)) continue;
                toBeRemoved = filter;
            }
            if (toBeRemoved != null) {
                this.library.remove(toBeRemoved);
            }
            this.library.add(this.currentFilter);
        }
    }

    public void initComponents() {
        this.initGridLayout();
        this.setLayout(this.gridLayout);
        this.addSelectFilterItem(this);
        this.addExportCurrent(this);
        this.addDeleteCurrent(this);
        this.addEditCurrent(this);
        this.addCreateNewItem(this);
        this.addImport(this);
        this.addSeparatorLine1(this);
        this.addFilterNameItem(this);
        this.addDescriptionItem(this);
        this.addFilterTableSetup(this);
        this.setEditEnabled(false);
    }

    private void addFilterTableSetup(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(512));
        GridData gd_container = new GridData(16384, 128, true, true, 6, 1);
        gd_container.minimumHeight = 150;
        container.setLayoutData((Object)gd_container);
        this.filterTableSetup = this.filterLibrary.getCategories() != null ? new MSGlycanAnnotationFilterSetup(this.filterLibrary.getCategories()) : new MSGlycanAnnotationFilterSetup();
        this.filterTableSetup.setFilterList(this.filterList);
        if (this.categoryPreferences != null) {
            ((MSGlycanAnnotationFilterSetup)this.filterTableSetup).setSelectedCategory(this.categoryPreferences.getCategoryPreference());
        }
        try {
            this.filterTableSetup.createFilterTableSection(container);
            this.filterTableSetup.addFilterChangedListener((FilterChangedListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating the filter table", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error creating the filter table!");
        }
    }

    protected void initGridLayout() {
        this.gridLayout = new GridLayout(6, false);
    }

    protected void addSelectFilterItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        Label lblSelectFilter = new Label(parent, 0);
        lblSelectFilter.setText("Current Filters");
        lblSelectFilter.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.cmbSelectFilter = new Combo(parent, 0);
        this.cmbSelectFilter.setLayoutData((Object)gd2);
        this.initStoredFiltersList();
        this.cmbSelectFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanAnnotationFilterPreferenceUI.this.processSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void processSelection() {
        if (this.cancelIfDirty()) {
            return;
        }
        this.setEditEnabled(false);
        if (!this.cmbSelectFilter.getText().trim().equals("")) {
            this.btnEditCurrent.setEnabled(true);
            this.btnDeleteCurrent.setEnabled(true);
            this.btnExport.setEnabled(true);
            this.setCurrentFilterValues(this.cmbSelectFilter.getText().trim());
        }
    }

    protected void initStoredFiltersList() {
        this.library = new FilterSettingLibrary();
        this.cmbSelectFilter.removeAll();
        this.cmbSelectFilter.add("");
        if (this.preferences != null && this.getPreferenceFilterSettings() != null) {
            for (FilterSetting filter : this.getPreferenceFilterSettings()) {
                this.cmbSelectFilter.add(filter.getName());
                this.library.add(filter);
            }
        }
    }

    protected void addDeleteCurrent(Composite parent) {
        GridData gd3 = new GridData(4, 4, false, false, 1, 1);
        this.btnDeleteCurrent = new Button(parent, 0);
        this.btnDeleteCurrent.setText("Delete Selected");
        this.btnDeleteCurrent.setLayoutData((Object)gd3);
        this.btnDeleteCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iSelInx = MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.getSelectionIndex();
                if (iSelInx == 0) {
                    return;
                }
                boolean bVal = MessageDialog.openConfirm((Shell)MSGlycanAnnotationFilterPreferenceUI.this.getShell(), (String)"Delete Selected?", (String)"Delete selected. Are you sure?");
                if (bVal) {
                    FilterSetting filter = MSGlycanAnnotationFilterPreferenceUI.this.getCurrentFilter(MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.getItem(iSelInx));
                    if (filter == null) {
                        return;
                    }
                    MSGlycanAnnotationFilterPreferenceUI.this.library.remove(filter);
                    MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.remove(iSelInx);
                    MSGlycanAnnotationFilterPreferenceUI.this.currentFilter = null;
                    MSGlycanAnnotationFilterPreferenceUI.this.clearValues();
                    MSGlycanAnnotationFilterPreferenceUI.this.setEditEnabled(false);
                    MSGlycanAnnotationFilterPreferenceUI.this.updatePreferences();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void addEditCurrent(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnEditCurrent = new Button(parent, 0);
        this.btnEditCurrent.setText("Edit Selected");
        this.btnEditCurrent.setLayoutData((Object)gd1);
        this.btnEditCurrent.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MSGlycanAnnotationFilterPreferenceUI.this.setEditEnabled(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void addExportCurrent(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnExport = new Button(parent, 0);
        this.btnExport.setText("Export");
        this.btnExport.setLayoutData((Object)gd1);
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MSGlycanAnnotationFilterPreferenceUI.this.currentFilter != null) {
                    FileDialog dialog = new FileDialog(MSGlycanAnnotationFilterPreferenceUI.this.getShell(), 8192);
                    dialog.setOverwrite(true);
                    dialog.setFileName(String.valueOf(MSGlycanAnnotationFilterPreferenceUI.this.currentFilter.getName()) + ".xml");
                    dialog.setFilterExtensions(new String[]{"*.xml"});
                    String fileName = dialog.open();
                    if (fileName != null && !fileName.isEmpty()) {
                        try {
                            String xmlString = MSGlycanFilterPreference.marshalFilter(MSGlycanAnnotationFilterPreferenceUI.this.currentFilter);
                            FileWriter fileWriter = new FileWriter(fileName);
                            fileWriter.write(xmlString);
                            fileWriter.close();
                        }
                        catch (IOException e1) {
                            logger.error((Object)("Could not write the selected preference settings to the given file: " + fileName), (Throwable)e1);
                            MessageDialog.openError((Shell)MSGlycanAnnotationFilterPreferenceUI.this.getShell(), (String)"Error", (String)("Could not write the selected preference settings to the given file: " + fileName));
                        }
                        catch (JAXBException e1) {
                            logger.error((Object)("Could not write the selected preference settings to the given file: " + fileName), (Throwable)e1);
                            MessageDialog.openError((Shell)MSGlycanAnnotationFilterPreferenceUI.this.getShell(), (String)"Error", (String)("Could not write the selected preference settings to the given file: " + fileName));
                        }
                    }
                }
            }
        });
    }

    private void addImport(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnImport = new Button(parent, 0);
        this.btnImport.setText("Import");
        this.btnImport.setLayoutData((Object)gd1);
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MSGlycanAnnotationFilterPreferenceUI.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String fileName = dialog.open();
                if (fileName != null && !fileName.isEmpty()) {
                    try {
                        String line;
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));
                        String xmlString = "";
                        while ((line = bufferedReader.readLine()) != null) {
                            xmlString = String.valueOf(xmlString) + line + "\n";
                        }
                        bufferedReader.close();
                        FilterSetting newPref = MSGlycanFilterPreference.unmarshalFilter(xmlString);
                        if (newPref != null) {
                            if (MSGlycanAnnotationFilterPreferenceUI.this.library.getFilterSettings() == null) {
                                MSGlycanAnnotationFilterPreferenceUI.this.library.add(newPref);
                            } else {
                                FilterSetting toBeRemoved = null;
                                for (FilterSetting filter : MSGlycanAnnotationFilterPreferenceUI.this.library.getFilterSettings()) {
                                    if (filter.getName() == null || !filter.getName().equals(newPref.getName())) continue;
                                    MessageDialog.openInformation((Shell)MSGlycanAnnotationFilterPreferenceUI.this.getShell(), (String)"Info", (String)"Already exists! Updating the existing");
                                    toBeRemoved = filter;
                                    break;
                                }
                                if (toBeRemoved != null) {
                                    MSGlycanAnnotationFilterPreferenceUI.this.library.remove(toBeRemoved);
                                    MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.remove(toBeRemoved.getName());
                                    MSGlycanAnnotationFilterPreferenceUI.this.clearValues();
                                }
                                MSGlycanAnnotationFilterPreferenceUI.this.library.add(newPref);
                            }
                            MSGlycanAnnotationFilterPreferenceUI.this.setPreferenceFilterSettings(MSGlycanAnnotationFilterPreferenceUI.this.library);
                            MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.add(newPref.getName());
                            MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.select(MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.getItemCount() - 1);
                            MSGlycanAnnotationFilterPreferenceUI.this.cmbSelectFilter.notifyListeners(13, new Event());
                            MSGlycanAnnotationFilterPreferenceUI.this.currentFilter = newPref;
                        }
                    }
                    catch (FileNotFoundException e1) {
                        MessageDialog.openError((Shell)MSGlycanAnnotationFilterPreferenceUI.this.getShell(), (String)"Error", (String)"Selected file cannot be found");
                        logger.error((Object)"Selected file cannot be found", (Throwable)e1);
                    }
                    catch (IOException e1) {
                        MessageDialog.openError((Shell)MSGlycanAnnotationFilterPreferenceUI.this.getShell(), (String)"Error", (String)"Selected file cannot be opened");
                        logger.error((Object)"Selected file Selected file cannot be opened", (Throwable)e1);
                    }
                    catch (JAXBException e1) {
                        MessageDialog.openError((Shell)MSGlycanAnnotationFilterPreferenceUI.this.getShell(), (String)"Error", (String)"Selected file does not contain a valid preference");
                        logger.error((Object)"Selected file does not contain a valid preference", (Throwable)e1);
                    }
                }
            }
        });
    }

    protected void addCreateNewItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.btnCreateNew = new Button(parent, 0);
        this.btnCreateNew.setText("Create New");
        this.btnCreateNew.setLayoutData((Object)gd1);
        this.btnCreateNew.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (MSGlycanAnnotationFilterPreferenceUI.this.cancelIfDirty()) {
                    return;
                }
                MSGlycanAnnotationFilterPreferenceUI.this.setEditEnabled(true);
                MSGlycanAnnotationFilterPreferenceUI.this.btnEditCurrent.setEnabled(false);
                MSGlycanAnnotationFilterPreferenceUI.this.btnDeleteCurrent.setEnabled(false);
                MSGlycanAnnotationFilterPreferenceUI.this.btnExport.setEnabled(false);
                MSGlycanAnnotationFilterPreferenceUI.this.clearValues();
                MSGlycanAnnotationFilterPreferenceUI.this.currentFilter = new FilterSetting();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void addSeparatorLine1(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 6, 1);
        Label lblSeparator = new Label(parent, 258);
        lblSeparator.setLayoutData((Object)gd1);
    }

    protected FilterSetting getCurrentFilter(String selFilter) {
        if (this.preferences == null || this.getPreferenceFilterSettings() == null) {
            return null;
        }
        int i = 0;
        while (i < this.getPreferenceFilterSettings().size()) {
            FilterSetting curFilter = this.getPreferenceFilterSettings().get(i);
            if (curFilter.getName().equals(selFilter)) {
                return curFilter;
            }
            ++i;
        }
        return null;
    }

    protected boolean cancelIfDirty() {
        boolean bContinue;
        return this.bIsDirty && !(bContinue = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Values Changed", (String)"The values in the current selection have changed. Discard?"));
    }

    protected void setCurrentFilterValues(String selFilterName) {
        if (selFilterName == null) {
            return;
        }
        FilterSetting selFilter = this.getCurrentFilter(selFilterName);
        if (selFilter == null) {
            return;
        }
        this.currentFilter = selFilter;
        this.txtName.setText(selFilter.getName());
        if (selFilter.getDescription() != null) {
            this.txtDescription.setText(selFilter.getDescription());
        } else {
            this.txtDescription.setText("");
        }
        this.initFilterTableValues(selFilter);
        this.setIsDirty(false);
    }

    private void initFilterTableValues(FilterSetting selFilter) {
        if (this.filterTableSetup != null) {
            this.filterTableSetup.setExistingFilters(selFilter);
            if (this.isReadyToFinish()) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        }
    }

    public void setEditEnabled(boolean _bVal) {
        this.btnDeleteCurrent.setEnabled(_bVal);
        this.btnEditCurrent.setEnabled(_bVal);
        this.btnExport.setEnabled(_bVal);
        this.lblName.setEnabled(_bVal);
        this.txtName.setEnabled(_bVal);
        this.lblDescription.setEnabled(_bVal);
        this.txtDescription.setEnabled(_bVal);
        this.filterTableSetup.setEnabled(_bVal);
    }

    protected void clearValues() {
        this.txtName.setText("");
        this.txtDescription.setText("");
        this.cmbSelectFilter.select(0);
        this.setIsDirty(false);
    }

    protected void addFilterNameItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblName = new Label(parent, 0);
        this.lblName.setText("Name of Filter Setting");
        this.lblName.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 5, 1);
        this.txtName = new Text(parent, 2048);
        this.txtName.setLayoutData((Object)gd2);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSGlycanAnnotationFilterPreferenceUI.this.setIsDirty(true);
                if (MSGlycanAnnotationFilterPreferenceUI.this.isReadyToFinish()) {
                    MSGlycanAnnotationFilterPreferenceUI.this.setPageComplete(true);
                } else {
                    MSGlycanAnnotationFilterPreferenceUI.this.setPageComplete(false);
                }
            }
        });
    }

    protected void addDescriptionItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 5);
        this.lblDescription = new Label(parent, 0);
        this.lblDescription.setText("Description");
        this.lblDescription.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true, 5, 5);
        this.txtDescription = new Text(parent, 2626);
        this.txtDescription.setText("");
        this.txtDescription.setLayoutData((Object)gd2);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSGlycanAnnotationFilterPreferenceUI.this.setIsDirty(true);
                if (MSGlycanAnnotationFilterPreferenceUI.this.isReadyToFinish()) {
                    MSGlycanAnnotationFilterPreferenceUI.this.setPageComplete(true);
                } else {
                    MSGlycanAnnotationFilterPreferenceUI.this.setPageComplete(false);
                }
            }
        });
    }

    public void setIsDirty(boolean bIsDirty) {
        this.bIsDirty = bIsDirty;
    }

    public void setPageComplete(boolean isComplete) {
        PropertyChangeEvent e = new PropertyChangeEvent((Object)this, PAGE_COMPLETE_PROPERTY, (Object)this.isComplete, (Object)isComplete);
        this.isComplete = isComplete;
        this.listener.propertyChange(e);
    }

    public boolean isPageComplete() {
        return this.isComplete;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void updatePreferences() {
        this.save();
        this.setPreferenceFilterSettings(this.library);
    }

    private void save() {
        if (this.currentFilter != null && this.bIsDirty) {
            this.currentFilter.setName(this.sFilterName);
            this.currentFilter.setDescription(this.sDescription);
            if (this.filterTableSetup.getFilterSetting() != null) {
                this.currentFilter.setFilter(this.filterTableSetup.getFilterSetting().getFilter());
            }
            this.addCurrentFilterSetting();
        }
        this.setIsDirty(false);
    }

    private boolean isReadyToFinish() {
        this.sFilterName = null;
        this.sDescription = null;
        if (!this.txtName.getText().trim().equals("")) {
            this.sFilterName = this.txtName.getText().trim();
            if (!this.sFilterName.equals(this.currentFilter.getName()) && this.checkFilterExists(this.sFilterName)) {
                this.setErrorMessage("A filter with this name already exists!");
                return false;
            }
        } else if (this.currentFilter != null) {
            this.setErrorMessage("Filter setting name cannot be empty");
            return false;
        }
        this.sDescription = this.txtDescription.getText().trim();
        if (this.currentFilter != null && (this.filterTableSetup.getFilterSetting() == null || this.filterTableSetup.getFilterSetting().getFilter() == null)) {
            this.setErrorMessage("You haven't added any filters yet");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean checkFilterExists(String sFilterName) {
        if (this.library.getFilterSettings() != null) {
            for (FilterSetting filter : this.library.getFilterSettings()) {
                if (!filter.getName().equals(sFilterName)) continue;
                return true;
            }
        }
        return false;
    }

    public void filterChanged() {
        if (this.currentFilter != null && this.filterTableSetup.getFilterSetting() != null) {
            this.currentFilter.setFilter(this.filterTableSetup.getFilterSetting().getFilter());
            if (this.isReadyToFinish()) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        } else if (this.currentFilter != null) {
            this.currentFilter.setFilter(null);
            if (this.isReadyToFinish()) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        }
    }
}

