/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTabbedPane;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.AnnotationPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.FragmentsPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.NotesPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakFinderPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakListPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.ReportingPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SearchPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SpectraPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.WorkspacePlugin;

public class PluginManager {
    public static final int VIEW_NONE = -1;
    public static final int VIEW_LEFT = 0;
    public static final int VIEW_RIGHT = 1;
    public static final int VIEW_BOTTOM = 2;
    protected JTabbedPane theLeftPane = new JTabbedPane();
    protected JTabbedPane theRightPane = new JTabbedPane();
    protected JTabbedPane theBottomPane = new JTabbedPane();
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = null;
    protected TreeMap<String, Plugin> plugins = new TreeMap();
    protected Vector<GlycanAction> ms_peak_actions = new Vector();
    protected Vector<GlycanAction> msms_peak_actions = new Vector();

    public PluginManager(GlycoWorkbench application, GlycanWorkspace workspace) {
        this.theApplication = application;
        this.theWorkspace = workspace;
        this.add(new WorkspacePlugin(application));
        this.add(new SpectraPlugin(application));
        this.add(new PeakListPlugin(application));
        this.add(new FragmentsPlugin(application));
        this.add(new AnnotationPlugin(application));
        this.add(new SearchPlugin(application));
        this.add(new NotesPlugin(application));
        this.add(new ProfilerPlugin(application));
        this.add(new PeakFinderPlugin(application));
        this.add(new ReportingPlugin(application));
        this.add(new GAGPlugin(application));
        String landmarkFolder = FileUtils.getRootDir();
        String pluginDir = landmarkFolder.substring(0, landmarkFolder.lastIndexOf("/")) + "/plugins";
        System.out.println("INFO: Plugin dir: " + pluginDir);
        this.searchPlugins(pluginDir);
        for (Plugin p : this.plugins.values()) {
            p.init();
        }
    }

    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        for (Plugin p : this.plugins.values()) {
            p.setWorkspace(workspace);
        }
    }

    public void exit() {
        for (Plugin p : this.plugins.values()) {
            p.exit();
        }
    }

    public Component getLeftComponent() {
        return this.theLeftPane;
    }

    public Component getRightComponent() {
        return this.theRightPane;
    }

    public Component getBottomComponent() {
        return this.theBottomPane;
    }

    public void add(Plugin plugin) {
        if (plugin != null) {
            plugin.setManager(this);
            plugin.setApplication(this.theApplication);
            plugin.setWorkspace(this.theWorkspace);
            this.plugins.put(plugin.getName(), plugin);
            if (plugin.getLeftComponent() != null) {
                this.theLeftPane.add(plugin.getName(), plugin.getLeftComponent());
            }
            if (plugin.getRightComponent() != null) {
                this.theRightPane.add(plugin.getName(), plugin.getRightComponent());
            }
            if (plugin.getBottomComponent() != null) {
                this.theBottomPane.add(plugin.getName(), plugin.getBottomComponent());
            }
        }
    }

    public Plugin get(String name) {
        return this.plugins.get(name);
    }

    public boolean hasPlugin(String name) {
        return this.get(name) != null;
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    public void show(String pname, String view) throws Exception {
        Plugin plugin = this.get(pname);
        if (plugin == null) {
            throw new Exception("Invalid plugin: " + pname);
        }
        if (plugin.getViewPosition(view) == 0) {
            this.theApplication.showLeftPanels();
            this.theLeftPane.setSelectedComponent(plugin.getLeftComponent());
        } else if (plugin.getViewPosition(view) == 1) {
            this.theApplication.showRightPanels();
            this.theRightPane.setSelectedComponent(plugin.getRightComponent());
        } else if (plugin.getViewPosition(view) == 2) {
            this.theApplication.showBottomPanels();
            this.theBottomPane.setSelectedComponent(plugin.getBottomComponent());
        }
        plugin.show(view);
    }

    public void addMsPeakAction(GlycanAction action) {
        if (action != null) {
            this.ms_peak_actions.add(action);
        }
    }

    public void removeMsPeakAction(GlycanAction action) {
        if (action != null) {
            this.ms_peak_actions.remove(action);
        }
    }

    public Vector<GlycanAction> getMsPeakActions() {
        return this.ms_peak_actions;
    }

    public GlycanAction getMsPeakAction(String action_command) {
        for (GlycanAction a : this.ms_peak_actions) {
            if (!a.getActionCommand().equals(action_command)) continue;
            return a;
        }
        return null;
    }

    public void addMsMsPeakAction(GlycanAction action) {
        if (action != null) {
            this.msms_peak_actions.add(action);
        }
    }

    public void removeMsMsPeakAction(GlycanAction action) {
        if (action != null) {
            this.msms_peak_actions.remove(action);
        }
    }

    public Vector<GlycanAction> getMsMsPeakActions() {
        return this.msms_peak_actions;
    }

    public GlycanAction getMsMsPeakAction(String action_command) {
        for (GlycanAction a : this.msms_peak_actions) {
            if (!a.getActionCommand().equals(action_command)) continue;
            return a;
        }
        return null;
    }

    public boolean runAction(GlycanAction action, Object params) throws Exception {
        if (action != null) {
            Plugin p = (Plugin)((Object)action.getMainListener());
            return p.runAction(action.getActionCommand(), params);
        }
        return false;
    }

    public boolean runAction(String plugin, String action) throws Exception {
        Plugin p = this.get(plugin);
        if (p == null) {
            throw new Exception("Invalid plugin: " + plugin);
        }
        return p.runAction(action);
    }

    public boolean runAction(String plugin, String action, Object param) throws Exception {
        Plugin p = this.get(plugin);
        if (p == null) {
            throw new Exception("Invalid plugin: " + plugin);
        }
        return p.runAction(action, param);
    }

    public void updateViews() {
        for (Plugin p : this.plugins.values()) {
            p.updateViews();
        }
    }

    public void updateMasses() {
        for (Plugin p : this.plugins.values()) {
            p.updateMasses();
        }
    }

    public void searchPlugins(String folder) {
        System.out.println("INFO: Searching for plugins within folder: " + folder);
        try {
            File folder_file;
            if (this.getClass().getClassLoader().getResourceAsStream("gwbPlugin.properties") != null) {
                LogUtils.report((Exception)new Exception("Error: Plugin infrastructure fault\nA resource identified by the string \"gwbPlugin.properties\" is available in the main class loader\nThe availability of this resource has blocked plugin loading\n"));
            }
            if (!(folder_file = new File(folder)).exists() || !folder_file.isDirectory()) {
                System.out.println("INFO: No plugin directory found");
                return;
            }
            File[] jars = folder_file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getPath().endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                System.out.println("INFO: Processing jar plugin: " + jars[i]);
                try {
                    URLClassLoader cl = new URLClassLoader(new URL[]{new URL(jars[i].toURL().toExternalForm())});
                    InputStream pps = cl.getResourceAsStream("gwbPlugin.properties");
                    if (pps == null) {
                        System.out.println("INFO: Jar doesn't contain property file gwbPlugin.properties - assuming it's not a plugin\nIf this is incorrect add the property file with the following properties (class=pluginClassName)");
                        continue;
                    }
                    Properties pp = new Properties();
                    pp.load(pps);
                    String class_name = pp.getProperty("class");
                    if (class_name != null) {
                        Class<?> class_type = cl.loadClass(class_name);
                        if (Plugin.class.isAssignableFrom(class_type)) {
                            Plugin plugin = (Plugin)class_type.newInstance();
                            plugin.setManager(this);
                            plugin.setApplication(this.theApplication);
                            this.add(plugin);
                            continue;
                        }
                        System.out.println("INFO: Plugin skipped, class " + class_type + " does not implement the interface " + Plugin.class);
                        continue;
                    }
                    System.out.println("INFO: Plugin skipped, no property with key \"class\" within gwbPlugin.properties file");
                    continue;
                }
                catch (Exception e) {
                    LogUtils.report((Exception)e);
                }
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void completeSetup() {
        for (Plugin p : this.getPlugins()) {
            p.completeSetup();
        }
    }
}

