/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.TypePattern;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGPosition;
import org.eurocarbdb.application.glycoworkbench.plugin.GeneratorListener;

public class GAGType {
    protected String family;
    protected String motif;
    protected int unit_size;
    protected TreeSet<GAGPosition> acetyl_pos;
    protected TreeSet<GAGPosition> opt_acetyl_pos;
    protected TreeSet<GAGPosition> sulfate_pos;
    protected TreeSet<GAGPosition> cooccurring_pos;
    protected String description;

    public GAGType() {
        this.family = "";
        this.motif = "";
        this.unit_size = 0;
        this.acetyl_pos = new TreeSet();
        this.opt_acetyl_pos = new TreeSet();
        this.sulfate_pos = new TreeSet();
        this.cooccurring_pos = new TreeSet();
        this.description = "";
    }

    public GAGType(String init) throws Exception {
        Vector tokens = TextUtils.tokenize((String)init, (String)"\t");
        if (tokens.size() != 7) {
            throw new Exception("Invalid string format: " + init);
        }
        this.family = (String)tokens.elementAt(0);
        this.motif = (String)tokens.elementAt(1);
        this.unit_size = Integer.parseInt((String)tokens.elementAt(2));
        this.acetyl_pos = this.parsePositions((String)tokens.elementAt(3));
        this.opt_acetyl_pos = this.parsePositions((String)tokens.elementAt(4));
        this.sulfate_pos = this.parsePositions((String)tokens.elementAt(5));
        this.description = (String)tokens.elementAt(6);
        this.cooccurring_pos = this.intersect(this.acetyl_pos, this.sulfate_pos);
    }

    public GAGType clone() {
        GAGType ret = new GAGType();
        ret.family = this.family;
        ret.motif = this.motif;
        ret.unit_size = this.unit_size;
        ret.acetyl_pos = new TreeSet<GAGPosition>((SortedSet<GAGPosition>)this.acetyl_pos);
        ret.opt_acetyl_pos = new TreeSet<GAGPosition>((SortedSet<GAGPosition>)this.opt_acetyl_pos);
        ret.sulfate_pos = new TreeSet<GAGPosition>((SortedSet<GAGPosition>)this.sulfate_pos);
        ret.cooccurring_pos = new TreeSet<GAGPosition>((SortedSet<GAGPosition>)this.cooccurring_pos);
        ret.description = this.description;
        return ret;
    }

    public GAGType allowUnlikelyAcetylation() {
        GAGType ret = this.clone();
        ret.acetyl_pos = ret.opt_acetyl_pos;
        ret.opt_acetyl_pos = new TreeSet();
        return ret;
    }

    public GAGType applyModifications(String[] modifications) {
        GAGType ret = this.clone();
        for (int i = 0; i < modifications.length; ++i) {
            if (modifications[i].equals("De 2-sulfation")) {
                this.removePosition(ret.sulfate_pos, '2');
                continue;
            }
            if (modifications[i].equals("De 6-sulfation")) {
                this.removePosition(ret.sulfate_pos, '6');
                continue;
            }
            if (modifications[i].equals("De N-sulfation")) {
                this.removePosition(ret.sulfate_pos, 'N');
                continue;
            }
            if (!modifications[i].equals("Re acetylation")) continue;
            this.removePosition(ret.sulfate_pos, 'N');
            ret.acetyl_pos.addAll(ret.opt_acetyl_pos);
        }
        ret.cooccurring_pos = this.intersect(ret.acetyl_pos, ret.sulfate_pos);
        return ret;
    }

    public String getFamily() {
        return this.family;
    }

    public Glycan getMotifStructure(GAGOptions opt) {
        try {
            String backbone = this.generateBackbone(1, opt.IS_REDUCED);
            Union<GAGPosition> s_pos = this.repeat(this.sulfate_pos, 1);
            Vector<GAGPosition> ac_pos = new Vector<GAGPosition>();
            if (opt.containsModification("Re acetylation")) {
                ac_pos = this.repeat(this.acetyl_pos, 1);
            }
            return this.generateStructure(backbone, (Collection<GAGPosition>)ac_pos, (Collection<GAGPosition>)s_pos, 1, 0, opt.DERIVATIZATION, opt.IS_UNSATURATED);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return new Glycan();
        }
    }

    public int getMaxNoAcetyls(int no_units) {
        no_units = Math.max(0, no_units);
        return no_units * this.acetyl_pos.size();
    }

    public int getMaxNoSulfates(int no_units, int no_acetyls) {
        no_units = Math.max(0, no_units);
        int max_no_acetyls = no_units * this.acetyl_pos.size();
        int max_no_sulfates = no_units * this.sulfate_pos.size();
        int no_cooccurring = no_units * this.cooccurring_pos.size();
        no_acetyls = Math.min(no_acetyls, max_no_acetyls);
        return max_no_sulfates - Math.max(0, no_acetyls - (max_no_acetyls - no_cooccurring));
    }

    public FragmentCollection generateStructures(GAGOptions opt) {
        FragmentCollection ret = new FragmentCollection();
        this.generateStructures(ret, null, opt);
        return ret;
    }

    public void generateStructures(GeneratorListener listener, GAGOptions opt) {
        this.generateStructures(null, listener, opt);
    }

    public void generateStructures(FragmentCollection buffer, GeneratorListener listener, GAGOptions opt) {
        for (int no_units = opt.MIN_NO_UNITS; no_units <= opt.MAX_NO_UNITS; ++no_units) {
            if (no_units <= 0) continue;
            String backbone = this.generateBackbone(no_units, opt.IS_REDUCED);
            int max_no_acetyls = 0;
            int min_no_acetyls = 0;
            if (opt.containsModification("Re acetylation")) {
                min_no_acetyls = max_no_acetyls = this.getMaxNoAcetyls(no_units);
            } else {
                max_no_acetyls = Math.min(opt.MAX_NO_ACETYLS, this.getMaxNoAcetyls(no_units));
                min_no_acetyls = Math.min(opt.MIN_NO_ACETYLS, max_no_acetyls);
            }
            for (int no_acetyls = min_no_acetyls; no_acetyls <= max_no_acetyls; ++no_acetyls) {
                int min_no_sulfates;
                int max_no_sulfates = Math.min(opt.MAX_NO_SULFATES, this.getMaxNoSulfates(no_units, no_acetyls));
                for (int no_sulfates = min_no_sulfates = Math.min(opt.MIN_NO_SULFATES, max_no_sulfates); no_sulfates <= max_no_sulfates; ++no_sulfates) {
                    if (this.generateStructures(buffer, listener, backbone, no_units, no_acetyls, no_sulfates, opt.DERIVATIZATION, opt.IS_UNSATURATED, opt.ALLOW_REDEND_LOSS)) continue;
                    return;
                }
            }
        }
    }

    private void removePosition(Collection<GAGPosition> pos_coll, char link_pos) {
        Iterator<GAGPosition> i = pos_coll.iterator();
        while (i.hasNext()) {
            GAGPosition pos = i.next();
            if (pos.linkage_pos != link_pos) continue;
            i.remove();
        }
    }

    private boolean generateStructures(FragmentCollection buffer, GeneratorListener listener, String backbone, int no_units, int no_acetyl, int no_sulfates, String derivatization, boolean unsaturated, boolean allow_redend_loss) {
        Vector<Union<GAGPosition>> combinations = new Vector<Union<GAGPosition>>();
        this.enumerateCombinations(combinations, (Union<GAGPosition>)new Union(), this.repeat(this.acetyl_pos, no_units), 0, no_acetyl);
        Union<GAGPosition> all_s_pos = this.repeat(this.sulfate_pos, no_units);
        for (Union<GAGPosition> ac_pos : combinations) {
            Glycan structure = this.generateStructure(backbone, (Collection<GAGPosition>)ac_pos, (Collection<GAGPosition>)all_s_pos, no_units, no_sulfates, derivatization, unsaturated);
            String name = "dp" + no_units * 2 + new TypePattern().and("Ac", ac_pos.size()).and("S", no_sulfates).toString();
            if (buffer != null) {
                buffer.addFragment(structure, name);
            }
            if (listener != null && !listener.generatorCallback(new FragmentEntry(structure, name))) {
                return false;
            }
            if (!allow_redend_loss) continue;
            structure = this.removeReducingEnd(structure);
            int no_ac = 0;
            for (GAGPosition pos : ac_pos) {
                if (pos.residue_id == 0) continue;
                ++no_ac;
            }
            int no_s = structure.countResidues("S");
            name = "dp" + (no_units * 2 - 1) + new TypePattern().and("Ac", no_ac).and("S", no_s).toString();
            if (buffer != null) {
                buffer.addFragment(structure, name);
            }
            if (listener == null || listener.generatorCallback(new FragmentEntry(structure, name))) continue;
            return false;
        }
        return true;
    }

    private Glycan removeReducingEnd(Glycan structure) {
        TypePattern detached;
        Glycan ret = structure.clone();
        Residue toremove = ret.getRoot().firstChild();
        int removed_placeholders = 0;
        Vector<Residue> toremove_children = new Vector<Residue>();
        for (Linkage l : toremove.getChildrenLinkages()) {
            if (!l.getChildResidue().isSaccharide()) {
                toremove_children.add(l.getChildResidue());
            }
            if (!l.getChildResidue().isLCleavage()) continue;
            ++removed_placeholders;
        }
        for (Residue r : toremove_children) {
            toremove.removeChild(r);
        }
        ret.getRoot().removeChild(ret.getRoot().firstChild());
        if (removed_placeholders > 0 && (detached = ret.getDetachedLabilesPattern()).size() > 0 && detached.contains(ret.getLabilePositionsPattern())) {
            ret = ret.removeDetachedLabiles().reattachAllLabileResidues();
        }
        return ret;
    }

    private Glycan generateStructure(String backbone, Collection<GAGPosition> ac_pos, Collection<GAGPosition> s_pos, int no_units, int no_sulfates, String derivatization, boolean unsaturated) {
        try {
            Glycan structure = Glycan.fromString((String)backbone, (MassOptions)this.createMassOptions(derivatization));
            if (unsaturated) {
                this.makeUnsaturated(structure);
            }
            int id = 0;
            boolean attach_sulfates = no_sulfates == this.getMaxNoSulfates(no_units, ac_pos.size());
            for (Residue nav = structure.getRoot().firstSaccharideChild(); nav != null; nav = nav.firstSaccharideChild()) {
                for (GAGPosition pos : ac_pos) {
                    if (id != pos.residue_id || pos.linkage_pos == 'N' && this.toHexNAc(nav)) continue;
                    nav.addChild(ResidueDictionary.newResidue((String)"Ac"), pos.linkage_pos);
                }
                for (GAGPosition pos : s_pos) {
                    if (id != pos.residue_id || ac_pos.contains(pos)) continue;
                    if (attach_sulfates) {
                        nav.addChild(ResidueDictionary.newResidue((String)"S"), pos.linkage_pos);
                        continue;
                    }
                    Residue l_cleav = new Residue(ResidueType.createLCleavage());
                    l_cleav.setCleavedResidue(ResidueDictionary.newResidue((String)"S"));
                    nav.addChild(l_cleav, pos.linkage_pos);
                }
                ++id;
            }
            if (!attach_sulfates) {
                for (int i = 0; i < no_sulfates; ++i) {
                    structure.addAntenna(ResidueDictionary.newResidue((String)"S"));
                }
            }
            return structure;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return new Glycan();
        }
    }

    public String generateBackbone(int nounits, boolean reduced) {
        String backbone = reduced ? "redEnd" : "freeEnd";
        for (int i = 0; i < nounits; ++i) {
            backbone = backbone + "--" + this.motif;
        }
        return backbone;
    }

    public void makeUnsaturated(Glycan structure) {
        if (structure == null || structure.getRoot() == null) {
            return;
        }
        Residue nav = structure.getRoot();
        while (true) {
            Residue child = null;
            for (Linkage l : nav.getChildrenLinkages()) {
                if (!l.getChildResidue().isSaccharide()) continue;
                child = l.getChildResidue();
                break;
            }
            if (child == null) break;
            nav = child;
        }
        char pos = '?';
        if (structure.getRoot().firstLinkage() != null) {
            pos = structure.getRoot().firstLinkage().getParentPositionsSingle();
        }
        try {
            if (ResidueDictionary.findResidueType((String)(pos + "u" + nav.getTypeName())) != null) {
                nav.setType(ResidueDictionary.getResidueType((String)(pos + "u" + nav.getTypeName())));
            } else {
                nav.addChild(ResidueDictionary.newResidue((String)"un"), pos);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public Union<GAGPosition> repeat(Collection<GAGPosition> positions, int times) {
        Union ret = new Union();
        for (int i = 0; i < times; ++i) {
            for (GAGPosition pos : positions) {
                ret.add((Object)pos.translate(i * this.unit_size));
            }
        }
        return ret;
    }

    public void enumerateCombinations(Vector<Union<GAGPosition>> buffer, Union<GAGPosition> combination, Union<GAGPosition> collection, int ind, int combination_size) {
        if (combination.size() == combination_size) {
            buffer.add(combination);
            return;
        }
        this.enumerateCombinations(buffer, (Union<GAGPosition>)combination.and(collection.elementAt(ind)), collection, ind + 1, combination_size);
        if (collection.size() - ind > combination_size - combination.size()) {
            this.enumerateCombinations(buffer, combination, collection, ind + 1, combination_size);
        }
    }

    public boolean toHexNAc(Residue r) {
        if (r == null) {
            return false;
        }
        try {
            if (r.getTypeName().equals("HexN")) {
                r.setType(ResidueDictionary.getResidueType((String)"HexNAc"));
                return true;
            }
            if (r.getTypeName().equals("GalN")) {
                r.setType(ResidueDictionary.getResidueType((String)"GalNAc"));
                return true;
            }
            if (r.getTypeName().equals("GlcN")) {
                r.setType(ResidueDictionary.getResidueType((String)"GlcNAc"));
                return true;
            }
            if (r.getTypeName().equals("ManN")) {
                r.setType(ResidueDictionary.getResidueType((String)"ManNAc"));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    private MassOptions createMassOptions(String derivatization) {
        MassOptions ret = new MassOptions();
        ret.DERIVATIZATION = derivatization;
        ret.ION_CLOUD = new IonCloud();
        return ret;
    }

    private TreeSet<GAGPosition> intersect(TreeSet<GAGPosition> s1, TreeSet<GAGPosition> s2) {
        TreeSet<GAGPosition> ret = new TreeSet<GAGPosition>();
        for (GAGPosition p : s1) {
            if (!s2.contains(p)) continue;
            ret.add(p);
        }
        return ret;
    }

    private TreeSet<GAGPosition> parsePositions(String str) throws Exception {
        TreeSet<GAGPosition> ret = new TreeSet<GAGPosition>();
        if (str.equals("-")) {
            return ret;
        }
        Vector tokens = TextUtils.tokenize((String)str, (String)",");
        for (String token : tokens) {
            ret.add(GAGPosition.fromString(token));
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.family);
        sb.append('\t');
        sb.append(this.motif);
        sb.append('\t');
        sb.append(TextUtils.toString(this.acetyl_pos, (char)','));
        sb.append('\t');
        sb.append(TextUtils.toString(this.sulfate_pos, (char)','));
        return sb.toString();
    }
}

