/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.table.CellPopupMenuAction;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;

public class GeneMenuConfiguration
extends AbstractUiBindingConfiguration {
    private Menu bodyMenu;
    private QrtPCRTableEditor editor;
    private QrtPCRData data;
    private Boolean raw;
    protected DataLayer bodyLayer;

    public GeneMenuConfiguration(QrtPCRTableEditor editor, QrtPCRData data, NatTable natTable, DataLayer bodyLayer, Boolean raw) {
        this.editor = editor;
        this.data = data;
        this.raw = raw;
        this.bodyLayer = bodyLayer;
        this.bodyMenu = this.createBodyMenu(natTable).build();
        natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GeneMenuConfiguration.this.bodyMenu.dispose();
            }
        });
    }

    private PopupMenuBuilder createBodyMenu(final NatTable natTable) {
        Menu menu = new Menu((Control)natTable);
        final MenuItem item3 = new MenuItem(menu, 8);
        item3.setText("Mark/Unmark as Rerun");
        item3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Gene clickedGene = (Gene)item3.getData();
                if (clickedGene != null) {
                    List<Gene> genes = GeneMenuConfiguration.this.data.getGenes();
                    for (Gene gene : genes) {
                        if (!gene.equals(clickedGene)) continue;
                        if (gene.getShouldRerun().booleanValue()) {
                            gene.setShouldRerun(false);
                            break;
                        }
                        gene.setShouldRerun(true);
                        break;
                    }
                    natTable.refresh();
                    GeneMenuConfiguration.this.editor.markDirty();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final MenuItem item4 = new MenuItem(menu, 8);
        item4.setText("Mark as Control");
        item4.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Gene clickedGene = (Gene)item4.getData();
                if (clickedGene != null) {
                    List<Gene> genes = GeneMenuConfiguration.this.data.getGenes();
                    for (Gene gene : genes) {
                        if (gene.getIsControl().booleanValue()) {
                            gene.setIsControl(false);
                        }
                        if (!gene.equals(clickedGene)) continue;
                        gene.setIsControl(true);
                    }
                    GeneMenuConfiguration.this.data.calculateNormValue();
                    natTable.refresh();
                    GeneMenuConfiguration.this.editor.markDirty();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return new PopupMenuBuilder(natTable, menu);
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        MouseEventMatcher matcher = new MouseEventMatcher(0, "BODY", 3){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                if (super.matches(natTable, event, regionLabels)) {
                    int columnPosition = natTable.getColumnPositionByX(event.x);
                    int columnIndex = LayerUtil.convertColumnPosition((ILayer)natTable, (int)columnPosition, (IUniqueIndexLayer)GeneMenuConfiguration.this.bodyLayer);
                    String column = ((QrtPCRNatTable)natTable).getColumnPropertyAccessor().getColumnProperty(columnIndex);
                    if (column.equals("Gene Identifier") && !GeneMenuConfiguration.this.raw.booleanValue()) {
                        int rowPosition = natTable.getRowPositionByY(event.y);
                        int bodyRowPos = LayerUtil.convertRowPosition((ILayer)natTable, (int)rowPosition, (IUniqueIndexLayer)GeneMenuConfiguration.this.bodyLayer);
                        TableData tableData = (TableData)((ListDataProvider)GeneMenuConfiguration.this.bodyLayer.getDataProvider()).getRowObject(bodyRowPos);
                        if (tableData instanceof Gene) {
                            GeneMenuConfiguration.this.bodyMenu.getItems()[0].setData((Object)tableData);
                            GeneMenuConfiguration.this.bodyMenu.getItems()[1].setData((Object)tableData);
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)matcher, (IMouseAction)new CellPopupMenuAction(this.bodyMenu));
    }
}

