/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.array.comparator;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.array.comparator.LIPsComparator;
import org.glycoinfo.WURCSFramework.util.array.comparator.MAPComparator;
import org.glycoinfo.WURCSFramework.wurcs.array.LIP;
import org.glycoinfo.WURCSFramework.wurcs.array.LIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;

public class MODComparator
implements Comparator<MOD> {
    private LIPsComparator m_oLIPsComp = new LIPsComparator();
    private MAPComparator m_oMAPComp = new MAPComparator();

    @Override
    public int compare(MOD o1, MOD o2) {
        int t_nLIPs2;
        int t_nLIPs1 = o1.getListOfLIPs().size();
        if (t_nLIPs1 != (t_nLIPs2 = o2.getListOfLIPs().size())) {
            return t_nLIPs2 - t_nLIPs1;
        }
        LinkedList<LIPs> t_aLIPs1 = o1.getListOfLIPs();
        LinkedList<LIPs> t_aLIPs2 = o2.getListOfLIPs();
        Collections.sort(t_aLIPs1, this.m_oLIPsComp);
        Collections.sort(t_aLIPs2, this.m_oLIPsComp);
        for (int i = 0; i < t_nLIPs1; ++i) {
            LIPs t_oLIPs2;
            LIPs t_oLIPs1 = t_aLIPs1.get(i);
            if (this.m_oLIPsComp.compare(t_oLIPs1, t_oLIPs2 = t_aLIPs2.get(i)) == 0) continue;
            return this.m_oLIPsComp.compare(t_oLIPs1, t_oLIPs2);
        }
        int t_iComp = this.m_oMAPComp.compare(o1.getMAPCode(), o2.getMAPCode());
        if (t_iComp != 0) {
            return t_iComp;
        }
        return 0;
    }

    private int countProbability(MOD a_oMOD) {
        int t_nProb = 0;
        for (LIPs t_oLIPs : a_oMOD.getListOfLIPs()) {
            for (LIP t_oLIP : t_oLIPs.getLIPs()) {
                if (t_oLIP.getBackboneProbabilityLower() == 1.0 && t_oLIP.getModificationProbabilityLower() == 1.0) continue;
                ++t_nProb;
            }
        }
        return t_nProb;
    }

    private int countUnkownPosition(MOD a_oMOD) {
        int t_nUnkown = 0;
        for (LIPs t_oLIPs : a_oMOD.getListOfLIPs()) {
            for (LIP t_oLIP : t_oLIPs.getLIPs()) {
                if (t_oLIP.getBackbonePosition() != -1) continue;
                ++t_nUnkown;
            }
        }
        return t_nUnkown;
    }

    private int countFuzzy(MOD a_oMOD) {
        int t_nFuzzy = 0;
        for (LIPs t_oLIPs : a_oMOD.getListOfLIPs()) {
            if (t_oLIPs.getLIPs().size() <= 1) continue;
            t_nFuzzy += t_oLIPs.getLIPs().size();
        }
        return t_nFuzzy;
    }
}

