/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util;

import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.glycoinfo.WURCSFramework.util.WURCSDataConverter;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIP;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.RES;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;

public class WURCSStructureUtils {
    private WURCSArray m_oWURCS;
    private TreeMap<Integer, TreeSet<Integer>> m_hashParentIDtoChildID = new TreeMap();

    public WURCSStructureUtils(WURCSArray a_oWURCS) {
        this.m_oWURCS = a_oWURCS;
        for (LIN t_oLIN : this.m_oWURCS.getLINs()) {
            GLIPs t_oChildGLIPs;
            GLIPs t_oParentGLIPs = t_oLIN.getListOfGLIPs().get(0);
            int t_iGLIPsComp = this.compareGLIPs(t_oParentGLIPs, t_oChildGLIPs = t_oLIN.getListOfGLIPs().get(1));
            if (t_iGLIPsComp > 0) {
                GLIPs tmp = t_oParentGLIPs;
                t_oParentGLIPs = t_oChildGLIPs;
                t_oChildGLIPs = tmp;
            }
            for (GLIP t_oParentGLIP : t_oParentGLIPs.getGLIPs()) {
                int t_iParentID = WURCSDataConverter.convertRESIndexToID(t_oParentGLIP.getRESIndex());
                if (!this.m_hashParentIDtoChildID.containsKey(t_iParentID)) {
                    this.m_hashParentIDtoChildID.put(t_iParentID, new TreeSet());
                }
                for (GLIP t_oChildGLIP : t_oChildGLIPs.getGLIPs()) {
                    int t_iChildID = WURCSDataConverter.convertRESIndexToID(t_oChildGLIP.getRESIndex());
                    this.m_hashParentIDtoChildID.get(t_iParentID).add(t_iChildID);
                }
            }
        }
    }

    public TreeMap<Integer, TreeSet<Integer>> getHashParentIDToChildID() {
        return this.m_hashParentIDtoChildID;
    }

    public String getLINStringCarbbankStyle(LIN a_oLIN) {
        GLIPs t_oChildGLIPs;
        if (a_oLIN.getListOfGLIPs().size() > 2) {
            return null;
        }
        GLIPs t_oParentGLIPs = a_oLIN.getListOfGLIPs().get(0);
        int t_iGLIPsComp = this.compareGLIPs(t_oParentGLIPs, t_oChildGLIPs = a_oLIN.getListOfGLIPs().get(1));
        if (t_iGLIPsComp > 0) {
            GLIPs tmp = t_oParentGLIPs;
            t_oParentGLIPs = t_oChildGLIPs;
            t_oChildGLIPs = tmp;
        }
        if (t_oChildGLIPs.getGLIPs().size() != 1) {
            return null;
        }
        LinkedList<UniqueRES> t_aParentURES = this.getUniqueRESFromGLIPs(t_oParentGLIPs);
        if (t_aParentURES.size() != 1) {
            return null;
        }
        String t_strLINString = "";
        LinkedList<UniqueRES> t_aChildURES = this.getUniqueRESFromGLIPs(t_oChildGLIPs);
        char t_cAnomSymbol = t_aChildURES.getFirst().getAnomericSymbol();
        if (t_cAnomSymbol == 'x') {
            t_cAnomSymbol = '?';
        }
        t_strLINString = "" + t_cAnomSymbol + t_aChildURES.getFirst().getAnomericPosition() + "-";
        String t_strParentPos = "";
        for (GLIP t_oGLIP : t_oParentGLIPs.getGLIPs()) {
            if (!t_strParentPos.equals("")) {
                t_strParentPos = t_strParentPos + "/";
            }
            t_strParentPos = t_strParentPos + t_oGLIP.getBackbonePosition();
        }
        t_strLINString = t_strLINString + t_strParentPos;
        return t_strLINString;
    }

    public LinkedList<UniqueRES> getParentUniqueRESOfLIN(LIN a_oLIN) {
        GLIPs t_oGLIPs2;
        if (a_oLIN.getListOfGLIPs().size() > 2) {
            return null;
        }
        GLIPs t_oParentGLIPs = null;
        GLIPs t_oGLIPs1 = a_oLIN.getListOfGLIPs().get(0);
        int t_iGLIPsComp = this.compareGLIPs(t_oGLIPs1, t_oGLIPs2 = a_oLIN.getListOfGLIPs().get(1));
        if (t_iGLIPsComp < 0) {
            t_oParentGLIPs = t_oGLIPs1;
        }
        if (t_iGLIPsComp > 0) {
            t_oParentGLIPs = t_oGLIPs2;
        }
        if (t_iGLIPsComp == 0) {
            return null;
        }
        return this.getUniqueRESFromGLIPs(t_oParentGLIPs);
    }

    public LinkedList<UniqueRES> getChildUniqueRESOfLIN(LIN a_oLIN) {
        GLIPs t_oGLIPs2;
        if (a_oLIN.getListOfGLIPs().size() > 2) {
            return null;
        }
        GLIPs t_oChildGLIPs = null;
        GLIPs t_oGLIPs1 = a_oLIN.getListOfGLIPs().get(0);
        int t_iGLIPsComp = this.compareGLIPs(t_oGLIPs1, t_oGLIPs2 = a_oLIN.getListOfGLIPs().get(1));
        if (t_iGLIPsComp < 0) {
            t_oChildGLIPs = t_oGLIPs2;
        }
        if (t_iGLIPsComp > 0) {
            t_oChildGLIPs = t_oGLIPs1;
        }
        if (t_iGLIPsComp == 0) {
            return null;
        }
        return this.getUniqueRESFromGLIPs(t_oChildGLIPs);
    }

    private int compareGLIPs(GLIPs a_oGLIPs1, GLIPs a_oGLIPs2) {
        int t_iPos2;
        int t_iRESID2;
        int t_iRESID1 = WURCSDataConverter.convertRESIndexToID(a_oGLIPs1.getGLIPs().getLast().getRESIndex());
        if (t_iRESID1 < (t_iRESID2 = WURCSDataConverter.convertRESIndexToID(a_oGLIPs2.getGLIPs().getLast().getRESIndex()))) {
            return -1;
        }
        if (t_iRESID1 > t_iRESID2) {
            return 1;
        }
        int t_iPos1 = a_oGLIPs1.getGLIPs().getLast().getBackbonePosition();
        if (t_iPos1 < (t_iPos2 = a_oGLIPs2.getGLIPs().getLast().getBackbonePosition())) {
            return -1;
        }
        if (t_iPos1 > t_iPos2) {
            return 1;
        }
        return 0;
    }

    private LinkedList<UniqueRES> getUniqueRESFromGLIPs(GLIPs a_oGLIPs) {
        if (a_oGLIPs == null) {
            return null;
        }
        LinkedList<String> t_aRESIndexes = new LinkedList<String>();
        for (GLIP t_oGLIP : a_oGLIPs.getGLIPs()) {
            if (t_aRESIndexes.contains(t_oGLIP.getRESIndex())) continue;
            t_aRESIndexes.add(t_oGLIP.getRESIndex());
        }
        LinkedList<UniqueRES> t_aURESs = new LinkedList<UniqueRES>();
        for (RES t_oRES : this.m_oWURCS.getRESs()) {
            if (!t_aRESIndexes.contains(t_oRES.getRESIndex())) continue;
            for (UniqueRES t_oURES : this.m_oWURCS.getUniqueRESs()) {
                if (t_oRES.getUniqueRESID() != t_oURES.getUniqueRESID()) continue;
                t_aURESs.add(t_oURES);
            }
        }
        return t_aURESs;
    }
}

