/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Bond;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.PermutationGenerator;
import org.eurocarbdb.application.glycanbuilder.Residue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linkage {
    private Residue parent;
    private Residue child;
    private Vector<Bond> bonds;

    public Linkage() {
        this.parent = null;
        this.child = null;
        this.setLinkagePositions('?');
    }

    public Linkage(Residue _parent, Residue _child) {
        this.parent = _parent;
        this.child = _child;
        this.setLinkagePositions('?');
    }

    public Linkage(Residue _parent, Residue _child, char link_pos) {
        this.parent = _parent;
        this.child = _child;
        this.setLinkagePositions(link_pos);
    }

    public Linkage(Residue _parent, Residue _child, char[] link_poss) {
        this.parent = _parent;
        this.child = _child;
        this.setLinkagePositions(link_poss);
    }

    public Linkage(Residue _parent, Residue _child, char[] link_poss, char[] second_p_poss, char second_c_pos) {
        this.parent = _parent;
        this.child = _child;
        this.setLinkagePositions(link_poss, second_p_poss, second_c_pos);
    }

    public Linkage(Residue _parent, Residue _child, Collection<Bond> _bonds) {
        this.parent = _parent;
        this.child = _child;
        this.setLinkagePositions(_bonds);
    }

    public Residue getParentResidue() {
        return this.parent;
    }

    public void setParentResidue(Residue _parent) {
        this.parent = _parent;
    }

    public Residue getChildResidue() {
        return this.child;
    }

    public void setChildResidue(Residue _child) {
        this.child = _child;
    }

    public Vector<Bond> getBonds() {
        return this.bonds;
    }

    public Vector<Bond> getBondsSorted() {
        Vector<Bond> ret = new Vector<Bond>(this.bonds);
        Collections.sort(ret, new Bond.Comparator());
        return ret;
    }

    public void setBonds(Vector<Bond> _bonds) {
        if (_bonds != null && _bonds.size() > 0) {
            this.bonds = _bonds;
            this.setAnomericCarbon(this.child.getAnomericCarbon());
        } else {
            this.setLinkagePositions('?');
        }
    }

    public Bond glycosidicBond() {
        return this.bonds.get(this.bonds.size() - 1);
    }

    public int getNoBonds() {
        return this.bonds.size();
    }

    public boolean hasSingleBond() {
        return this.bonds.size() == 1;
    }

    public boolean hasMultipleBonds() {
        return this.bonds.size() > 1;
    }

    public void setLinkagePositions(char link_pos) {
        this.bonds = new Vector(0, 1);
        char c_pos = this.child == null ? (char)'?' : (char)this.child.getAnomericCarbon();
        this.bonds.add(new Bond(link_pos, c_pos));
    }

    public void setLinkagePositions(char[] link_poss) {
        this.bonds = new Vector(0, 1);
        char c_pos = this.child == null ? (char)'?' : (char)this.child.getAnomericCarbon();
        this.bonds.add(new Bond(link_poss, c_pos));
    }

    public void setLinkagePositions(char[] link_poss, char[] second_p_poss, char second_c_pos) {
        this.bonds = new Vector(0, 1);
        this.bonds.add(new Bond(second_p_poss, second_c_pos));
        char c_pos = this.child == null ? (char)'?' : (char)this.child.getAnomericCarbon();
        this.bonds.add(new Bond(link_poss, c_pos));
    }

    public void setLinkagePositions(Collection<Bond> _bonds) {
        this.bonds = new Vector(0, 1);
        for (Bond toadd : _bonds) {
            this.bonds.add(toadd.clone());
        }
        if (this.bonds.size() == 0) {
            this.bonds.add(new Bond());
        }
        if (this.child != null) {
            this.setAnomericCarbon(this.child.getAnomericCarbon());
        }
    }

    public void setAnomericCarbon(char pos) {
        this.glycosidicBond().setChildPosition(pos);
    }

    public char getAnomericCarbon() {
        return this.glycosidicBond().getChildPosition();
    }

    public Collection<Character> getParentPositions() {
        Vector<Character> ret = new Vector<Character>();
        for (Bond b : this.bonds) {
            char[] p_poss = b.getParentPositions();
            for (int i = 0; i < p_poss.length; ++i) {
                ret.add(Character.valueOf(p_poss[i]));
            }
        }
        return ret;
    }

    public Collection<Character> getChildPositions() {
        Vector<Character> ret = new Vector<Character>();
        for (int i = 0; i < this.bonds.size(); ++i) {
            ret.add(Character.valueOf(this.bonds.get(i).getChildPosition()));
        }
        return ret;
    }

    public String getParentPositionsString() {
        StringBuilder sb = new StringBuilder();
        for (Bond b : this.getBondsSorted()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            char[] p_poss = b.getParentPositions();
            for (int i = 0; i < p_poss.length; ++i) {
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(p_poss[i]);
            }
        }
        return sb.toString();
    }

    public String getChildPositionsString() {
        StringBuilder sb = new StringBuilder();
        for (Bond b : this.getBondsSorted()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(b.getChildPosition());
        }
        return sb.toString();
    }

    public boolean hasSingleLinkagePosition() {
        return this.bonds.size() == 1 && this.bonds.get(0).getParentPositions().length == 1;
    }

    public char getParentPositionsSingle() {
        if (this.bonds.size() == 1 && this.bonds.get(0).getParentPositions().length == 1) {
            return this.bonds.get(0).getParentPositions()[0];
        }
        return '?';
    }

    public char getChildPositionsSingle() {
        if (this.bonds.size() == 1) {
            return this.bonds.get(0).getChildPosition();
        }
        return '?';
    }

    public boolean hasUncertainParentPositions() {
        for (Bond b : this.bonds) {
            if (b.getParentPositions().length <= 1 && b.getParentPositions()[0] != '?') continue;
            return true;
        }
        return false;
    }

    public boolean hasUncertainChildPositions() {
        for (Bond b : this.bonds) {
            if (b.getChildPosition() != '?') continue;
            return true;
        }
        return false;
    }

    public boolean subtreeEquals(Linkage other) {
        if (other == null) {
            return false;
        }
        if (this.bonds.size() != other.bonds.size()) {
            return false;
        }
        for (int i = 0; i < this.bonds.size(); ++i) {
            if (!this.bonds.get(i).equals(other.bonds.get(i))) {
                return false;
            }
            if (this.child.subtreeEquals(other.child)) continue;
            return false;
        }
        return true;
    }

    public boolean fuzzyMatch(Linkage other) {
        return this.match(other, true);
    }

    public boolean match(Linkage other, boolean fuzzy) {
        if (other == null) {
            return false;
        }
        if (this.bonds.size() != other.bonds.size()) {
            return false;
        }
        PermutationGenerator cg = new PermutationGenerator(other.bonds.size());
        while (cg.hasMore()) {
            int i;
            int[] indices = cg.getNext();
            for (i = 0; i < this.bonds.size() && this.bonds.get(i).match(other.bonds.get(indices[i]), fuzzy); ++i) {
            }
            if (i != this.bonds.size()) continue;
            return true;
        }
        return false;
    }

    public String toIupac() {
        StringBuilder sb = new StringBuilder();
        if (this.hasSingleLinkagePosition() && this.child.getAnomericState() != '?' && !this.hasUncertainChildPositions() && !this.hasUncertainParentPositions()) {
            sb.append(this.child.getAnomericState());
        }
        if (!this.hasUncertainChildPositions() && !this.hasUncertainParentPositions()) {
            sb.append(this.getChildPositionsString());
        }
        if (this.hasSingleLinkagePosition()) {
            sb.append("-");
        } else {
            sb.append("=");
        }
        if (!this.hasUncertainParentPositions()) {
            sb.append(this.getParentPositionsString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkageComparator
    implements Comparator<Linkage> {
        @Override
        public int compare(Linkage o1, Linkage o2) {
            return GWSParser.toStringLinkage(o1).compareTo(GWSParser.toStringLinkage(o2));
        }
    }
}

