/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHistory {
    private static final int MAX_ITEM_LEN = 50;
    private static final String FILE_SEPARATOR_STR = System.getProperty("file.separator");
    protected String recent_folder = null;
    protected LinkedList<String> recent_files = new LinkedList();
    protected HashMap<String, String> file_types = new HashMap();
    protected Vector<Listener> listeners = new Vector();

    public void addHistoryChangedListener(Listener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeHistoryChangedListener(Listener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void clear() {
        this.recent_folder = null;
        this.recent_files.clear();
        this.file_types.clear();
    }

    public void add(String filename) {
        if (filename != null) {
            this.add(new File(filename), "");
        }
    }

    public void add(String filename, String type) {
        if (filename != null) {
            this.add(new File(filename), type);
        }
    }

    public void add(File file) {
        this.add(file, "");
    }

    public void add(File file, String type) {
        if (file != null) {
            this.recent_folder = file.getParentFile().getAbsolutePath();
            String file_path = file.getAbsolutePath();
            this.recent_files.remove(file_path);
            this.recent_files.addFirst(file_path);
            this.file_types.put(file_path, type);
            if (this.recent_files.size() > 8) {
                this.file_types.remove(this.recent_files.removeLast());
            }
            Iterator<Listener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().fileHistoryChanged();
            }
        }
    }

    public void remove(String filename) {
        if (filename != null) {
            this.remove(new File(filename));
        }
    }

    public void remove(File file) {
        if (file != null) {
            String file_path = file.getAbsolutePath();
            this.recent_files.remove(file_path);
            this.file_types.remove(file_path);
            Iterator<Listener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().fileHistoryChanged();
            }
        }
    }

    public File getRecentFolder() {
        if (this.recent_folder == null) {
            return new File(System.getProperty("user.home"));
        }
        return new File(this.recent_folder);
    }

    public List<String> getRecentFiles() {
        return this.recent_files;
    }

    public Iterator<String> iterator() {
        return this.recent_files.iterator();
    }

    public String getFileType(String pathname) {
        return this.file_types.get(pathname);
    }

    public static String getAbbreviatedName(String pathname) {
        char FILE_SEPARATOR = FILE_SEPARATOR_STR.charAt(0);
        int pathnameLen = pathname.length();
        String cwd_path = FileUtils.getRootDir();
        if (pathname.startsWith(cwd_path)) {
            return pathname.substring(cwd_path.length() + 1);
        }
        if (pathnameLen <= 50) {
            return pathname;
        }
        if (pathname.indexOf(FILE_SEPARATOR_STR) == pathname.lastIndexOf(FILE_SEPARATOR_STR)) {
            return pathname;
        }
        int ABBREVIATED_PREFIX_LEN = FILE_SEPARATOR_STR.length() == 1 ? 5 : 7;
        int MAX_PATHNAME_LEN = 50 - ABBREVIATED_PREFIX_LEN;
        int firstFileSeparatorIndex = 0;
        for (int i = pathnameLen - 1; i >= pathnameLen - MAX_PATHNAME_LEN; --i) {
            if (pathname.charAt(i) != FILE_SEPARATOR) continue;
            firstFileSeparatorIndex = i;
        }
        if (firstFileSeparatorIndex > 0) {
            return pathname.substring(0, ABBREVIATED_PREFIX_LEN - 4) + "..." + pathname.substring(firstFileSeparatorIndex, pathnameLen);
        }
        return pathname.substring(0, ABBREVIATED_PREFIX_LEN - 4) + "..." + FILE_SEPARATOR_STR + ".." + pathname.substring(pathnameLen - MAX_PATHNAME_LEN, pathnameLen);
    }

    public void store(Configuration config) {
        int c;
        for (c = 0; c < 8; ++c) {
            config.put("FileHistory", "file_path" + c, "");
            config.put("FileHistory", "file_type" + c, "");
        }
        c = 0;
        for (String file_path : this.recent_files) {
            config.put("FileHistory", "file_path" + c, file_path);
            config.put("FileHistory", "file_type" + c, this.getFileType(file_path));
            ++c;
        }
    }

    public void retrieve(Configuration config) {
        this.clear();
        for (int c = 0; c < 8; ++c) {
            String file_path = config.get("FileHistory", "file_path" + c);
            String file_type = config.get("FileHistory", "file_type" + c);
            if (file_path == null || file_path.length() <= 0) continue;
            this.recent_files.addLast(file_path);
            this.file_types.put(file_path, file_type);
        }
    }

    public static interface Listener {
        public void fileHistoryChanged();
    }
}

