/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import java.util.HashMap;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.DefaultParamHandler;

public abstract class SignalToNoiseEstimator
extends DefaultParamHandler {
    protected Peak[] data_ = null;
    protected int first_ = 0;
    protected int last_ = 0;
    protected boolean is_result_valid_ = false;
    protected HashMap<Peak, Double> stn_estimates_ = new HashMap();

    public SignalToNoiseEstimator() {
        super("SignalToNoiseEstimator");
    }

    public int getFirstDataPoint() {
        return this.first_;
    }

    public void setFirstDataPoint(int first) {
        this.is_result_valid_ = false;
        this.first_ = first;
    }

    public int getLastDataPoint() {
        return this.last_;
    }

    public void setLastDataPoint(int last) {
        this.is_result_valid_ = false;
        this.last_ = last;
    }

    public abstract double getMaxIntensity();

    public abstract void setMaxIntensity(double var1);

    public abstract double getAutoMaxStdevFactor();

    public abstract void setAutoMaxStdevFactor(double var1);

    public abstract double getAutoMaxPercentile();

    public abstract void setAutoMaxPercentile(double var1);

    public abstract int getAutoMode();

    public abstract void setAutoMode(int var1);

    public abstract double getWinLen();

    public abstract void setWinLen(double var1);

    public abstract int getBinCount();

    public abstract void setBinCount(int var1);

    public abstract int getMinReqElements();

    public abstract void setMinReqElements(int var1);

    public abstract double getNoiseForEmptyWindow();

    public abstract void setNoiseForEmptyWindow(double var1);

    public void init(Peak[] data, int it_begin, int it_end) {
        this.data_ = data;
        this.first_ = it_begin;
        this.last_ = it_end;
        try {
            this.computeSTN_(this.data_, this.first_, this.last_);
            this.is_result_valid_ = true;
        }
        catch (Exception e) {
            System.err.println(e);
            this.is_result_valid_ = false;
        }
    }

    public void init(Peak[] data) {
        this.init(data, 0, data.length);
    }

    public double getSignalToNoise(int data_point) {
        if (!this.is_result_valid_) {
            this.init(this.data_, this.first_, this.last_);
        }
        return this.stn_estimates_.get(this.data_[data_point]);
    }

    protected abstract void computeSTN_(Peak[] var1, int var2, int var3) throws Exception;

    protected static GaussianEstimate estimate_(Peak[] data_, int scan_first_, int scan_last_) {
        int run;
        int size = 0;
        double v = 0.0;
        double m = 0.0;
        for (run = scan_first_; run != scan_last_; ++run) {
            m += data_[run].getIntensity();
            ++size;
        }
        m /= (double)size;
        for (run = scan_first_; run != scan_last_; ++run) {
            v += Math.pow(m - data_[run].getIntensity(), 2.0);
        }
        return new GaussianEstimate(m, v /= (double)size);
    }

    protected static final class GaussianEstimate {
        public double mean = 0.0;
        public double variance = 0.0;

        public GaussianEstimate(double m, double v) {
            this.mean = m;
            this.variance = v;
        }
    }
}

