/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eurocarbdb.MolecularFramework.io.CarbohydrateSequenceEncoding;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.GlycanParserFactory;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.CollectionStructureGenerator;
import org.eurocarbdb.application.glycoworkbench.plugin.DictionariesEditPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.DictionariesManagerPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.DictionariesSearchPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.DictionaryStructureGenerator;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerThread;
import org.eurocarbdb.application.glycoworkbench.plugin.ProgressDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.QuickStartup;
import org.eurocarbdb.application.glycoworkbench.plugin.SearchDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.StoreStructuresDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureDictionary;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureGenerator;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.wggds.webservices.io.QueryResultProcessor;
import org.wggds.webservices.io.data.CompleteInformation;
import org.wggds.webservices.io.data.OutputFormat;
import org.wggds.webservices.io.data.QueryResultHeader;
import org.wggds.webservices.io.data.ServerSideError;
import org.wggds.webservices.io.data.StructureResult;
import org.wggds.webservices.io.query.SubstructureQuery;

public class ProfilerPlugin
implements Plugin,
ActionListener,
BaseDocument.DocumentChangeListener,
QuickStartup {
    protected PluginManager theManager = null;
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = null;
    protected JTabbedPane theDictionariesPane = null;
    protected DictionariesManagerPanel theDictionariesManagerPanel = null;
    protected DictionariesEditPanel theDictionariesEditPanel = null;
    protected DictionariesSearchPanel theDictionariesSearchPanel = null;
    protected TreeMap<String, StructureDictionary> theDictionaries = null;
    protected TreeMap<String, StructureDictionary> theUserDictionaries = null;
    protected ProfilerOptions theProfilerOptions = null;
    protected boolean first_time_run = true;
    protected boolean showTopResults = true;
    protected ProfilerThread theThread = null;
    protected ProgressDialog progressDialog = null;
    protected Timer activityMonitor = null;
    protected boolean annotate = true;
    protected boolean merge = false;
    Vector<DictionariesChangeListener> dc_listeners = new Vector();
    public static String PLUGIN_NAME = "Profiler";
    protected HashMap<String, GlycanAction> publicActionMap = new HashMap();

    public ProfilerPlugin(GlycoWorkbench bench) {
        this.theApplication = bench;
        try {
            this.theDictionaries = new TreeMap();
            this.theUserDictionaries = new TreeMap();
            this.theDictionariesPane = new JTabbedPane();
            this.theDictionariesManagerPanel = new DictionariesManagerPanel(this);
            this.theDictionariesPane.add("Databases", this.theDictionariesManagerPanel);
            this.theDictionariesEditPanel = new DictionariesEditPanel(this);
            this.theDictionariesPane.add("Structures", this.theDictionariesEditPanel);
            this.theDictionariesSearchPanel = new DictionariesSearchPanel(this);
            this.theDictionariesPane.add("Search", this.theDictionariesSearchPanel);
            this.theDictionariesPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    JTabbedPane pane = (JTabbedPane)evt.getSource();
                    int sel = pane.getSelectedIndex();
                    if (sel == 1) {
                        ProfilerPlugin.this.theDictionariesEditPanel.enableProfiler();
                    }
                }
            });
            this.theProfilerOptions = new ProfilerOptions();
            GlycanAction glycanAction = new GlycanAction("matchDatabase", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("database_annotate", Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with structures from the database", 78, "", (ActionListener)this);
            this.addActionToPublicMap(glycanAction);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public void deferredOnStartup() {
    }

    public DictionariesManagerPanel getDictionariesManagerPanel() {
        return this.theDictionariesManagerPanel;
    }

    public DictionariesEditPanel getDictionariesEditPanel() {
        return this.theDictionariesEditPanel;
    }

    public DictionariesSearchPanel getDictionariesSearchPanel() {
        return this.theDictionariesSearchPanel;
    }

    public boolean containsDictionary(StructureDictionary dict) {
        if (dict == null) {
            return false;
        }
        for (StructureDictionary sd : this.theDictionaries.values()) {
            if (!sd.getDictionaryName().equals(dict.getDictionaryName()) && !sd.getFileName().equals(dict.getFileName())) continue;
            return true;
        }
        return false;
    }

    public void addDictionary(final StructureDictionary dict) {
        final ProfilerPlugin self = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (dict == null || ProfilerPlugin.this.containsDictionary(dict)) {
                    return;
                }
                dict.addDocumentChangeListener(self);
                ProfilerPlugin.this.theDictionaries.put(dict.getDictionaryName(), dict);
                ProfilerPlugin.this.fireDictionaryAdded(dict);
            }
        });
    }

    public void removeDictionary(StructureDictionary dict) {
        if (!this.containsDictionary(dict)) {
            return;
        }
        dict.removeDocumentChangeListener(this);
        this.theDictionaries.remove(dict.getDictionaryName());
        this.theUserDictionaries.remove(dict.getDictionaryName());
        this.theProfilerOptions.USER_DICTIONARIES_FILENAME.remove(dict.getFileName());
        this.fireDictionaryRemoved(dict);
    }

    public void addUserDictionary(StructureDictionary dict) {
        if (dict == null || this.containsDictionary(dict)) {
            return;
        }
        dict.addDocumentChangeListener(this);
        this.theUserDictionaries.put(dict.getDictionaryName(), dict);
        this.theDictionaries.put(dict.getDictionaryName(), dict);
        this.theProfilerOptions.USER_DICTIONARIES_FILENAME.add(dict.getFileName());
        this.fireDictionaryAdded(dict);
    }

    public void saveUserDictionaries() throws Exception {
        for (StructureDictionary sd : this.theUserDictionaries.values()) {
            sd.save();
        }
    }

    @Override
    public void init() {
        if (this.theWorkspace != null) {
            this.theProfilerOptions.retrieve(this.theWorkspace.getConfiguration());
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (String filename : ProfilerPlugin.this.theProfilerOptions.USER_DICTIONARIES_FILENAME) {
                            if (!FileUtils.exists((String)filename)) continue;
                            StructureDictionary dict = new StructureDictionary(filename, true, null);
                            System.out.print("Loading " + dict.getDictionaryName());
                            if (GlycoWorkbench.isUpdateRun()) {
                                System.out.print(" => GlycoWorkbench update detected ");
                                if (dict.getSourceFile().equals("")) {
                                    System.out.println(" => not updating none builtin resource ");
                                } else if (dict.hasBeenSynced()) {
                                    System.out.println(" => not updating builtin resource, sync has been performed");
                                } else {
                                    System.out.println(" => updating resource, to latest builtin version");
                                    dict.restore();
                                }
                            } else {
                                System.out.println("");
                            }
                            ProfilerPlugin.this.theUserDictionaries.put(dict.getDictionaryName(), dict);
                            ProfilerPlugin.this.theDictionaries.put(dict.getDictionaryName(), dict);
                        }
                        if (ProfilerPlugin.this.getDictionary("CFG") == null) {
                            System.out.println("Loading builtin CFG database");
                            ProfilerPlugin.this.addDictionary(new StructureDictionary("/conf/cfg_dict.gwd", false, null).setGlycoWorkbenchResource(true));
                        }
                        if (ProfilerPlugin.this.getDictionary("Carbbank") == null) {
                            System.out.println("Loading builtin Carbbank database");
                            ProfilerPlugin.this.addDictionary(new StructureDictionary("/conf/carbbankraw_dict.gwd", false, null).setGlycoWorkbenchResource(true));
                        }
                        if (ProfilerPlugin.this.getDictionary("Glycosciences") == null) {
                            System.out.println("Loading builtin Glycosciences database");
                            ProfilerPlugin.this.addDictionary(new StructureDictionary("/conf/glycosciences_dict.gwd", false, null).setGlycoWorkbenchResource(true));
                        }
                        if (ProfilerPlugin.this.getDictionary("GlycomeDB") == null) {
                            System.out.println("Loading builtin GlycomeDB database");
                            ProfilerPlugin.this.addDictionary(new StructureDictionary("/conf/glycomedb_dict.gwd", false, null).setGlycoWorkbenchResource(true));
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (StructureDictionary structureDictionary : ProfilerPlugin.this.theDictionaries.values()) {
                                    structureDictionary.setFireDocumentChanged(true);
                                    structureDictionary.fireDocumentChanged();
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LogUtils.report((Exception)ex);
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ProfilerPlugin.this.fireDictionariesInit();
                                    }
                                    catch (Exception e) {
                                        LogUtils.report((Exception)e);
                                    }
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            thread.start();
        }
    }

    @Override
    public void exit() {
        if (this.theWorkspace != null) {
            this.theProfilerOptions.store(this.theWorkspace.getConfiguration());
        }
    }

    public StructureDictionary getDictionary(String name) {
        if (name == null) {
            return null;
        }
        return this.theDictionaries.get(name);
    }

    public Collection<StructureDictionary> getDictionaries() {
        return this.theDictionaries.values();
    }

    public Collection<StructureDictionary> getUserDictionaries() {
        return this.theUserDictionaries.values();
    }

    public Collection<String> getDictionaryNames() {
        return this.theDictionaries.keySet();
    }

    public Collection<String> getUserDictionaryNames() {
        return this.theUserDictionaries.keySet();
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public int getMnemonic() {
        return 80;
    }

    @Override
    public ImageIcon getIcon() {
        return ThemeManager.getEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE);
    }

    @Override
    public int getViewPosition(String view) {
        return 1;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return this.theDictionariesPane;
    }

    @Override
    public Component getBottomComponent() {
        return null;
    }

    @Override
    public Collection<String> getViews() {
        Vector<String> views = new Vector<String>();
        views.add("Databases");
        views.add("Structures");
        views.add("Search");
        return views;
    }

    public GlycanAction getAction(String action) {
        return this.publicActionMap.get(action);
    }

    private void addActionToPublicMap(GlycanAction glycanAction) {
        this.publicActionMap.put(glycanAction.getActionCommand(), glycanAction);
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("options", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Set plugin options", 79, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("findDatabase", this.theApplication.getThemeManager().getResizableIcon("finddatabase", Plugin.DEFAULT_ICON_SIZE), "Find all structures with a given m/z value", 70, "", (ActionListener)this));
        actions.add(this.getAction("matchDatabase"));
        actions.add(null);
        actions.add(new GlycanAction("matchStructuresCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with current structure", 67, "", (ActionListener)this));
        actions.add(new GlycanAction("matchStructuresSelected", this.theApplication.getThemeManager().getResizableIcon("matchstructures", Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with selected structures", 83, "", (ActionListener)this));
        actions.add(new GlycanAction("matchStructuresAll", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with all structures", 65, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("search", this.theApplication.getThemeManager().getResizableIcon("search", Plugin.DEFAULT_ICON_SIZE), "Search the databases", 68, "", (ActionListener)this));
        actions.add(new GlycanAction("searchAgain", this.theApplication.getThemeManager().getResizableIcon("searchagain", Plugin.DEFAULT_ICON_SIZE), "Filter the search results", 82, "", (ActionListener)this));
        actions.add(new GlycanAction("searchCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Search for the current structure in the databases", 72, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("storeStructuresCurrent", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Store current structure in a user database", 85, "", (ActionListener)this));
        actions.add(new GlycanAction("storeStructuresSelected", this.theApplication.getThemeManager().getResizableIcon("storedatabase", Plugin.DEFAULT_ICON_SIZE), "Store selected structures in a user database", 69, "", (ActionListener)this));
        actions.add(new GlycanAction("storeStructuresAll", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Store all structures in a user database", 76, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("matchStructuresSelected", this.theApplication.getThemeManager().getResizableIcon("matchstructures", Plugin.DEFAULT_ICON_SIZE), "Annotate peaks with selected structures", 83, "", (ActionListener)this));
        actions.add(new GlycanAction("findDatabase", this.theApplication.getThemeManager().getResizableIcon("finddatabase", Plugin.DEFAULT_ICON_SIZE), "Find all structures with a given m/z value", 70, "", (ActionListener)this));
        actions.add(new GlycanAction("storeStructuresSelected", this.theApplication.getThemeManager().getResizableIcon("storedatabase", Plugin.DEFAULT_ICON_SIZE), "Store selected structures in a user database", 69, "", (ActionListener)this));
        actions.add(new GlycanAction("search", this.theApplication.getThemeManager().getResizableIcon("search", Plugin.DEFAULT_ICON_SIZE), "Search the databases", 68, "", (ActionListener)this));
        actions.add(new GlycanAction("searchAgain", this.theApplication.getThemeManager().getResizableIcon("searchagain", Plugin.DEFAULT_ICON_SIZE), "Filter the search results", 82, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
        if (this.theManager != null) {
            this.theManager.addMsPeakAction(new GlycanAction("findDatabase", this.theApplication.getThemeManager().getResizableIcon("finddatabase", Plugin.DEFAULT_ICON_SIZE), "Find all structures matching the peaks", 68, "", (ActionListener)this));
        }
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
        this.theDictionariesManagerPanel.setApplication(application);
        this.theDictionariesEditPanel.setApplication(application);
        this.theDictionariesSearchPanel.setApplication(application);
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        this.theDictionariesManagerPanel.setWorkspace(workspace);
        this.theDictionariesEditPanel.setWorkspace(workspace);
        this.theDictionariesSearchPanel.setWorkspace(workspace);
        if (this.theWorkspace != null) {
            this.theProfilerOptions.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    public ProfilerOptions getOptions() {
        return this.theProfilerOptions;
    }

    @Override
    public void show(String view) throws Exception {
        if (view.equals("Databases")) {
            this.theDictionariesPane.setSelectedComponent(this.theDictionariesManagerPanel);
        } else if (view.equals("Structures")) {
            this.theDictionariesEditPanel.enableProfiler();
            this.theDictionariesPane.setSelectedComponent(this.theDictionariesEditPanel);
        } else if (view.equals("Search")) {
            this.theDictionariesPane.setSelectedComponent(this.theDictionariesSearchPanel);
        } else {
            throw new Exception("Invalid view: " + view);
        }
    }

    @Override
    public boolean runAction(String action) throws Exception {
        if (action.startsWith("find")) {
            String m_z = JOptionPane.showInputDialog((Component)((Object)this.theApplication), "Insert m/z value", this.theWorkspace.getRecentMZValue());
            if (m_z != null) {
                Double mz_value = Double.valueOf(m_z);
                this.theWorkspace.setRecentMZValue(mz_value);
                return this.runAction(true, action, (Object)new PeakList(mz_value));
            }
            return false;
        }
        return this.runAction(true, action, (Object)this.theWorkspace.getPeakList());
    }

    @Override
    public boolean runAction(String action, Object params) throws Exception {
        if (this.runAction(this.first_time_run, action, params)) {
            this.first_time_run = false;
            return true;
        }
        return false;
    }

    private static PeakList assertPeakList(Object params) throws Exception {
        if (!(params instanceof PeakList)) {
            throw new Exception("Invalid param object: PeakList needed");
        }
        return (PeakList)((Object)params);
    }

    private static Collection<PeakAnnotation> assertPACollection(Object params) throws Exception {
        if (!(params instanceof Collection)) {
            throw new Exception("Invalid param object: Collection<PeakAnnotation> needed");
        }
        for (Object o : (Collection)params) {
            if (o instanceof PeakAnnotation) continue;
            throw new Exception("Invalid param object: Collection<PeakAnnotation> needed");
        }
        return (Collection)params;
    }

    public boolean runAction(boolean ask, String action, Object params) throws Exception {
        if (action.equals("options")) {
            return this.setOptions();
        }
        if (action.equals("findDatabase")) {
            this.annotate = false;
            this.merge = false;
            if (this.matchStructuresDictionaries(ask, ProfilerPlugin.assertPeakList(params))) {
                this.theManager.show("Search", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchDatabase")) {
            this.annotate = true;
            this.merge = false;
            if (this.matchStructuresDictionaries(ask, ProfilerPlugin.assertPeakList(params))) {
                this.theManager.show("Annotation", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchStructuresCurrent")) {
            this.annotate = true;
            this.merge = true;
            if (this.matchStructures(ask, ProfilerPlugin.assertPeakList(params), Collections.singleton(this.theApplication.getCanvas().getCurrentStructure()))) {
                this.theManager.show("Annotation", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchStructuresSelected")) {
            this.annotate = true;
            this.merge = true;
            if (this.matchStructures(ask, ProfilerPlugin.assertPeakList(params), this.theApplication.getCanvas().getSelectedStructures())) {
                this.theManager.show("Annotation", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchStructuresAll")) {
            this.annotate = true;
            this.merge = true;
            if (this.matchStructures(ask, ProfilerPlugin.assertPeakList(params), this.theWorkspace.getStructures().getStructures())) {
                this.theManager.show("Annotation", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("search")) {
            if (this.search(null, null, false)) {
                this.theManager.show("Profiler", "Search");
                return true;
            }
            return false;
        }
        if (action.equals("searchAgain")) {
            if (this.search(null, null, true)) {
                this.theManager.show("Profiler", "Search");
                return true;
            }
            return false;
        }
        if (action.equals("searchCurrent")) {
            this.theApplication.getCanvas().enforceSelection();
            if (this.search(this.theApplication.getCanvas().getCurrentStructure(), null, false)) {
                this.theManager.show("Profiler", "Search");
                return true;
            }
            return false;
        }
        if (action.equals("storeStructuresCurrent")) {
            this.theApplication.getCanvas().enforceSelection();
            return this.storeStructures(Collections.singleton(this.theApplication.getCanvas().getCurrentStructure()));
        }
        if (action.equals("storeStructuresSelected")) {
            this.theApplication.getCanvas().enforceSelection();
            return this.storeStructures(this.theApplication.getCanvas().getSelectedStructures());
        }
        if (action.equals("storeStructuresAll")) {
            return this.storeStructures(this.theWorkspace.getStructures().getStructures());
        }
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            System.err.println("Here");
            this.runAction(GlycanAction.getAction((ActionEvent)e));
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    @Override
    public void updateViews() {
        this.theDictionariesManagerPanel.updateView();
        this.theDictionariesEditPanel.updateView();
        this.theDictionariesSearchPanel.updateView();
    }

    @Override
    public void updateMasses() {
        this.theDictionariesEditPanel.updateMasses();
        this.theDictionariesSearchPanel.updateMasses();
    }

    public boolean setOptions() {
        ProfilerOptionsDialog pdlg = new ProfilerOptionsDialog((Frame)((Object)this.theApplication), this, this.theProfilerOptions);
        pdlg.setVisible(true);
        if (!pdlg.getReturnStatus().equals("OK")) {
            return false;
        }
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, false, false);
        adlg.setVisible(true);
        return adlg.getReturnStatus().equals("OK");
    }

    public boolean matchStructuresDictionaries(boolean ask, PeakList peaks) throws Exception {
        if (ask) {
            ProfilerOptionsDialog pdlg = new ProfilerOptionsDialog((Frame)((Object)this.theApplication), this, this.theProfilerOptions);
            pdlg.setVisible(true);
            if (this.theProfilerOptions.CLEAR_EXISTING_ANNOTATIONS) {
                this.theWorkspace.getAnnotatedPeakList().clear();
            }
            if (!pdlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        DictionaryStructureGenerator generator = new DictionaryStructureGenerator();
        for (int i = 0; i < this.theProfilerOptions.DICTIONARIES.length; ++i) {
            generator.add(this.theDictionaries.get(this.theProfilerOptions.DICTIONARIES[i]));
        }
        return this.matchStructures(ask, peaks, generator);
    }

    public boolean matchStructures(boolean ask, PeakList peaks, StructureGenerator generator) throws Exception {
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        if (ask) {
            AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, false, false);
            adlg.setVisible(true);
            if (!adlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        if (ann_opt.CLEAR_EXISTING_ANNOTATIONS) {
            this.theWorkspace.getAnnotatedPeakList().clear();
        }
        this.theApplication.haltInteractions();
        this.theThread = new ProfilerThread(peaks, new Glycan(), generator, this.theProfilerOptions, ann_opt);
        this.theThread.setAddUnmatchedPeaks(true);
        return this.runAnnotation();
    }

    public boolean matchStructures(boolean ask, PeakList peaks, Collection<Glycan> structures) throws Exception {
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        if (ask) {
            AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, false, false);
            adlg.setVisible(true);
            if (!adlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        if (ann_opt.CLEAR_EXISTING_ANNOTATIONS) {
            this.theWorkspace.getAnnotatedPeakList().clear();
        }
        this.theApplication.haltInteractions();
        CollectionStructureGenerator generator = new CollectionStructureGenerator(structures);
        this.theThread = new ProfilerThread(peaks, new Glycan(), generator, this.theProfilerOptions, ann_opt);
        this.theThread.setAddUnmatchedPeaks(false);
        return this.runAnnotation();
    }

    public boolean storeStructures(Collection<Glycan> tostore) throws Exception {
        if (this.theUserDictionaries.size() == 0) {
            this.theManager.show("Profiler", "Databases");
            if (!this.theDictionariesManagerPanel.createUserDatabase()) {
                return false;
            }
        }
        StoreStructuresDialog dlg = new StoreStructuresDialog((Frame)((Object)this.theApplication), this, null);
        dlg.setVisible(true);
        if (dlg.getReturnStatus().equals("Cancel")) {
            return false;
        }
        StructureDictionary dict = this.getDictionary(dlg.getDictionaryName());
        if (dict == null) {
            return false;
        }
        if (dict.addAll(tostore, dlg.getStructureType(), dlg.getSource())) {
            try {
                dict.save();
                return true;
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
                return false;
            }
        }
        return false;
    }

    private boolean runAnnotation() {
        this.theThread.start();
        this.progressDialog = new ProgressDialog((JFrame)((Object)this.theApplication), "Matching peaks with structures", null, -1, -1);
        this.progressDialog.setVisible(true);
        this.activityMonitor = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProfilerPlugin.this.progressDialog.setNote(ProfilerPlugin.this.theThread.getProgress() + " structures tested, " + ProfilerPlugin.this.theThread.getMatches() + " matched");
                if (!ProfilerPlugin.this.theThread.isAlive() || ProfilerPlugin.this.theThread.isInterrupted() || ProfilerPlugin.this.progressDialog.isCanceled()) {
                    ProfilerPlugin.this.activityMonitor.stop();
                    ProfilerPlugin.this.progressDialog.setVisible(false);
                    if (ProfilerPlugin.this.progressDialog.isCanceled()) {
                        ProfilerPlugin.this.theThread.interrupt();
                        ProfilerPlugin.this.onAnnotationAborted(ProfilerPlugin.this.theThread);
                    } else {
                        ProfilerPlugin.this.onAnnotationCompleted(ProfilerPlugin.this.theThread);
                    }
                }
            }
        });
        this.activityMonitor.start();
        return true;
    }

    public void onAnnotationCompleted(ProfilerThread t) {
        AnnotatedPeakList dest = null;
        if (this.annotate) {
            dest = this.theWorkspace.getAnnotatedPeakList();
        } else {
            dest = this.theWorkspace.getSearchResults();
            this.theWorkspace.setSearchGenerator(this);
        }
        if (this.merge) {
            dest.merge(t.getAnnotatedPeaks());
        } else {
            dest.copy(t.getAnnotatedPeaks());
        }
        this.theApplication.restoreInteractions();
    }

    public void onAnnotationAborted(ProfilerThread t) {
        AnnotatedPeakList dest = null;
        if (this.annotate) {
            dest = this.theWorkspace.getAnnotatedPeakList();
        } else {
            dest = this.theWorkspace.getSearchResults();
            this.theWorkspace.setSearchGenerator(this);
        }
        dest.copy(t.getAnnotatedPeaks());
        this.theApplication.restoreInteractions();
    }

    private static Collection<Glycan> getStructures(Collection<PeakAnnotation> pac) {
        Vector<Glycan> ret = new Vector<Glycan>();
        for (PeakAnnotation pa : pac) {
            if (!pa.isAnnotated()) continue;
            ret.add(pa.getFragment());
        }
        return ret;
    }

    public boolean search(Glycan g, StructureDictionary d, final boolean search_again) throws MalformedURLException {
        final SearchDialog dlg = new SearchDialog((Frame)((Object)this.theApplication), this, search_again, this.theWorkspace.getGraphicOptions());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (!dlg.getReturnStatus().equals("OK")) {
                    return;
                }
                if (search_again) {
                    Collection<StructureType> entries = ProfilerPlugin.this.theDictionariesSearchPanel.getData();
                } else {
                    Collection<StructureType> found = new Vector<StructureType>();
                    if (dlg.getDatabase().isWggds() && (dlg.getDatabase().size() == 0 || dlg.getDatabase().size() > 1 && dlg.getDatabase().isLiveSearch())) {
                        try {
                            final GlycanParser glydeParser = GlycanParserFactory.getParser((String)CarbohydrateSequenceEncoding.glyde.getId());
                            SubstructureQuery query = new SubstructureQuery();
                            query.setCompleteInformation(CompleteInformation.Complete);
                            query.setFormat(OutputFormat.XML);
                            query.setSequence(glydeParser.writeGlycan(dlg.getStructure()));
                            query.setExactMatch(!dlg.getFuzzy());
                            query.setReducingEnd(dlg.getIncludeRedEnd());
                            query.setTerminal(dlg.getIncludeAllLeafs());
                            final Vector foundInternal = new Vector();
                            QueryResultProcessor queryProc = new QueryResultProcessor(){

                                public void processStructureResult(StructureResult structureResult) {
                                    try {
                                        foundInternal.add(new StructureType(glydeParser.readGlycan(structureResult.getSequence(), new MassOptions())));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }

                                public void processResultHeader(QueryResultHeader queryResultHeader) {
                                }

                                public void processError(ServerSideError error) {
                                    LogUtils.report((Exception)new Exception("WGGDS upstream server error\nError code: " + error.getErrorId().getId() + "\n>Message\n" + error.getMessage()));
                                }
                            };
                            query.runQuery(dlg.getDatabase().getUri(), queryProc);
                            found = foundInternal;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        Collection<StructureType> entries = dlg.getDatabase().getStructureTypes();
                        try {
                            MassOptions mass_opt = new MassOptions();
                            Glycan structure = dlg.getStructure();
                            String type = dlg.getStructureType().toLowerCase();
                            String source = dlg.getSource().toLowerCase();
                            boolean include_redend = dlg.getIncludeRedEnd();
                            boolean include_all_leafs = dlg.getIncludeAllLeafs();
                            boolean fuzzy = dlg.getFuzzy();
                            structure.setMassOptions(mass_opt);
                            if (!structure.isEmpty() || type.length() > 0 || source.length() > 0) {
                                for (StructureType st : entries) {
                                    Glycan s = st.generateStructure(mass_opt);
                                    if (!structure.isEmpty() && !s.contains(structure, include_redend, include_all_leafs, fuzzy) || type.length() != 0 && st.type.toLowerCase().indexOf(type) == -1 || source.length() != 0 && st.source.toLowerCase().indexOf(source) == -1) continue;
                                    found.add(st);
                                }
                            } else {
                                found = entries;
                            }
                        }
                        catch (Exception e) {
                            LogUtils.report((Exception)e);
                        }
                    }
                    ProfilerPlugin.this.theDictionariesSearchPanel.setData(found);
                    try {
                        ProfilerPlugin.this.theManager.show("Profiler", "Search");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        dlg.setRunnable(run);
        dlg.setStructure(g);
        dlg.setDatabase(d);
        dlg.setVisible(true);
        return true;
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        this.fireDictionaryChanged((StructureDictionary)((Object)e.getSource()));
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.fireDictionaryChanged((StructureDictionary)((Object)e.getSource()));
    }

    public void addDictionariesChangeListener(DictionariesChangeListener l) {
        if (l != null && !this.dc_listeners.contains(l)) {
            this.dc_listeners.add(l);
        }
    }

    public void removeDictionariesChangeListener(DictionariesChangeListener l) {
        if (l != null) {
            this.dc_listeners.remove(l);
        }
    }

    public void fireDictionariesInit() {
        for (DictionariesChangeListener dcl : this.dc_listeners) {
            dcl.dictionariesChanged(new DictionariesChangeEvent(1, this, null));
        }
    }

    public void fireDictionaryAdded(StructureDictionary added) {
        for (DictionariesChangeListener dcl : this.dc_listeners) {
            dcl.dictionariesChanged(new DictionariesChangeEvent(2, this, added));
        }
    }

    public void fireDictionaryRemoved(StructureDictionary removed) {
        for (DictionariesChangeListener dcl : this.dc_listeners) {
            dcl.dictionariesChanged(new DictionariesChangeEvent(3, this, removed));
        }
    }

    public void fireDictionaryChanged(StructureDictionary changed) {
        for (DictionariesChangeListener dcl : this.dc_listeners) {
            dcl.dictionariesChanged(new DictionariesChangeEvent(4, this, changed));
        }
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }

    public ResizableIcon getResizableIcon() {
        return FileUtils.getThemeManager().getResizableIcon("profiler", Plugin.DEFAULT_ICON_SIZE).getResizableIcon();
    }

    public static class DictionariesChangeEvent
    extends EventObject {
        public static final int NONE = 0;
        public static final int INIT = 1;
        public static final int ADDED = 2;
        public static final int REMOVED = 3;
        public static final int CHANGED = 4;
        private int action = 0;
        private StructureDictionary changed = null;

        public DictionariesChangeEvent(int _action, ProfilerPlugin _source, StructureDictionary _changed) {
            super(_source);
            this.action = _action;
            this.changed = _changed;
        }

        public int getAction() {
            return this.action;
        }

        public StructureDictionary getChanged() {
            return this.changed;
        }
    }

    public static interface DictionariesChangeListener {
        public void dictionariesChanged(DictionariesChangeEvent var1);
    }
}

