/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureDictionary;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureGenerator;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;

public class DictionaryStructureGenerator
implements StructureGenerator {
    private Collection<StructureDictionary> dictionaries = null;
    private MassOptions mass_opt = null;
    private Iterator<StructureDictionary> sdi = null;
    private Iterator<StructureType> sti = null;
    private StructureDictionary last_dict = null;
    private StructureType last_type = null;

    public DictionaryStructureGenerator() {
        this.dictionaries = new Vector<StructureDictionary>();
    }

    public DictionaryStructureGenerator(StructureDictionary dict) {
        this.dictionaries = dict != null ? Collections.singleton(dict) : new Vector<StructureDictionary>();
    }

    public DictionaryStructureGenerator(Collection<StructureDictionary> dicts) {
        this.dictionaries = dicts != null ? dicts : new Vector<StructureDictionary>();
    }

    public void add(StructureDictionary dict) {
        this.dictionaries.add(dict);
    }

    @Override
    public void start(MassOptions _mass_opt) {
        this.mass_opt = _mass_opt;
        this.sdi = this.dictionaries.iterator();
        this.sti = null;
        this.last_dict = null;
        this.last_type = null;
    }

    @Override
    public FragmentEntry next(boolean backtrack) {
        while (this.sti == null || !this.sti.hasNext()) {
            if (this.sdi.hasNext()) {
                this.last_dict = this.sdi.next();
                this.sti = this.last_dict.iterator();
                continue;
            }
            return null;
        }
        try {
            this.last_type = this.sti.next();
            return this.last_type.generateFragmentEntry(this.mass_opt);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    @Override
    public double computeScore(Glycan structure) {
        if (this.last_dict != null && this.last_dict.getScorer() != null) {
            return this.last_dict.getScorer().computeScore(structure);
        }
        return 0.0;
    }
}

