/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.Base64;
import org.eurocarbdb.application.glycoworkbench.MMFCreator;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.GaussFilter;
import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.TopHatFilter;
import org.jfree.data.Range;
import org.proteomecommons.io.PeakList;
import org.systemsbiology.jrap.Scan;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PeakData
implements SAXUtils.SAXWriter {
    protected int no_peaks;
    protected double min_mz;
    protected double max_mz;
    protected MMFCreator.Pointer theData;

    public PeakData() {
        this.initData();
    }

    public PeakData(Scan s, MMFCreator mmfc) throws Exception {
        if (s != null) {
            this.setData(s.getMassIntensityList(), mmfc);
        } else {
            this.initData();
        }
    }

    public PeakData(PeakList p, MMFCreator mmfc) throws Exception {
        if (p != null) {
            this.setData(p.getPeaks(), mmfc);
        } else {
            this.initData();
        }
    }

    public PeakData(List<Peak> peaks, MMFCreator mmfc) throws Exception {
        this.setData(peaks, mmfc);
    }

    public PeakData(float[][] peaks, MMFCreator mmfc) throws Exception {
        this.setData(peaks, mmfc);
    }

    public PeakData(double[][] peaks, MMFCreator mmfc) throws Exception {
        this.setData(peaks, mmfc);
    }

    private void initData() {
        this.no_peaks = 0;
        this.max_mz = 0.0;
        this.min_mz = 0.0;
        this.theData = null;
    }

    private void setData(org.proteomecommons.io.Peak[] data, MMFCreator mmfc) throws Exception {
        int start;
        this.initData();
        if (data == null || data.length == 0) {
            return;
        }
        for (start = 0; start < data.length && data[start].getMassOverCharge() == 0.0; ++start) {
        }
        if (start == data.length) {
            return;
        }
        for (int i = start; i < data.length; ++i) {
            mmfc.addDouble(data[i].getMassOverCharge());
            mmfc.addDouble(data[i].getIntensity());
        }
        this.no_peaks = data.length - start;
        this.min_mz = data[start].getMassOverCharge();
        this.max_mz = data[data.length - 1].getMassOverCharge();
        this.theData = mmfc.getPointerFromLast();
    }

    private void setData(float[][] data, MMFCreator mmfc) throws Exception {
        int start;
        this.initData();
        if (data == null || data[0].length == 0) {
            return;
        }
        for (start = 0; start < data[0].length && (double)data[0][start] == 0.0; ++start) {
        }
        if (start == data[0].length) {
            return;
        }
        for (int i = start; i < data[0].length; ++i) {
            mmfc.addDouble(data[0][i]);
            mmfc.addDouble(data[1][i]);
        }
        this.no_peaks = data[0].length - start;
        this.min_mz = data[0][start];
        this.max_mz = data[0][data[0].length - 1];
        this.theData = mmfc.getPointerFromLast();
    }

    private void setData(double[][] data, MMFCreator mmfc) throws Exception {
        int start;
        this.initData();
        if (data == null || data[0].length == 0) {
            return;
        }
        for (start = 0; start < data[0].length && data[0][start] == 0.0; ++start) {
        }
        if (start == data[0].length) {
            return;
        }
        for (int i = start; i < data[0].length; ++i) {
            mmfc.addDouble(data[0][i]);
            mmfc.addDouble(data[1][i]);
        }
        this.no_peaks = data[0].length - start;
        this.min_mz = data[0][start];
        this.max_mz = data[0][data[0].length - 1];
        this.theData = mmfc.getPointerFromLast();
    }

    private void setData(List<Peak> data, MMFCreator mmfc) throws Exception {
        int start;
        this.initData();
        if (data == null || data.size() == 0) {
            return;
        }
        int data_peaks = data.size();
        for (start = 0; start < data_peaks && data.get(start).getMZ() == 0.0; ++start) {
        }
        if (start == data_peaks) {
            return;
        }
        for (int i = start; i < data_peaks; ++i) {
            mmfc.addDouble(data.get(i).getMZ());
            mmfc.addDouble(data.get(i).getIntensity());
        }
        this.no_peaks = data_peaks - start;
        this.min_mz = data.get(start).getMZ();
        this.max_mz = data.get(data_peaks - 1).getMZ();
        this.theData = mmfc.getPointerFromLast();
    }

    public int getPeakCount() {
        return this.no_peaks;
    }

    public double getMinMZ() {
        return this.min_mz;
    }

    public double getMaxMZ() {
        return this.max_mz;
    }

    public Range getMZRange() {
        return new Range(this.min_mz, this.max_mz);
    }

    public double[] findNearestPeak(double mz) {
        int best_pos;
        DoubleBuffer buffer;
        block7: {
            double dist;
            double min_dist;
            double pos_mz;
            block6: {
                double dist2;
                buffer = null;
                try {
                    buffer = this.theData.getBuffer(true).asDoubleBuffer();
                }
                catch (Exception e) {
                    LogUtils.report((Exception)e);
                    return null;
                }
                best_pos = (int)((mz - this.min_mz) / (this.max_mz - this.min_mz));
                if (best_pos < 0) {
                    return new double[]{buffer.get(0), buffer.get(1)};
                }
                if (best_pos >= this.no_peaks) {
                    return new double[]{buffer.get(2 * this.no_peaks - 2), buffer.get(2 * this.no_peaks - 1)};
                }
                pos_mz = buffer.get(2 * best_pos);
                min_dist = Math.abs(pos_mz - mz);
                if (!(pos_mz > mz)) break block6;
                int i = best_pos - 1;
                while (i >= 0 && !((dist2 = Math.abs(buffer.get(2 * i) - mz)) > min_dist)) {
                    min_dist = dist2;
                    best_pos = i--;
                }
                break block7;
            }
            if (!(pos_mz < mz)) break block7;
            int i = best_pos + 1;
            while (i < this.no_peaks && !((dist = Math.abs(buffer.get(2 * i) - mz)) > min_dist)) {
                min_dist = dist;
                best_pos = i++;
            }
        }
        return new double[]{buffer.get(2 * best_pos), buffer.get(2 * best_pos + 1)};
    }

    public double[][] getData() {
        return this.getData(0.0);
    }

    public double[][] getData(double from_mz, double to_mz) {
        return this.getData(from_mz, to_mz, 0.0);
    }

    public double[][] getData(double mz_toll) {
        return this.getData(this.getMinMZ(), this.getMaxMZ(), mz_toll, false);
    }

    public double[][] getData(double mz_toll, boolean rel_int) {
        return this.getData(this.getMinMZ(), this.getMaxMZ(), mz_toll, rel_int);
    }

    public double[][] getData(Range range, double mz_toll) {
        return this.getData(range.getLowerBound(), range.getUpperBound(), mz_toll, false);
    }

    public double[][] getData(Range range, double mz_toll, boolean rel_int) {
        return this.getData(range.getLowerBound(), range.getUpperBound(), mz_toll, rel_int);
    }

    public double[][] getData(double from_mz, double to_mz, double mz_toll) {
        return this.getData(from_mz, to_mz, mz_toll, false);
    }

    public double[][] getData(double from_mz, double to_mz, double mz_toll, boolean rel_int) {
        DoubleBuffer buffer = null;
        try {
            buffer = this.theData.getBuffer(true).asDoubleBuffer();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
        double max_int = 0.0;
        Vector<Peak> peaks = new Vector<Peak>();
        int i = 0;
        while (true) {
            if (buffer.get(2 * i) < from_mz) {
                ++i;
                continue;
            }
            double last_mz = buffer.get(2 * i);
            double add_mz = buffer.get(2 * i);
            double add_int = buffer.get(2 * i + 1);
            ++i;
            while (i < this.no_peaks && buffer.get(2 * i) < last_mz + mz_toll && buffer.get(2 * i) <= to_mz) {
                if (buffer.get(2 * i + 1) > add_int) {
                    add_mz = buffer.get(2 * i);
                    add_int = buffer.get(2 * i + 1);
                }
                ++i;
            }
            max_int = Math.max(max_int, add_int);
            peaks.add(new Peak(add_mz, add_int));
            if (i >= this.no_peaks || buffer.get(2 * i) > to_mz) break;
        }
        double[][] ret = new double[][]{new double[peaks.size()], new double[peaks.size()]};
        double div = rel_int ? max_int / 100.0 : 1.0;
        for (int i2 = 0; i2 < peaks.size(); ++i2) {
            ret[0][i2] = ((Peak)peaks.get(i2)).getMZ();
            ret[1][i2] = ((Peak)peaks.get(i2)).getIntensity() / div;
        }
        return ret;
    }

    public void baselineCorrection() {
        try {
            int i;
            DoubleBuffer buffer = this.theData.getBuffer(false).asDoubleBuffer();
            double[][] data = new double[][]{new double[this.no_peaks], new double[this.no_peaks]};
            for (i = 0; i < this.no_peaks; ++i) {
                data[0][i] = buffer.get(2 * i);
                data[1][i] = buffer.get(2 * i + 1);
            }
            TopHatFilter.filter(data, 2.5);
            for (i = 0; i < this.no_peaks; ++i) {
                buffer.put(2 * i, data[0][i]);
                buffer.put(2 * i + 1, data[1][i]);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void recalibrate(List<Double> params) {
        if (params == null || params.size() < 2) {
            return;
        }
        try {
            DoubleBuffer buffer = this.theData.getBuffer(false).asDoubleBuffer();
            for (int i = 0; i < this.no_peaks; ++i) {
                double old_mz = buffer.get(2 * i);
                double new_mz = this.recalibrate(old_mz, params);
                buffer.put(2 * i, new_mz);
            }
            this.min_mz = this.recalibrate(this.min_mz, params);
            this.max_mz = this.recalibrate(this.max_mz, params);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    private double recalibrate(double mz, List<Double> params) {
        double ret = mz;
        double mul = 1.0;
        for (Double param : params) {
            ret += param * mul;
            mul *= mz;
        }
        return ret;
    }

    public void noiseFilter() {
        this.noiseFilter(0.8);
    }

    public void noiseFilter(double width) {
        try {
            DoubleBuffer buffer = this.theData.getBuffer(false).asDoubleBuffer();
            Object data = new double[][]{new double[this.no_peaks], new double[this.no_peaks]};
            for (int i = 0; i < this.no_peaks; ++i) {
                data[0][i] = buffer.get(2 * i);
                data[1][i] = buffer.get(2 * i + 1);
            }
            GaussFilter gf = new GaussFilter();
            gf.setKernelWidth(width);
            data = gf.filter((double[][])data);
            for (int i = 0; i < this.no_peaks; ++i) {
                buffer.put(2 * i, data[0][i]);
                buffer.put(2 * i + 1, data[1][i]);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void write(File f) throws Exception {
        this.write(new FileOutputStream(f));
    }

    public void write(OutputStream os) throws Exception {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        DoubleBuffer buffer = this.theData.getBuffer(true).asDoubleBuffer();
        for (int i = 0; i < this.no_peaks; ++i) {
            String str = "" + buffer.get(2 * i) + " " + buffer.get(2 * i + 1);
            bw.write(str, 0, str.length());
            bw.newLine();
        }
        bw.close();
    }

    public static PeakData fromXML(Node pd_node, MMFCreator mmfc) throws Exception {
        PeakData ret = new PeakData();
        if (pd_node == null) {
            return ret;
        }
        String text = XMLUtils.getText((Node)pd_node);
        if (text == null || text.length() == 0) {
            return ret;
        }
        byte[] decoded = Base64.decode(text);
        for (int i = 0; i < decoded.length; ++i) {
            mmfc.addByte(decoded[i]);
        }
        ret.theData = mmfc.getPointerFromLast();
        ret.no_peaks = (int)(8L * ret.theData.getSize() / 64L) / 2;
        DoubleBuffer buffer = ret.theData.getBuffer(true).asDoubleBuffer();
        ret.min_mz = buffer.get(0);
        ret.max_mz = buffer.get(2 * (ret.no_peaks - 1));
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element pd_node = document.createElement("PeakData");
        try {
            MappedByteBuffer buffer = this.theData.getBuffer(true);
            byte[] toencode = new byte[buffer.capacity()];
            for (int i = 0; i < buffer.capacity(); ++i) {
                toencode[i] = buffer.get(i);
            }
            XMLUtils.setText((Node)pd_node, (String)Base64.encodeToString(toencode, false));
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
        return pd_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "PeakData", new AttributesImpl());
        char[] text = new char[]{};
        try {
            MappedByteBuffer buffer = this.theData.getBuffer(true);
            byte[] toencode = new byte[buffer.capacity()];
            for (int i = 0; i < buffer.capacity(); ++i) {
                toencode[i] = buffer.get(i);
            }
            text = Base64.encodeToChar(toencode, true);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
        th.characters(text, 0, text.length);
        th.endElement("", "", "PeakData");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private MMFCreator mmfc;

        public SAXHandler(MMFCreator _mmfc) {
            this.mmfc = _mmfc;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "PeakData";
        }

        protected void addWhiteSpace() {
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            PeakData ret = new PeakData();
            try {
                byte[] decoded = Base64.decode(this.text.toString());
                for (int i = 0; i < decoded.length; ++i) {
                    this.mmfc.addByte(decoded[i]);
                }
                ret.theData = this.mmfc.getPointerFromLast();
                ret.no_peaks = (int)(8L * ret.theData.getSize() / 64L) / 2;
                DoubleBuffer buffer = ret.theData.getBuffer(true).asDoubleBuffer();
                ret.min_mz = buffer.get(0);
                ret.max_mz = buffer.get(2 * (ret.no_peaks - 1));
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            this.object = ret;
            return this.object;
        }
    }
}

