/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combinator {
    HashSet<String> combinations = new HashSet();

    public void generate(String word) {
        this.combinations.add(word);
        if (word.length() == 1) {
            return;
        }
        for (int i = 0; i < word.length(); ++i) {
            this.generate(word.substring(0, i) + word.substring(i + 1));
        }
    }

    public static <T> HashSet<List<T>> generate(List<T> list) {
        HashSet<List<T>> combinations = new HashSet<List<T>>();
        Combinator.generate(list, combinations);
        return combinations;
    }

    public static <T> void generate(List<T> list, HashSet<List<T>> combinations) {
        combinations.add(list);
        if (list.size() == 1) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<T> newList = new ArrayList<T>();
            newList.addAll(list.subList(0, i));
            newList.addAll(list.subList(i + 1, list.size()));
            Combinator.generate(newList, combinations);
        }
    }

    public static <T> HashSet<List<T>> generate(List<T> list, List<T> sequence) {
        HashSet<List<T>> combinations = new HashSet<List<T>>();
        Combinator.generate(list, sequence, combinations, 0);
        return combinations;
    }

    public static <T> void generate(List<T> list, List<T> sequence, HashSet<List<T>> combinations, int i) {
        if (i == sequence.size()) {
            combinations.add(sequence);
            return;
        }
        for (T obj : list) {
            System.err.println(sequence.size());
            ArrayList<T> cloneOfSequence = new ArrayList<T>(sequence);
            cloneOfSequence.set(i, obj);
            Combinator.generate(list, cloneOfSequence, combinations, i + 1);
        }
    }

    public static void main(String[] args) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        list.add(6);
        list.add(7);
        list.add(8);
        HashSet combinations = Combinator.generate(list);
        for (List combination : combinations) {
            System.out.println(combination.toString());
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("A");
        list2.add("B");
        list2.add("C");
        ArrayList<String> sequence = new ArrayList<String>();
        sequence.add("");
        sequence.add("");
        sequence.add("");
        HashSet combinations2 = Combinator.generate(list2, sequence);
        for (List combination : combinations2) {
            System.out.println(combination.toString());
        }
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("Na");
        list3.add("Na");
        list3.add("H");
        combinations = Combinator.generate(list3);
        for (List combination : combinations) {
            System.out.println(combination.toString());
        }
    }
}

