/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.editor;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.editor.experimentdesigner.config.ImageRegistry;
import org.grits.toolbox.editor.experimentdesigner.editor.ProtocolNodeCreationFactory;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolCategory;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolPaletteEntry;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;

final class GraphEditorPaletteFactory {
    private static Logger logger = Logger.getLogger(GraphEditorPaletteFactory.class);

    private static PaletteContainer createDrawer(ProtocolCategory topLevel, List<PaletteContainer> contents) {
        PaletteDrawer componentsDrawer = new PaletteDrawer(topLevel.getName());
        componentsDrawer.setDescription(topLevel.getDescription());
        for (PaletteContainer paletteContainer : contents) {
            componentsDrawer.add((PaletteEntry)new PaletteSeparator());
            PaletteEntry categoryLabel = new PaletteEntry(paletteContainer.getLabel(), paletteContainer.getDescription(), (Object)"Palette_type_Unknown");
            componentsDrawer.add(categoryLabel);
            componentsDrawer.add((PaletteEntry)paletteContainer);
        }
        return componentsDrawer;
    }

    private static PaletteContainer createStack(ProtocolCategory category, List<ProtocolPaletteEntry> entries) {
        PaletteStack toolStack = new PaletteStack(category.getName(), category.getDescription(), null);
        for (ProtocolPaletteEntry protocolPaletteEntry : entries) {
            ProtocolNodeCreationFactory factory = new ProtocolNodeCreationFactory();
            factory.setText(protocolPaletteEntry.getLabel());
            factory.setColor(protocolPaletteEntry.getColor());
            factory.setUri(protocolPaletteEntry.getUri());
            factory.setUrl(protocolPaletteEntry.getUrl());
            factory.setCategory(protocolPaletteEntry.getCategory());
            factory.setCreator(protocolPaletteEntry.getCreator());
            factory.setParameters(protocolPaletteEntry.getParameters());
            factory.setParameterGroups(protocolPaletteEntry.getParameterGroups());
            factory.setPapers(protocolPaletteEntry.getPapers());
            factory.setDescription(protocolPaletteEntry.getDescription());
            factory.setFile(protocolPaletteEntry.getFile());
            if (protocolPaletteEntry.getCategory() == null) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Protocol does not have a category. Fix the ontology!");
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Protocol does not have a category.\nContact the developers to fix the ontology!");
                return null;
            }
            protocolPaletteEntry.getCategory().getPosition().intValue();
            CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry(protocolPaletteEntry.getLabel(), protocolPaletteEntry.getDescription(), (CreationFactory)factory, ImageRegistry.getSmallIcon(category.getIcon()), ImageRegistry.getLargeIcon(category.getIcon()));
            toolStack.add((PaletteEntry)component);
        }
        return toolStack;
    }

    static PaletteRoot createPalette() {
        PaletteRoot palette = new PaletteRoot();
        palette.add((PaletteEntry)GraphEditorPaletteFactory.createToolsGroup(palette));
        try {
            ExperimentDesignOntologyAPI ontologyAPI = new ExperimentDesignOntologyAPI();
            List<ProtocolCategory> categories = ontologyAPI.getTopLevelCategories();
            int i = 0;
            for (ProtocolCategory protocolCategory : categories) {
                List<ProtocolCategory> subCategories = ontologyAPI.getProtocolCategoriesByTopLevelCategory(protocolCategory);
                ArrayList<PaletteContainer> stacks = new ArrayList<PaletteContainer>();
                for (ProtocolCategory subCategory : subCategories) {
                    if (subCategory.getName().equals(protocolCategory.getName())) continue;
                    stacks.add(GraphEditorPaletteFactory.createStack(subCategory, ontologyAPI.getProtocolsForCategory(subCategory)));
                }
                PaletteDrawer drawer = (PaletteDrawer)GraphEditorPaletteFactory.createDrawer(protocolCategory, stacks);
                if (i == 0) {
                    drawer.setInitialState(0);
                } else {
                    drawer.setInitialState(1);
                }
                palette.add((PaletteEntry)drawer);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error Reading Ontology. Cannot create the palette! ", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Error Reading Ontology. Cannot create the palette!\nError:" + e));
        }
        return palette;
    }

    private static PaletteContainer createToolsGroup(PaletteRoot palette) {
        PaletteToolbar toolbar = new PaletteToolbar("Tools");
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        toolbar.add((PaletteEntry)tool);
        palette.setDefaultEntry((ToolEntry)tool);
        toolbar.add((PaletteEntry)new MarqueeToolEntry());
        tool = new ConnectionCreationToolEntry("Connection", "Create a connection", new CreationFactory(){

            public Object getNewObject() {
                return null;
            }

            public Object getObjectType() {
                return Connection.SOLID_CONNECTION;
            }
        }, ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.CONNECTION16), ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.CONNECTION24));
        toolbar.add((PaletteEntry)tool);
        CombinedTemplateCreationEntry component = new CombinedTemplateCreationEntry("New", "Create a new protocol", (CreationFactory)new SimpleFactory(ProtocolNode.class), ImageRegistry.getSmallIcon("255-255-255.gif"), ImageRegistry.getLargeIcon("255-255-255.gif"));
        toolbar.add((PaletteEntry)component);
        return toolbar;
    }

    private GraphEditorPaletteFactory() {
    }
}

