/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.manager;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.TableData;

public class GeneListTableColumnPropertyAccessor
implements IColumnPropertyAccessor<TableData> {
    List<GRITSColumnHeader> columnList;
    private GeneListManagerEditor editor;
    Map<TableData, Boolean> selectedMap = new LinkedHashMap<TableData, Boolean>();

    public GeneListTableColumnPropertyAccessor(GeneListManagerEditor editor, List<GRITSColumnHeader> columns) {
        this.editor = editor;
        this.columnList = columns;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public Object getDataValue(TableData element, int columnIndex) {
        String columnName;
        switch (columnName = this.getColumnProperty(columnIndex)) {
            case "Select": {
                if (this.selectedMap.containsKey(element)) {
                    return this.selectedMap.get(element);
                }
                this.selectedMap.put(element, new Boolean(false));
                return false;
            }
            case "Gene Identifier": {
                if (element instanceof Gene) {
                    return ((Gene)element).getGeneIdentifier();
                }
                return null;
            }
            case "Gene Symbol": {
                if (element instanceof Gene) {
                    return ((Gene)element).getGeneSymbol();
                }
                return null;
            }
            case "ID": {
                if (element instanceof Gene) {
                    if (((Gene)element).getGeneIds() != null) {
                        return ((Gene)element).getGeneIdString();
                    }
                    return null;
                }
                return null;
            }
            case "Name": {
                if (element instanceof Gene) {
                    return ((Gene)element).getFullName();
                }
                return null;
            }
            case "Forward Primer": {
                if (element instanceof Gene) {
                    return ((Gene)element).getForwardPrimer();
                }
                return null;
            }
            case "Reverse Primer": {
                if (element instanceof Gene) {
                    return ((Gene)element).getReversePrimer();
                }
                return null;
            }
            case "Description": {
                if (element instanceof Gene) {
                    return ((Gene)element).getDescription();
                }
                return null;
            }
            case "RefSeq": {
                if (element instanceof Gene) {
                    return ((Gene)element).getRefSeqString();
                }
                return null;
            }
            case "Group": {
                if (element instanceof Gene) {
                    return ((Gene)element).getGroup();
                }
                return null;
            }
            case "Notes": {
                if (element instanceof Gene) {
                    return ((Gene)element).getNotes();
                }
                return null;
            }
            case "Aliases": {
                if (element instanceof Gene) {
                    return ((Gene)element).getAliasString();
                }
                return null;
            }
            case "Genomic Location": {
                if (element instanceof Gene) {
                    return ((Gene)element).getLocationString();
                }
                return null;
            }
            case "Protein RefSeq": {
                if (element instanceof Gene) {
                    return ((Gene)element).getSecondaryRefSeqString();
                }
                return null;
            }
            case "Control?": {
                if (element instanceof Gene) {
                    return ((Gene)element).getIsCommon() != false ? "Control" : "";
                }
                return null;
            }
        }
        return null;
    }

    public void setDataValue(TableData element, int columnIndex, Object value) {
        block54: {
            String oldValue = null;
            if (element == null) {
                return;
            }
            String columnName = this.getColumnProperty(columnIndex);
            if (columnName.equals("Select")) {
                if (value != null && value instanceof Boolean) {
                    if (this.selectedMap.containsKey(element)) {
                        this.selectedMap.remove(element);
                    }
                    this.selectedMap.put(element, (Boolean)value);
                }
                return;
            }
            if (value == null) {
                value = "";
            }
            String newValue = (String)value;
            if (!(element instanceof Gene)) break block54;
            switch (columnName) {
                case "Gene Identifier": {
                    oldValue = ((Gene)element).getGeneIdentifier();
                    ((Gene)element).setGeneIdentifier(newValue.trim());
                    break;
                }
                case "Gene Symbol": {
                    oldValue = ((Gene)element).getGeneSymbol();
                    ((Gene)element).setGeneSymbol(newValue.trim());
                    break;
                }
                case "ID": {
                    if (((Gene)element).getGeneIds() != null) {
                        oldValue = ((Gene)element).getGeneIdString();
                    }
                    ((Gene)element).setGeneIds(newValue.trim());
                    break;
                }
                case "Name": {
                    oldValue = ((Gene)element).getFullName();
                    ((Gene)element).setFullName(newValue.trim());
                    break;
                }
                case "Forward Primer": {
                    oldValue = ((Gene)element).getForwardPrimer();
                    ((Gene)element).setForwardPrimer(newValue.trim());
                    break;
                }
                case "Reverse Primer": {
                    oldValue = ((Gene)element).getReversePrimer();
                    ((Gene)element).setReversePrimer(newValue.trim());
                    break;
                }
                case "Description": {
                    oldValue = ((Gene)element).getDescription();
                    ((Gene)element).setDescription(newValue.trim());
                    break;
                }
                case "RefSeq": {
                    oldValue = ((Gene)element).getRefSeqString();
                    ((Gene)element).setRefSeq(newValue.trim());
                    break;
                }
                case "Group": {
                    oldValue = ((Gene)element).getGroup();
                    ((Gene)element).setGroup(newValue.trim());
                    break;
                }
                case "Notes": {
                    oldValue = ((Gene)element).getNotes();
                    ((Gene)element).setNotes(newValue.trim());
                    break;
                }
                case "Aliases": {
                    oldValue = ((Gene)element).getAliasString();
                    ((Gene)element).setAliasString(newValue.trim());
                    break;
                }
                case "Genomic Location": {
                    oldValue = ((Gene)element).getLocationString();
                    ((Gene)element).setLocationString(newValue.trim());
                    break;
                }
                case "Protein RefSeq": {
                    oldValue = ((Gene)element).getSecondaryRefSeqString();
                    ((Gene)element).setSecondaryRefSeq(newValue.trim());
                    break;
                }
                case "Control?": {
                    oldValue = ((Gene)element).getIsCommon() != false ? "Control" : "";
                    if (newValue != null && newValue.equals("Control")) {
                        ((Gene)element).setIsCommon(true);
                        break;
                    }
                    ((Gene)element).setIsCommon(false);
                }
            }
            if (oldValue == null && !newValue.trim().isEmpty() || oldValue != null && !oldValue.equals(newValue)) {
                this.editor.markDirty();
            }
        }
    }

    public int getColumnIndex(String column) {
        int index = 0;
        for (GRITSColumnHeader simianColumnHeader : this.columnList) {
            if (simianColumnHeader.getKeyValue().equals(column)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getColumnProperty(int index) {
        return this.columnList.get(index).getKeyValue();
    }

    public void selectAll(List<TableData> rows) {
        for (TableData row : rows) {
            this.selectedMap.put(row, new Boolean(true));
        }
    }

    public void clearAllSelections(List<TableData> rows) {
        for (TableData row : rows) {
            this.selectedMap.put(row, new Boolean(false));
        }
    }

    public List<TableData> getSelected() {
        ArrayList<TableData> selected = new ArrayList<TableData>();
        for (TableData row : this.selectedMap.keySet()) {
            if (this.selectedMap.get(row) == null || !this.selectedMap.get(row).booleanValue()) continue;
            selected.add(row);
        }
        return selected;
    }

    public void selectRow(TableData row) {
        if (this.selectedMap.get(row) != null) {
            this.selectedMap.put(row, new Boolean(true));
        }
    }
}

