/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.property;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.property.ReportsProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.commands.CreateMergeReport;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRPropertyWriter;

public class QrtPCRMergeProperty
extends Property {
    private static final Logger logger = Logger.getLogger(QrtPCRMergeProperty.class);
    public static final String TYPE = "org.grits.toolbox.property.qrtpcr.merge";
    protected static PropertyWriter writer = new QrtPCRPropertyWriter();
    protected static ImageDescriptor imageDescriptor = ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.PLUGIN_ICON);

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return imageDescriptor;
    }

    private static String getMergeQrtPCRLocaton(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String reportsfolder = String.valueOf(projectFolderLocation) + File.separator + ReportsProperty.getFolder();
        String qrtPCRFolderLocation = String.valueOf(reportsfolder) + File.separator + "qrtPCR";
        return qrtPCRFolderLocation;
    }

    public void delete(Entry entry) throws IOException {
        String fileLocation = String.valueOf(QrtPCRMergeProperty.getMergeQrtPCRLocaton(entry)) + File.separator + this.getFilename();
        try {
            DeleteUtils.delete((File)new File(fileLocation));
        }
        catch (IOException e) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot delete qrtPCR merge report", (Exception)e);
            logger.error((Object)"org.grits.toolbox.entry.qrtpcr Cannot delete qrtPCR merge report", (Throwable)e);
        }
    }

    public Object clone() {
        return null;
    }

    public Property getParentProperty() {
        return null;
    }

    public String getFilename() {
        return this.getFile().getName();
    }

    public PropertyDataFile getFile() {
        PropertyDataFile qrtpcrFile = null;
        for (PropertyDataFile dataFile : this.dataFiles) {
            if (!"default".equals(dataFile.getType())) continue;
            qrtpcrFile = dataFile;
            break;
        }
        return qrtpcrFile;
    }

    public void makeACopy(Entry currentEntry, Entry destinationEntry) throws IOException {
        try {
            File destinationFolder;
            File currentQrtPCRFile = new File(QrtPCRMergeProperty.getMergeQrtPCRLocaton(currentEntry), this.getFilename());
            if (currentQrtPCRFile.exists()) {
                destinationFolder = new File(QrtPCRMergeProperty.getMergeQrtPCRLocaton(destinationEntry.getParent()));
                if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
                    destinationFolder.mkdir();
                }
            } else {
                throw new FileNotFoundException("Could not find merged qrtPCR file for selected merge report \"" + currentEntry.getDisplayName() + "\" in project \"" + DataModelSearch.findParentByType((Entry)currentEntry, (String)"org.grits.toolbox.property.project").getDisplayName() + "\"");
            }
            String qrtPCRFileName = CreateMergeReport.generateFileName(destinationFolder.list());
            File destinationFile = new File(destinationFolder, qrtPCRFileName);
            Files.copy(currentQrtPCRFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
            ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
            PropertyDataFile currentDataFile = this.getFile();
            dataFiles.add(new PropertyDataFile(destinationFile.getName(), currentDataFile.getVersion(), currentDataFile.getType()));
            QrtPCRMergeProperty property = new QrtPCRMergeProperty();
            property.setDataFiles(dataFiles);
            property.setRemoved(!this.exists());
            property.setVersion(this.getVersion());
            property.setViewerRank(this.getViewerRank());
            destinationEntry.setProperty((Property)property);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IOException("Error copying merged qrtPCR information.\n" + ex.getMessage(), ex);
        }
    }

    public void setFilename(String qrtPCRMergeFileName) {
        this.dataFiles = new ArrayList();
        this.dataFiles.add(new PropertyDataFile(qrtPCRMergeFileName));
    }
}

