/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.editor.PlateTablePage;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;

public class OverviewPage
implements IQrtPCRPart {
    private static final Logger logger = Logger.getLogger(OverviewPage.class);
    private static final Image CHECKED = ImageShare.CHECKBOX_ICON_YES.createImage();
    private static final Image UNCHECKED = ImageShare.CHECKBOX_ICON_NO.createImage();
    private Text text;
    private Table runTable;
    private Tree plateTree;
    private Button btnEvaluateData;
    private TableColumn tblclmnRunid;
    private TableViewerColumn tableViewerColumn_2;
    private TableColumn tblclmnPlatelayoutfile;
    private TableViewerColumn tableViewerColumn_3;
    private TableColumn tblclmnNumberOfReplicates;
    private TableViewerColumn tableViewerColumn_4;
    private TreeViewerColumn treeViewerColumn2;
    private TreeViewerColumn treeViewerColumn3;
    private List<TreeItem> itemsToShow = new ArrayList<TreeItem>();
    private QrtPCRRun pcrRun;
    private Button currentDataOption;
    private Button rawDataOption;
    private Button revertDataOption;
    private double stDevCutOff;
    private Text stdevCuttOffText;
    private CTabItem cTabItem;
    @Inject
    private ECommandService commandService = null;
    @Inject
    private EHandlerService handlerService = null;

    @Inject
    public OverviewPage(QrtPCRRun pcrRun, CTabItem cTabItem) {
        this.pcrRun = pcrRun;
        this.cTabItem = cTabItem;
    }

    public void refreshInput(QrtPCRRun newRun) {
        this.pcrRun = newRun;
        this.itemsToShow = new ArrayList<TreeItem>();
        this.setTables();
    }

    @PostConstruct
    protected void createFormContent(final MPart part) {
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabItem.getParent(), 768);
        GridData layoutData = new GridData();
        scrolledComposite.setLayoutData((Object)layoutData);
        scrolledComposite.setLayout((Layout)new GridLayout());
        Composite parent = new Composite((Composite)scrolledComposite, 4);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createMetadataSection(parent);
        Composite sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new TableWrapLayout());
        Section section0 = new Section(sectionParentComposite, 320);
        section0.setText("Input Gene List");
        section0.setLayout((Layout)new TableWrapLayout());
        Composite topGroup = new Composite((Composite)section0, 0);
        topGroup.setLayout((Layout)new GridLayout(1, true));
        ToolBarManager toolBarManager0 = new ToolBarManager();
        toolBarManager0.add((IAction)new Action("Download file"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DOWNLOAD_ICON);
            }

            public String getToolTipText() {
                return "Download input gene list file";
            }

            public void run() {
                String filename = OverviewPage.this.text.getText();
                OverviewPage.this.downloadAction(Display.getCurrent().getActiveShell(), filename, part);
            }
        });
        ToolBar toolbar0 = toolBarManager0.createControl((Composite)section0);
        section0.setTextClient((Control)toolbar0);
        this.text = new Text(topGroup, 2048);
        this.text.setEditable(false);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        TableWrapData sectionLayoutData = new TableWrapData(128, 64);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        section0.setLayoutData((Object)sectionLayoutData);
        section0.setClient((Control)topGroup);
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 2;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new TableWrapLayout());
        Section section = new Section(sectionParentComposite, 320);
        section.setText("Runs");
        Composite client = new Composite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.add((IAction)new Action("Download file"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DOWNLOAD_ICON);
            }

            public String getToolTipText() {
                return "Download selected plate layout file";
            }

            public void run() {
                TableItem[] items = OverviewPage.this.runTable.getSelection();
                if (items.length > 0) {
                    TableItem selected = items[0];
                    String filename = selected.getText(2);
                    OverviewPage.this.downloadAction(Display.getCurrent().getActiveShell(), filename, part);
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select a run to download its layout file");
                }
            }
        });
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        sectionLayoutData = new TableWrapData(128, 64);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        section.setLayoutData((Object)sectionLayoutData);
        section.setTextClient((Control)toolbar);
        TableViewer tableViewer1 = new TableViewer(client, 67584);
        this.runTable = tableViewer1.getTable();
        GridData gd_table_1 = new GridData(4, 4, true, true, 1, 1);
        gd_table_1.heightHint = 100;
        this.runTable.setLayoutData((Object)gd_table_1);
        this.runTable.setHeaderVisible(true);
        this.runTable.setLinesVisible(true);
        section.setClient((Control)client);
        compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 2;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        this.tableViewerColumn_2 = new TableViewerColumn(tableViewer1, 0);
        this.tblclmnRunid = this.tableViewerColumn_2.getColumn();
        this.tblclmnRunid.setWidth(100);
        this.tblclmnRunid.setText("Run Id");
        this.tableViewerColumn_4 = new TableViewerColumn(tableViewer1, 0);
        this.tblclmnNumberOfReplicates = this.tableViewerColumn_4.getColumn();
        this.tblclmnNumberOfReplicates.setWidth(100);
        this.tblclmnNumberOfReplicates.setText("Number of Replicates");
        this.tableViewerColumn_3 = new TableViewerColumn(tableViewer1, 0);
        this.tblclmnPlatelayoutfile = this.tableViewerColumn_3.getColumn();
        this.tblclmnPlatelayoutfile.setWidth(700);
        this.tblclmnPlatelayoutfile.setText("Plate Layout File");
        sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new TableWrapLayout());
        Section section2 = new Section(sectionParentComposite, 320);
        section2.setText("Plates");
        Composite client2 = new Composite((Composite)section2, 64);
        GridLayout layout2 = new GridLayout(1, true);
        layout2.marginWidth = 2;
        layout2.marginHeight = 2;
        client2.setLayout((Layout)layout2);
        ToolBarManager toolBarManager2 = new ToolBarManager();
        toolBarManager2.add((IAction)new Action("Show Selected Data"){

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.SHOW_SELECTED_ICON);
            }

            public void run() {
                OverviewPage.this.showSelectedItems(part);
            }
        });
        toolBarManager2.add((IAction)new Action("Download file"){

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.DOWNLOAD_ICON);
            }

            public String getToolTipText() {
                return "Download selected instrument file";
            }

            public void run() {
                TreeItem[] items = OverviewPage.this.plateTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    if (selected.getParentItem() != null) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Wrong selection", (String)"Please select a plate file entry below to download its instrument file");
                    } else {
                        String filename = selected.getText(1);
                        OverviewPage.this.downloadAction(Display.getCurrent().getActiveShell(), filename, part);
                    }
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select a plate file entry below to download its instrument file");
                }
            }
        });
        ToolBar toolbar2 = toolBarManager2.createControl((Composite)section2);
        sectionLayoutData = new TableWrapData(128, 64);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        section2.setLayoutData((Object)sectionLayoutData);
        section2.setTextClient((Control)toolbar2);
        TreeViewer plateTableViewer = new TreeViewer(client2, 67584);
        this.plateTree = plateTableViewer.getTree();
        GridData gd_table_2 = new GridData(4, 4, true, true, 1, 1);
        gd_table_2.heightHint = 300;
        this.plateTree.setLayoutData((Object)gd_table_2);
        this.plateTree.setHeaderVisible(true);
        this.plateTree.setLinesVisible(true);
        section2.setClient((Control)client2);
        compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 2;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        this.treeViewerColumn2 = new TreeViewerColumn(plateTableViewer, 0);
        TreeColumn plateIdColum = this.treeViewerColumn2.getColumn();
        plateIdColum.setWidth(300);
        plateIdColum.setText("Plate Id");
        this.treeViewerColumn3 = new TreeViewerColumn(plateTableViewer, 0);
        TreeColumn tblclmnFile = this.treeViewerColumn3.getColumn();
        tblclmnFile.setWidth(200);
        tblclmnFile.setText("File");
        Composite buttonGroup = new Composite(parent, 0);
        GridData buttonGridData = new GridData();
        buttonGroup.setLayoutData((Object)buttonGridData);
        buttonGridData.horizontalSpan = 1;
        buttonGroup.setLayout((Layout)new GridLayout(4, false));
        this.btnEvaluateData = new Button(buttonGroup, 0);
        this.btnEvaluateData.setText("Evaluate Data");
        this.btnEvaluateData.setToolTipText("Apply rules to determine possible reruns and generate tabs with the modified data");
        this.btnEvaluateData.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Dialog stdevCutoffDialog = new Dialog(Display.getCurrent().getActiveShell()){
                    private ControlDecoration dec2;

                    protected Control createDialogArea(Composite parent) {
                        Composite container = new Composite(parent, 0);
                        GridLayout gridLayout = new GridLayout();
                        gridLayout.numColumns = 2;
                        gridLayout.verticalSpacing = 10;
                        container.setLayout((Layout)gridLayout);
                        Label stDevLabel = new Label(container, 16384);
                        stDevLabel.setText("Maximum Standard Deviation");
                        stDevLabel.setToolTipText("Standard deviation cut-off value. Entries having standard deviations more than this cutoff will be highlighted");
                        Text stDevCutoffText = new Text(container, 2048);
                        stDevCutoffText.setText("" + OverviewPage.this.pcrRun.getStDevCutOff());
                        OverviewPage.this.stDevCutOff = OverviewPage.this.pcrRun.getStDevCutOff();
                        this.dec2 = new ControlDecoration((Control)stDevCutoffText, 16512);
                        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
                        this.dec2.setImage(image);
                        this.dec2.setDescriptionText("Should enter a floating point number");
                        this.dec2.hide();
                        stDevCutoffText.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                Text newText = (Text)e.widget;
                                String newValue = newText.getText();
                                if (newValue != null) {
                                    newValue = newValue.trim();
                                }
                                try {
                                    OverviewPage.this.stDevCutOff = Double.parseDouble(newValue);
                                    dec2.hide();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    dec2.show();
                                }
                            }
                        });
                        return container;
                    }
                };
                if (stdevCutoffDialog.open() == 0) {
                    OverviewPage.this.pcrRun.setStDevCutOff(OverviewPage.this.stDevCutOff);
                    OverviewPage.this.stdevCuttOffText.setText(String.valueOf(OverviewPage.this.stDevCutOff));
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("org.grits.toolbox.entry.qrtpcr.commandparameter.dataOption", String.valueOf(OverviewPage.this.getDataOptionSelection()));
                    OverviewPage.this.handlerService.executeHandler(OverviewPage.this.commandService.createCommand("org.grits.toolbox.entry.qrtpcr.evaluateData", parameters));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.currentDataOption = new Button(buttonGroup, 16);
        this.currentDataOption.setText("Use current data");
        this.currentDataOption.setToolTipText("Use current data to evaluate again. It may not make any changes unless you use a different \"maximum standard deviation\" value");
        this.currentDataOption.setSelection(true);
        this.rawDataOption = new Button(buttonGroup, 16);
        this.rawDataOption.setText("Use raw data");
        this.rawDataOption.setToolTipText("Start from scratch. It will override current evaluation changes");
        this.rawDataOption.setSelection(false);
        this.revertDataOption = new Button(buttonGroup, 16);
        this.revertDataOption.setText("Use reverted data");
        this.revertDataOption.setToolTipText("Revert previous evaluation changes, only keep manual changes and use that data to re-evaluate");
        this.revertDataOption.setSelection(false);
        this.setTables();
        final QrtPCRTableEditor editor = (QrtPCRTableEditor)part.getContext().get(QrtPCRTableEditor.class);
        this.plateTree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem[] treeItemArray = OverviewPage.this.plateTree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getParentItem() != null) {
                        if (item.getImage().equals((Object)CHECKED)) {
                            OverviewPage.this.setChecked(item);
                            OverviewPage.this.showSelectedItems(part);
                            OverviewPage.this.setChecked(item);
                        } else {
                            OverviewPage.this.setChecked(item);
                        }
                        TreeItem parent = item.getParentItem();
                        Integer runId = (Integer)parent.getData();
                        String plateId = parent.getText(0);
                        QrtPCRTable table = OverviewPage.this.pcrRun.getRun(runId);
                        String title = item.getText(0);
                        Boolean raw = (Boolean)item.getData();
                        part.getContext().set(QrtPCRData.class, (Object)table.getPlateDataMap().get(plateId));
                        CTabItem plateTab = new CTabItem(OverviewPage.this.cTabItem.getParent(), 0);
                        plateTab.setText(title);
                        plateTab.setShowClose(true);
                        part.getContext().set(QrtPCRData.class, (Object)table.getPlateDataMap().get(plateId));
                        part.getContext().set(CTabItem.class, (Object)plateTab);
                        part.getContext().set("lowerThresholdContext", (Object)OverviewPage.this.pcrRun.getThreshold());
                        part.getContext().set("stDevContext", (Object)OverviewPage.this.pcrRun.getStDevCutOff());
                        part.getContext().set("rawContext", (Object)raw);
                        part.getContext().set("runIdContext", (Object)runId);
                        PlateTablePage page = (PlateTablePage)ContextInjectionFactory.make(PlateTablePage.class, (IEclipseContext)part.getContext());
                        editor.getcTabItemToPartTabMap().put(plateTab, page);
                        editor.switchToLast();
                    }
                    ++n2;
                }
            }

            public void mouseDown(MouseEvent e) {
                TreeItem[] treeItemArray = OverviewPage.this.plateTree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getImage() != null && e.x > item.getImageBounds((int)0).x && e.x < item.getImageBounds((int)0).x + item.getImage().getBounds().width && e.y > item.getImageBounds((int)0).y && e.y < item.getImageBounds((int)0).y + item.getImage().getBounds().height) {
                        OverviewPage.this.setChecked(item);
                    }
                    ++n2;
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        scrolledComposite.setContent((Control)parent);
        scrolledComposite.setMinSize(parent.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.cTabItem.setControl((Control)scrolledComposite);
    }

    protected int getDataOptionSelection() {
        if (this.rawDataOption.getSelection()) {
            return 1;
        }
        if (this.revertDataOption.getSelection()) {
            return 2;
        }
        return 0;
    }

    protected void createMetadataSection(Composite compositeTop) {
        Composite compositeSettings = new Composite(compositeTop, 0);
        compositeSettings.setLayout((Layout)new GridLayout(2, false));
        Label thresholdLabel = new Label(compositeSettings, 0);
        thresholdLabel.setText("Maximum Cycles");
        Text thresholdText = new Text(compositeSettings, 2056);
        thresholdText.setText("" + this.pcrRun.getThreshold());
        Label stdevCuttOffLabel = new Label(compositeSettings, 0);
        stdevCuttOffLabel.setText("Maximum Standard Deviation");
        this.stdevCuttOffText = new Text(compositeSettings, 2056);
        this.stdevCuttOffText.setText("" + this.pcrRun.getStDevCutOff());
    }

    private void downloadAction(Shell shell, String filename, MPart part) {
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Download");
        fd.setFileName(filename);
        fd.setOverwrite(true);
        String selected = fd.open();
        try {
            if (selected != null && selected.trim().length() != 0) {
                this.downloadFile(filename, selected, part);
            }
        }
        catch (IOException e1) {
            logger.error((Object)"Could not download file", (Throwable)e1);
            MessageDialog.openError((Shell)shell, (String)"File Download Error", (String)"Could not download the file. It has been removed from the workspace");
        }
    }

    protected void downloadFile(String file, String newPath, MPart part) throws IOException {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator;
        QrtPCRTableEditor editor = (QrtPCRTableEditor)part.getContext().get(QrtPCRTableEditor.class);
        Entry qrtPCREntry = editor.getEntry();
        projectFolderLocation = String.valueOf(projectFolderLocation) + qrtPCREntry.getParent().getParent().getDisplayName();
        String fileFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "qrtPCR" + File.separator + "files";
        File workspaceFile = new File(String.valueOf(fileFolderLocation) + File.separator + file);
        FileOutputStream out = new FileOutputStream(newPath);
        Files.copy(workspaceFile.toPath(), out);
        out.close();
    }

    private void showSelectedItems(MPart part) {
        QrtPCRTableEditor editor = (QrtPCRTableEditor)part.getContext().get(QrtPCRTableEditor.class);
        CTabFolder folder = this.cTabItem.getParent();
        CTabItem[] items = folder.getItems();
        int i = 2;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        for (TreeItem item : this.itemsToShow) {
            TreeItem parent = item.getParentItem();
            Integer runId = (Integer)parent.getData();
            String plateId = parent.getText(0);
            QrtPCRTable table = this.pcrRun.getRun(runId);
            String title = item.getText(0);
            Boolean raw = (Boolean)item.getData();
            CTabItem plateTab = new CTabItem(this.cTabItem.getParent(), 0);
            plateTab.setText(title);
            plateTab.setShowClose(true);
            part.getContext().set(CTabItem.class, (Object)plateTab);
            part.getContext().set(QrtPCRData.class, (Object)table.getPlateDataMap().get(plateId));
            part.getContext().set("lowerThresholdContext", (Object)this.pcrRun.getThreshold());
            part.getContext().set("stDevContext", (Object)this.pcrRun.getStDevCutOff());
            part.getContext().set("rawContext", (Object)raw);
            part.getContext().set("runIdContext", (Object)runId);
            PlateTablePage page = (PlateTablePage)ContextInjectionFactory.make(PlateTablePage.class, (IEclipseContext)part.getContext());
            editor.getcTabItemToPartTabMap().put(plateTab, page);
            editor.switchToLast();
        }
    }

    private void setChecked(TreeItem item) {
        if (item.getImage().equals((Object)UNCHECKED)) {
            item.setImage(CHECKED);
            this.itemsToShow.add(item);
        } else {
            item.setImage(UNCHECKED);
            this.itemsToShow.remove(item);
        }
    }

    private void setTables() {
        this.runTable.setRedraw(false);
        this.runTable.removeAll();
        this.runTable.setRedraw(true);
        this.plateTree.setRedraw(false);
        this.plateTree.removeAll();
        this.plateTree.setRedraw(true);
        if (this.pcrRun != null) {
            this.text.setText(this.pcrRun.getGeneListFile());
            for (Integer runId : this.pcrRun.getRunIdTableMap().keySet()) {
                QrtPCRTable table = this.pcrRun.getRunIdTableMap().get(runId);
                QrtPCRData data = table.getPlateDataMap().values().iterator().next();
                int numberOfReplicates = data.getNumberOfReplicates();
                TableItem mainItem = new TableItem(this.runTable, 8);
                mainItem.setText(0, "" + runId);
                mainItem.setText(2, table.getPlateLayoutFile());
                mainItem.setText(1, String.valueOf(numberOfReplicates));
                Map<String, String> fileMap = table.getInstrumentFileMap();
                Iterator<String> iterator1 = fileMap.keySet().iterator();
                while (iterator1.hasNext()) {
                    String plateId;
                    String title = plateId = iterator1.next();
                    if (runId > 0) {
                        title = "rerun-" + runId + "-" + title;
                    }
                    title = String.valueOf(title) + "-raw";
                    TreeItem parent = new TreeItem(this.plateTree, 0);
                    parent.setText(0, plateId);
                    parent.setText(1, fileMap.get(plateId));
                    parent.setData((Object)runId);
                    TreeItem child1 = new TreeItem(parent, 0);
                    child1.setText(0, title);
                    child1.setImage(UNCHECKED);
                    child1.setText(1, "");
                    child1.setData((Object)true);
                    if (!table.getOriginal().booleanValue()) {
                        TreeItem child2 = new TreeItem(parent, 0);
                        title = String.valueOf(plateId) + "-" + "analyzed";
                        if (runId > 0) {
                            title = "rerun-" + runId + "-" + title;
                        }
                        child2.setText(0, title);
                        child2.setImage(UNCHECKED);
                        child2.setText(1, "");
                        child2.setData((Object)false);
                    }
                    parent.setExpanded(true);
                }
            }
        }
    }

    public void addPageToPlateTable(Integer runId, String plateId, String filename, boolean original) {
        boolean found = false;
        TreeItem[] treeItemArray = this.plateTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Integer runIdValue = (Integer)item.getData();
            String plateIdString = item.getText(0);
            if (runIdValue == runId && plateIdString.equals(plateId)) {
                TreeItem newChild = new TreeItem(item, 0);
                String title = plateId;
                if (runId > 0) {
                    title = "rerun-" + runId + "-" + title;
                }
                title = original ? String.valueOf(title) + "-raw" : String.valueOf(title) + "-" + "analyzed";
                newChild.setText(0, title);
                newChild.setText(1, "");
                newChild.setImage(UNCHECKED);
                newChild.setData((Object)original);
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            TreeItem parent = new TreeItem(this.plateTree, 0);
            parent.setText(0, plateId);
            parent.setText(1, filename);
            parent.setData((Object)runId);
            TreeItem child1 = new TreeItem(parent, 0);
            String title = plateId;
            if (runId > 0) {
                title = "rerun-" + runId + "-" + title;
            }
            title = original ? String.valueOf(title) + "-raw" : String.valueOf(title) + "-" + "analyzed";
            child1.setText(0, title);
            child1.setImage(UNCHECKED);
            child1.setText(1, "");
            child1.setData((Object)original);
            parent.setExpanded(true);
        }
        this.plateTree.redraw();
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
    }
}

