/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map.analysis;

import java.util.Comparator;
import java.util.HashMap;
import org.glycoinfo.WURCSFramework.util.map.analysis.MorganAlgorithmForMAP;
import org.glycoinfo.WURCSFramework.util.map.analysis.MorganAlgorithmWithAtomTypeForMAP;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.MAPConnectionComparatorUsingCIPSystem;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomAbstract;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStar;

public class MAPStarComparator
implements Comparator<MAPStar> {
    private MAPGraph m_oGraph;
    private HashMap<MAPAtomAbstract, Integer> m_mapAtomToMorganNumber;
    private HashMap<MAPAtomAbstract, Integer> m_mapAtomToMorganNumberWithAtomType;
    private MAPConnectionComparatorUsingCIPSystem m_oCIPComp;

    public MAPStarComparator(MAPGraph a_oGraph) {
        this.m_oGraph = a_oGraph;
        MorganAlgorithmForMAP t_oMA = new MorganAlgorithmForMAP(this.m_oGraph);
        t_oMA.calcMorganNumber(null, null);
        this.m_mapAtomToMorganNumber = t_oMA.getAtomToMorganNumber();
        t_oMA = new MorganAlgorithmWithAtomTypeForMAP(this.m_oGraph);
        t_oMA.calcMorganNumber(null, null);
        this.m_mapAtomToMorganNumberWithAtomType = t_oMA.getAtomToMorganNumber();
        this.m_oCIPComp = new MAPConnectionComparatorUsingCIPSystem(a_oGraph);
    }

    @Override
    public int compare(MAPStar a_oStar1, MAPStar a_oStar2) {
        int t_iStarIndex2;
        MAPConnection t_oConn2;
        int t_iMorganNum2;
        int t_iComp = 0;
        int t_iMorganNum1 = this.m_mapAtomToMorganNumber.get(a_oStar1);
        t_iComp = t_iMorganNum1 - (t_iMorganNum2 = this.m_mapAtomToMorganNumber.get(a_oStar2).intValue());
        if (t_iComp != 0) {
            return t_iComp;
        }
        t_iMorganNum1 = this.m_mapAtomToMorganNumberWithAtomType.get(a_oStar1);
        t_iComp = t_iMorganNum1 - (t_iMorganNum2 = this.m_mapAtomToMorganNumberWithAtomType.get(a_oStar2).intValue());
        if (t_iComp != 0) {
            return t_iComp;
        }
        MAPConnection t_oConn1 = a_oStar1.getConnection();
        t_iComp = this.m_oCIPComp.compare(t_oConn1, t_oConn2 = a_oStar2.getConnection());
        if (t_iComp != 0) {
            return t_iComp;
        }
        int t_iStarIndex1 = a_oStar1.getStarIndex();
        t_iComp = t_iStarIndex1 - (t_iStarIndex2 = a_oStar2.getStarIndex());
        if (t_iComp != 0) {
            return t_iComp;
        }
        return 0;
    }
}

