/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.generator.structure;

import java.util.ArrayList;
import java.util.List;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.util.generator.LipidParametersIO;

public abstract class LipidsGeneratorAbstract {
    private LipidParametersIO m_parameters = new LipidParametersIO();
    private List<ILipid> m_listGeneratedLipids = new ArrayList<ILipid>();

    public void setParameters(LipidParametersIO a_params) {
        this.m_parameters = a_params;
    }

    public LipidParametersIO getParameters() {
        return this.m_parameters;
    }

    protected void addLipid(ILipid a_ILip) {
        this.m_listGeneratedLipids.add(a_ILip);
    }

    public List<ILipid> getLipids() {
        return this.m_listGeneratedLipids;
    }

    public void generate() {
        this.m_parameters.fill();
        for (int t_nCarbons : this.m_parameters.getCarbonLengthes()) {
            if (this.m_parameters.isOnlyEvenNumberForCarbonLength() && t_nCarbons % 2 == 1) continue;
            for (int t_nOH : this.m_parameters.getNumbersOfHydroxylGroups()) {
                for (int t_nOAc : this.m_parameters.getNumbersOfOAcetylGroups()) {
                    for (int t_nDB : this.m_parameters.getNumbersOfDoubleBonds()) {
                        Lipid t_oLipid = this.generateLipid(t_nCarbons, t_nOH, t_nOAc, t_nDB);
                        this.addLipid(t_oLipid);
                    }
                }
            }
        }
    }

    public String printParameters() {
        return this.m_parameters.printParameters();
    }

    protected abstract Lipid generateLipid(int var1, int var2, int var3, int var4);
}

