/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.structure;

import java.util.HashMap;
import java.util.Map;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;

public class LipidFragmentInfo {
    public static String Z = "Z";
    public static String Y = "Y";
    public static String W = "W";
    public static String U = "U";
    private ILipid m_lipFragment;
    private Map<String, Integer> m_mapFragmentTypeToNum;

    public LipidFragmentInfo(ILipid a_lipFragment) {
        this.m_lipFragment = a_lipFragment;
        this.m_mapFragmentTypeToNum = new HashMap<String, Integer>();
    }

    public void addFragmentType(String a_strFragmentType, int a_nFragmentType) {
        if (a_nFragmentType == 0) {
            return;
        }
        int t_nFragType = a_nFragmentType;
        if (this.m_mapFragmentTypeToNum.containsKey(a_strFragmentType) && (t_nFragType += this.m_mapFragmentTypeToNum.get(a_strFragmentType).intValue()) == 0) {
            this.m_mapFragmentTypeToNum.remove(a_strFragmentType);
            return;
        }
        this.m_mapFragmentTypeToNum.put(a_strFragmentType, t_nFragType);
    }

    public void addFragmentType(String a_strFragmentType) {
        if (a_strFragmentType == null) {
            return;
        }
        String[] stringArray = a_strFragmentType.split("-");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t_strFragmentType;
            String t_strFragmentType0 = t_strFragmentType = stringArray[n2];
            int t_nFragmentType = 1;
            if (!t_strFragmentType.isEmpty()) {
                int i = 1;
                while (i < t_strFragmentType.length()) {
                    String t_strSub = t_strFragmentType.substring(0, i);
                    try {
                        t_nFragmentType = Integer.parseInt(t_strSub);
                        t_strFragmentType0 = t_strFragmentType.substring(i);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                    ++i;
                }
                this.addFragmentType(t_strFragmentType0, t_nFragmentType);
            }
            ++n2;
        }
    }

    public ILipid getFragment() {
        return this.m_lipFragment;
    }

    public Map<String, Integer> getFragmentTypeToNumber() {
        return this.m_mapFragmentTypeToNum;
    }

    public String getFragmentType() {
        String t_strFragment = "";
        String t_strH2OLoss = "";
        for (String t_strFragType : this.m_mapFragmentTypeToNum.keySet()) {
            Integer t_nFrag = this.m_mapFragmentTypeToNum.get(t_strFragType);
            if (t_nFrag == null || t_nFrag == 0) continue;
            if (t_strFragType.contains("H2O")) {
                t_strH2OLoss = String.valueOf(t_strH2OLoss) + "-";
                if (t_nFrag > 1) {
                    t_strH2OLoss = String.valueOf(t_strH2OLoss) + t_nFrag;
                }
                t_strH2OLoss = String.valueOf(t_strH2OLoss) + "H2O";
                continue;
            }
            t_strFragment = String.valueOf(t_strFragment) + "-";
            if (t_nFrag > 1) {
                t_strFragment = String.valueOf(t_strFragment) + t_nFrag;
            }
            t_strFragment = String.valueOf(t_strFragment) + t_strFragType;
        }
        t_strFragment = String.valueOf(t_strFragment) + t_strH2OLoss;
        return t_strFragment;
    }
}

