/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.toolbar;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.sample.dialog.setTemplate.SetTemplateDialog;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.part.IAnalytePartTab;

public class SetTemplate {
    private Logger logger = Logger.getLogger(SetTemplate.class);
    @Inject
    IEventBroker eventBroker;
    @Inject
    ISampleOntologyApi sampleOntologyApi;

    @Execute
    public void execute(Shell shell, IAnalytePartTab analytePartTab) {
        this.logger.info((Object)"setting template for component");
        Component component = (Component)analytePartTab.getInput();
        this.logger.info((Object)("component name : " + component.getLabel()));
        SetTemplateDialog dialog = new SetTemplateDialog(shell, this.sampleOntologyApi, component);
        if (dialog.open() == 0) {
            Template template = dialog.getTemplate();
            String templateUri = template.getUri();
            this.logger.info((Object)("template selected : " + template.getLabel()));
            try {
                if (templateUri == null) {
                    this.logger.info((Object)("Creating new template in the ontology : " + template.getLabel()));
                    templateUri = this.sampleOntologyApi.createNewTemplate(template);
                }
                if (!templateUri.equals(component.getTemplateUri())) {
                    this.logger.info((Object)("setting template for the component : " + templateUri));
                    component.setTemplateUri(templateUri);
                    this.eventBroker.post("component_modified_in_a_tab", (Object)component);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)"Template Not Added", (String)("Error setting template : " + template.getLabel() + "\n\n" + e + "\n" + e.getMessage()));
            }
        }
    }
}

