/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.exec;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.TreeMap;
import org.glycoinfo.WURCSFramework.util.WURCSValidator;

public class WURCSValidatorTestFromStream {
    public static void main(String[] args) {
        TreeMap<Object, Object> t_mapWURCSIndex = new TreeMap();
        try {
            t_mapWURCSIndex = WURCSValidatorTestFromStream.readWURCS(new BufferedReader(new InputStreamReader(System.in, "utf-8")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String key : t_mapWURCSIndex.keySet()) {
            String t_strWURCS = (String)t_mapWURCSIndex.get(key);
            WURCSValidator validator = new WURCSValidator();
            validator.start(t_strWURCS);
            if (validator.getTheNumberOfErrors() == 0 && validator.getTheNumberOfWarnings() == 0) continue;
            System.out.println(key + ": " + t_strWURCS);
            if (validator.getTheNumberOfErrors() == 0) {
                System.out.println("outWURCS: " + validator.getStandardWURCS());
            }
            System.out.println("the number of errors: " + validator.getTheNumberOfErrors());
            for (String er : validator.getErrors()) {
                System.out.println("\tError:   " + er);
            }
            for (String wa : validator.getWarnings()) {
                System.out.println("\tWarning: " + wa);
            }
            System.out.println();
        }
    }

    public static TreeMap<String, String> readWURCS(BufferedReader a_bfFile) throws IOException {
        String line = "";
        TreeMap<String, String> wret = new TreeMap<String, String>();
        wret.clear();
        while ((line = a_bfFile.readLine()) != null) {
            String[] IDandWURCS;
            line.trim();
            if (line.indexOf("WURCS") == -1 || (IDandWURCS = line.split("\t")).length != 2) continue;
            wret.put(IDandWURCS[0].trim(), IDandWURCS[1]);
        }
        a_bfFile.close();
        return wret;
    }
}

