/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.exec;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.array.WURCSImporter;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSArrayToGraph;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSGraphToArray;
import org.glycoinfo.WURCSFramework.util.graph.WURCSGraphNormalizer;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class NormalizeWURCSTestFromFile {
    public static void main(String[] args) {
        String t_strDir = "/Users/muller/work/wurcs/test2/";
        String t_strWURCSFile = "alter_test4.txt";
        String input = t_strDir + t_strWURCSFile;
        String output = t_strDir + "alter_test4_out.txt";
        TreeMap<Object, Object> t_mapWURCSIndex = new TreeMap();
        WURCSImporter t_objImporter = new WURCSImporter();
        if (!new File(input).isFile()) {
            System.err.println("File not found");
            System.exit(0);
        }
        try {
            t_mapWURCSIndex = NormalizeWURCSTestFromFile.readWURCS(new BufferedReader(new FileReader(input)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            WURCSExporter t_oExporter = new WURCSExporter();
            PrintWriter pw = NormalizeWURCSTestFromFile.openTextFileW(output);
            TreeSet<Object> t_aUniqueOrigWURCS = new TreeSet<Object>();
            TreeMap t_mapUniqueGraphWURCStoID = new TreeMap();
            TreeSet<String> t_aSortLIN = new TreeSet<String>();
            TreeSet<String> t_aInvert = new TreeSet<String>();
            TreeSet<String> t_aAnomLink = new TreeSet<String>();
            TreeSet<String> t_aCyclic = new TreeSet<String>();
            TreeSet<String> t_aOthers = new TreeSet<String>();
            int changeCount = 0;
            for (String string : t_mapWURCSIndex.keySet()) {
                if (t_aUniqueOrigWURCS.contains(t_mapWURCSIndex.get(string))) continue;
                t_aUniqueOrigWURCS.add(t_mapWURCSIndex.get(string));
                System.err.println(string + ":");
                String t_strOrigWURCS = (String)t_mapWURCSIndex.get(string);
                WURCSArray t_oWURCS = t_objImporter.extractWURCSArray((String)t_mapWURCSIndex.get(string));
                String t_strSortLIN = t_oExporter.getWURCSString(t_oWURCS);
                if (!t_strOrigWURCS.equals(t_strSortLIN)) {
                    t_aSortLIN.add(string);
                }
                WURCSArrayToGraph t_oA2G = new WURCSArrayToGraph();
                t_oA2G.start(t_oWURCS);
                WURCSGraph t_oGraph = t_oA2G.getGraph();
                WURCSGraphNormalizer t_oNorm = new WURCSGraphNormalizer();
                t_oNorm.start(t_oGraph);
                if (t_oNorm.isInverted()) {
                    t_aInvert.add(string);
                }
                WURCSGraphToArray t_oG2A = new WURCSGraphToArray();
                t_oG2A.start(t_oGraph);
                t_oWURCS = t_oG2A.getWURCSArray();
                String t_strSortGraph = t_oExporter.getWURCSString(t_oWURCS);
                if (!t_mapUniqueGraphWURCStoID.containsKey(t_strSortGraph)) {
                    t_mapUniqueGraphWURCStoID.put(t_strSortGraph, new TreeSet());
                }
                ((TreeSet)t_mapUniqueGraphWURCStoID.get(t_strSortGraph)).add(string);
                if (t_strOrigWURCS.equals(t_strSortGraph)) continue;
                ++changeCount;
                pw.print(string + ":");
                if (!t_strOrigWURCS.equals(t_strSortLIN)) {
                    pw.print(" LIN or MOD Sort :");
                }
                if (t_oNorm.isInverted()) {
                    pw.print(" Invert :");
                }
                if (t_oNorm.linkedAnomericPositions()) {
                    pw.print(" Anomeric linkage :");
                }
                if (t_oNorm.hasCyclic()) {
                    pw.print(" Cyclic :");
                }
                pw.println("\n\t" + t_strOrigWURCS);
                if (!t_strOrigWURCS.equals(t_strSortLIN)) {
                    pw.println("\t" + t_strSortLIN);
                }
                if (t_strSortLIN.equals(t_strSortGraph)) continue;
                pw.println("\t" + t_strSortGraph);
                if (t_oNorm.linkedAnomericPositions()) {
                    t_aAnomLink.add(string);
                }
                if (t_oNorm.hasCyclic()) {
                    t_aCyclic.add(string);
                }
                if (t_oNorm.isInverted() || t_oNorm.linkedAnomericPositions() || t_oNorm.hasCyclic()) continue;
                t_aOthers.add(string);
            }
            pw.println("\nTotal change count: " + changeCount);
            pw.println("Sort change count: " + t_aSortLIN.size());
            pw.println(NormalizeWURCSTestFromFile.join(t_aSortLIN));
            pw.println("Invert count: " + t_aInvert.size());
            pw.println(NormalizeWURCSTestFromFile.join(t_aInvert));
            pw.println("Anomeric bonding count: " + t_aAnomLink.size());
            pw.println(NormalizeWURCSTestFromFile.join(t_aAnomLink));
            pw.println("Cyclic count: " + t_aCyclic.size());
            pw.println(NormalizeWURCSTestFromFile.join(t_aCyclic));
            pw.println("Other count: " + t_aOthers.size());
            pw.println(NormalizeWURCSTestFromFile.join(t_aOthers));
            pw.println("Duplicate:");
            for (String string : t_mapUniqueGraphWURCStoID.keySet()) {
                if (((TreeSet)t_mapUniqueGraphWURCStoID.get(string)).size() < 2) continue;
                pw.println(NormalizeWURCSTestFromFile.join((Set)t_mapUniqueGraphWURCStoID.get(string)));
                pw.println(string);
            }
        }
        catch (WURCSFormatException e) {
            e.printStackTrace();
        }
        catch (WURCSException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String join(Set<String> t_aList) {
        String t_strJoin = "";
        int count = 0;
        for (String t_strInv : t_aList) {
            if (!t_strJoin.equals("")) {
                t_strJoin = t_strJoin + ",";
            }
            if (count != 0 && count % 20 == 0) {
                t_strJoin = t_strJoin + "\n";
            }
            t_strJoin = t_strJoin + t_strInv;
            ++count;
        }
        return t_strJoin;
    }

    public static PrintWriter openTextFileW(String fileName) throws Exception {
        String charSet = "utf-8";
        boolean append = false;
        boolean autoFlush = true;
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName), append), charSet)), autoFlush);
    }

    public static TreeMap<String, String> openString(String a_strFile) throws Exception {
        try {
            return NormalizeWURCSTestFromFile.readWURCS(new BufferedReader(new FileReader(a_strFile)));
        }
        catch (IOException e) {
            throw new Exception();
        }
    }

    public static TreeMap<String, String> readWURCS(BufferedReader a_bfFile) throws IOException {
        String line = "";
        TreeMap<String, String> wret = new TreeMap<String, String>();
        wret.clear();
        while ((line = a_bfFile.readLine()) != null) {
            String[] IDandWURCS;
            line.trim();
            if (line.indexOf("WURCS") == -1 || (IDandWURCS = line.split("\t")).length != 2) continue;
            wret.put(IDandWURCS[0].trim(), IDandWURCS[1]);
        }
        a_bfFile.close();
        return wret;
    }
}

