/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.wizards.createnew;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanAnnotationFilterSetup;
import org.grits.toolbox.entry.ms.annotation.glycan.filter.MSGlycanCustomFilterSelection;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.tools.databasebot.om.DatabaseBotSettings;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class FilterPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(FilterPage.class);
    private FiltersLibrary m_filterLibrary = new FiltersLibrary();
    private MSGlycanAnnotationFilterSetup m_filterSetup;

    public FilterPage(ImageDescriptor a_titleImage) {
        super("Filter", "Filter settings", a_titleImage);
        this.setDescription("Configure filters to exclude structures.");
        String t_filterFile = null;
        try {
            this.m_filterLibrary = FilterUtils.readFilters((String)FileUtils.getFilterPath());
        }
        catch (Exception e) {
            logger.error((Object)("Unable to load filter library:" + t_filterFile), (Throwable)e);
        }
    }

    public void createControl(Composite a_parent) {
        ScrolledComposite t_compositeScrollable = new ScrolledComposite(a_parent, 2816);
        t_compositeScrollable.setExpandVertical(true);
        t_compositeScrollable.setExpandHorizontal(true);
        GridData t_gridDataScrollable = new GridData(4, 4, true, true);
        t_compositeScrollable.setLayoutData((Object)t_gridDataScrollable);
        Composite t_container = new Composite((Composite)t_compositeScrollable, 0);
        MSGlycanCustomFilterSelection t_customFilterSelection = new MSGlycanCustomFilterSelection();
        t_customFilterSelection.createFilterSelectionArea(t_container);
        this.m_filterSetup = new MSGlycanAnnotationFilterSetup(this.m_filterLibrary.getCategories());
        this.m_filterSetup.setFilterList(this.m_filterLibrary.getFilters());
        try {
            this.m_filterSetup.createFilterTableSection(t_container);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating the filter table", (Throwable)e);
        }
        t_customFilterSelection.setFilterTableSetup((FilterTableSetup)this.m_filterSetup);
        t_compositeScrollable.setContent((Control)t_container);
        t_compositeScrollable.setMinSize(t_container.computeSize(-1, -1));
        this.setControl((Control)t_compositeScrollable);
        this.setPageComplete(true);
    }

    public void fillCreateDatabaseSettings(DatabaseBotSettings a_settings) {
        a_settings.setFilterSetting(this.m_filterSetup.getFilterSetting());
    }
}

