/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.grits.toolbox.tools.glycanbuilder.core.io.SequenceFormat;

public class ImportTextComposite {
    private FormToolkit m_toolkit;
    private Combo m_cmbFormat;
    private Text m_txtSequence;
    private Button m_btnImport;
    private Button m_btnClear;
    private List<SelectionListener> m_lImportListeners = new ArrayList<SelectionListener>();
    private String m_strSequence;
    private SequenceFormat m_format;

    public ImportTextComposite(Composite parent, FormToolkit toolkit) {
        this.m_toolkit = toolkit;
        this.createControls(parent);
    }

    public ImportTextComposite(Composite parent) {
        this.m_toolkit = new FormToolkit(parent.getDisplay());
        this.createControls(parent);
    }

    public String getSequence() {
        return this.m_strSequence;
    }

    public SequenceFormat getSequenceFormat() {
        return this.m_format;
    }

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        this.m_toolkit.createLabel(parent, "String encoded");
        this.m_cmbFormat = new Combo(parent, 8);
        this.m_cmbFormat.setItems(SequenceFormat.getNames());
        this.m_cmbFormat.select(0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.m_cmbFormat);
        this.m_txtSequence = this.createText(parent, null, "Enter a glycan sequence", 2048);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 80).span(2, 1).applyTo((Control)this.m_txtSequence);
        this.m_btnImport = this.m_toolkit.createButton(parent, "Import", 0x800000);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.m_btnImport);
        this.m_btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTextComposite.this.setValues();
            }
        });
        this.m_btnClear = this.m_toolkit.createButton(parent, "Clear", 0x800000);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.m_btnClear);
        this.m_btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTextComposite.this.clearText();
            }
        });
    }

    private Text createText(Composite parent, String value, String message, int style) {
        Text txt = this.m_toolkit.createText(parent, value, style |= 0x242);
        txt.setMessage(message);
        txt.setToolTipText(message);
        Listener scrollBarListener = new Listener(){

            public void handleEvent(Event event) {
                Text t = (Text)event.widget;
                if (t.getVerticalBar() != null) {
                    Rectangle r1 = t.getClientArea();
                    Rectangle r2 = t.computeTrim(r1.x, r1.y, r1.width, r1.height);
                    Point p = t.computeSize(-1, -1, true);
                    t.getVerticalBar().setVisible(r2.height <= p.y);
                }
                if (event.type == 24) {
                    t.getParent().layout(true);
                    t.showSelection();
                }
            }
        };
        txt.addListener(11, scrollBarListener);
        txt.addListener(24, scrollBarListener);
        return txt;
    }

    public void addImportListener(SelectionListener l) {
        if (this.m_lImportListeners.contains(l)) {
            return;
        }
        this.m_lImportListeners.add(l);
        this.m_btnImport.addSelectionListener(l);
    }

    public void removeImportListener(SelectionListener l) {
        if (!this.m_lImportListeners.contains(l)) {
            return;
        }
        this.m_lImportListeners.remove(l);
        this.m_btnImport.removeSelectionListener(l);
    }

    public void clearImportListeners() {
        for (SelectionListener l : this.m_lImportListeners) {
            this.m_btnImport.removeSelectionListener(l);
        }
    }

    private void setValues() {
        this.m_format = SequenceFormat.values()[this.m_cmbFormat.getSelectionIndex()];
        this.m_strSequence = this.m_txtSequence.getText();
    }

    public void clearText() {
        this.m_txtSequence.setText("");
    }
}

