/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.canvas;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TerminalType;
import org.grits.toolbox.tools.glycanbuilder.core.io.GlycanIOUtils;
import org.grits.toolbox.tools.glycanbuilder.core.io.SequenceFormat;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.CoreDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.ResidueDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.TerminalDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.utils.ResidueOperationUtils;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasInterface;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanLabel;
import org.grits.toolbox.tools.glycanbuilder.widgets.dialog.RepititionPropertyDialog;
import org.grits.toolbox.tools.glycanbuilder.widgets.dialog.ResiduePropertyDialog;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.ClipUtils;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GeneralIconProvider;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GlycanIconProvider;

public class GlycanCanvasMenu {
    public static void setMenu(GlycanCanvasInterface canvas) {
        Control control = canvas.getControl();
        GlycanCanvasMenu.disposeMenu(control.getMenu());
        Menu menu = new Menu(control);
        GlycanCanvasMenu.addCommonMenuItems(canvas, menu);
        new MenuItem(menu, 2);
        if (canvas instanceof GlycanLabel) {
            GlycanLabel label = (GlycanLabel)canvas;
            if (label.getCurrentResidue() != null) {
                GlycanCanvasMenu.addResidueMenuItems(label, menu);
            } else if (label.getCurrentLinkage() != null) {
                GlycanCanvasMenu.addLinkageMenuItems(label, menu);
            } else {
                GlycanCanvasMenu.addGlycanMenuItems(label, menu);
            }
            if (label.canAddBracket()) {
                GlycanCanvasMenu.addBracketMenuItem(label, menu);
            }
        } else {
            GlycanCanvasMenu.addGlycanMenuItems(canvas, menu);
        }
        if (canvas instanceof GlycanLabel) {
            new MenuItem(menu, 2);
            GlycanCanvasMenu.addResiduePropertyMenu((GlycanLabel)canvas, menu);
            GlycanCanvasMenu.addMassOptionsMenu((GlycanLabel)canvas, menu);
        }
        new MenuItem(menu, 2);
        GlycanCanvasMenu.addSaveMenuItems(canvas, menu);
        control.setMenu(menu);
    }

    private static void disposeMenu(Menu menu) {
        if (menu == null) {
            return;
        }
        if (menu.isDisposed()) {
            return;
        }
        menu.dispose();
    }

    private static void addCommonMenuItems(final GlycanCanvasInterface canvas, Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Cut\tCtrl+X");
        item.setImage(GeneralIconProvider.getCutIcon());
        item.setEnabled(canvas.canCut());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.cut();
                canvas.updateView(true);
            }
        });
        item = new MenuItem(menu, 64);
        item.setText("Copy\tCtrl+C");
        item.setImage(GeneralIconProvider.getCopyIcon());
        item.setEnabled(canvas.canCopy());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.copy();
                canvas.updateView(true);
            }
        });
        item = new MenuItem(menu, 64);
        item.setText("Paste\tCtrl+V");
        item.setImage(GeneralIconProvider.getPasteIcon());
        item.setEnabled(canvas.canPaste());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.paste();
                canvas.updateView(true);
            }
        });
        item = new MenuItem(menu, 64);
        item.setText("Delete\tDelete");
        item.setImage(GeneralIconProvider.getDeleteIcon());
        item.setEnabled(canvas.canDelete());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.delete();
                canvas.updateView(true);
            }
        });
    }

    private static void addGlycanMenuItems(GlycanCanvasInterface canvas, Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Add structure");
        GlycanCanvasMenu.addCoreGlycanMenu(canvas, item);
        item = new MenuItem(menu, 64);
        item.setText("Add terminal structure");
        GlycanCanvasMenu.addTerminalMenu(canvas, item);
    }

    private static void addCoreGlycanMenu(final GlycanCanvasInterface canvas, MenuItem parentItem) {
        Menu menuSub = new Menu(parentItem);
        for (String sup : CoreDictionary.getSuperclasses()) {
            MenuItem itemSup = new MenuItem(menuSub, 64);
            itemSup.setText(sup);
            Menu menuSup = new Menu(itemSup);
            for (CoreType coreType : CoreDictionary.getCores(sup)) {
                MenuItem itemCore = new MenuItem(menuSup, 64);
                itemCore.setText(coreType.getDescription());
                itemCore.setImage(GlycanIconProvider.getGlycanCoreIcon(coreType));
                itemCore.setToolTipText(coreType.getDescription());
                final Glycan g = Glycan.fromString((String)coreType.getStructure());
                itemCore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        canvas.addGlycan(g);
                        canvas.updateView(true);
                    }
                });
            }
            itemSup.setMenu(menuSup);
        }
        parentItem.setMenu(menuSub);
    }

    private static void addTerminalMenu(final GlycanCanvasInterface canvas, MenuItem parentItem) {
        Menu menuSub = new Menu(parentItem);
        for (String sup : TerminalDictionary.getSuperclasses()) {
            MenuItem itemSup = new MenuItem(menuSub, 64);
            itemSup.setText(sup);
            Menu menuSup = new Menu(itemSup);
            for (final TerminalType termType : TerminalDictionary.getTerminals(sup)) {
                if (!GlycanCanvasMenu.canAddTerminal(canvas, termType)) continue;
                MenuItem itemCore = new MenuItem(menuSup, 64);
                itemCore.setText(termType.getDescription());
                itemCore.setImage(GlycanIconProvider.getGlycanTerminalIcon(termType));
                itemCore.setToolTipText(termType.getDescription());
                itemCore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            canvas.addResidue(termType.newTerminal());
                            canvas.updateView(true);
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            if (menuSup.getItemCount() == 0) {
                menuSup.dispose();
                itemSup.dispose();
                continue;
            }
            itemSup.setMenu(menuSup);
        }
        if (menuSub.getItemCount() == 0) {
            menuSub.dispose();
            parentItem.dispose();
            return;
        }
        parentItem.setMenu(menuSub);
    }

    private static boolean canAddTerminal(GlycanCanvasInterface canvas, TerminalType termType) {
        GlycanLabel label;
        Residue root;
        block7: {
            try {
                root = termType.newTerminal();
                label = null;
                if (canvas instanceof GlycanLabel) {
                    label = (GlycanLabel)canvas;
                } else if (canvas instanceof GlycanCanvasComposite) {
                    label = ((GlycanCanvasComposite)canvas).getCurrentGlycanLabel();
                }
                if (label != null) break block7;
                return true;
            }
            catch (Exception exception) {}
        }
        if (label.getCurrentResidue() != null) {
            return ResidueOperationUtils.canModifyResidue(label.getCurrentResidue(), root, "Add");
        }
        return false;
    }

    private static void addResidueMenuItems(final GlycanLabel label, Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Add residue");
        GlycanCanvasMenu.addResidueAdditionMenu(label, item, "Add");
        item = new MenuItem(menu, 64);
        item.setText("Add terminal");
        GlycanCanvasMenu.addTerminalMenu(label, item);
        item = new MenuItem(menu, 64);
        item.setText("Insert residue before");
        GlycanCanvasMenu.addResidueAdditionMenu(label, item, "Insert");
        item = new MenuItem(menu, 64);
        item.setText("Change residue type");
        GlycanCanvasMenu.addResidueAdditionMenu(label, item, "Change");
        item = new MenuItem(menu, 64);
        item.setText("Add repeating unit");
        item.setEnabled(label.hasSelectedResidues());
        item.setImage(GeneralIconProvider.getRepeatIcon());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                label.createRepitition();
                label.updateView(true);
            }
        });
    }

    private static void addResidueAdditionMenu(final GlycanLabel label, MenuItem parentItem, final String mode) {
        if (!(mode.equals("Add") || mode.equals("Insert") || mode.equals("Change"))) {
            return;
        }
        Menu menuSub = new Menu(parentItem);
        for (String sup : ResidueDictionary.getSuperclasses()) {
            if (sup.equals("Reducing end")) continue;
            MenuItem itemSup = new MenuItem(menuSub, 64);
            itemSup.setText(sup);
            Menu menuSup = new Menu(itemSup);
            for (final ResidueType resType : ResidueDictionary.getResidues(sup)) {
                if (!ResidueOperationUtils.canModifyResidueToLabel(label, new Residue(resType), mode)) continue;
                MenuItem itemRes = new MenuItem(menuSup, 64);
                itemRes.setText(resType.getName());
                itemRes.setImage(GlycanIconProvider.getResidueIcon(resType));
                itemRes.setToolTipText(resType.getDescription());
                itemRes.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (mode.equals("Add")) {
                            label.addResidue(new Residue(resType));
                        } else if (mode.equals("Insert")) {
                            if (label.getCurrentResidue() != null) {
                                label.insertResidueBefore(new Residue(resType));
                            } else if (label.getCurrentLinkage() != null) {
                                label.insertResidue(new Residue(resType));
                            }
                        } else if (mode.equals("Change")) {
                            label.changeResidueType(resType);
                        }
                        label.getBuilderWorkspace().getResidueHistory().add(resType);
                        label.updateView(true);
                    }
                });
            }
            if (menuSup.getItemCount() == 0) {
                menuSup.dispose();
                itemSup.dispose();
                continue;
            }
            itemSup.setMenu(menuSup);
        }
        if (menuSub.getItemCount() == 0) {
            menuSub.dispose();
            parentItem.dispose();
            return;
        }
        parentItem.setMenu(menuSub);
    }

    private static void addLinkageMenuItems(GlycanLabel label, Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Insert residue");
        GlycanCanvasMenu.addResidueAdditionMenu(label, item, "Insert");
    }

    private static void addBracketMenuItem(final GlycanLabel label, Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Add bracket");
        item.setEnabled(label.canAddBracket());
        item.setImage(GeneralIconProvider.getBracketIcon());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                label.addBracket();
                label.updateView(true);
            }
        });
    }

    private static void addResiduePropertyMenu(final GlycanLabel label, final Menu menu) {
        if (label.getCurrentResidue() == null) {
            return;
        }
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Residue properties");
        item.setImage(GeneralIconProvider.getResiduePropertiesIcon());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Residue res = label.getCurrentResidue();
                if (res == null) {
                    return;
                }
                TitleAreaDialog dlg = res.isEndRepetition() ? new RepititionPropertyDialog(menu.getShell(), res) : new ResiduePropertyDialog(menu.getShell(), res);
                dlg.open();
                label.updateView(true);
            }
        });
    }

    private static void addMassOptionsMenu(final GlycanLabel label, Menu menu) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                label.changeReducingEndType();
                label.redrawGlycan(true);
            }
        };
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Change reducing end type");
        item.addSelectionListener((SelectionListener)listener);
        item = new MenuItem(menu, 64);
        item.setText("Mass options of selected structure");
        item.addSelectionListener((SelectionListener)listener);
    }

    private static void addSaveMenuItems(final GlycanCanvasInterface canvas, Menu menu) {
        GlycanCanvasMenu.addCopyToClipboardMenu(canvas, menu);
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Save image");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Glycan> lGlycans = canvas.hasSelection() ? canvas.getSelectedGlycans() : canvas.getAllGlycans();
                if (lGlycans.isEmpty()) {
                    MessageBox box = new MessageBox(canvas.getControl().getShell(), 40);
                    box.setMessage("No glycans in this canvas.");
                    box.open();
                    return;
                }
                GlycanIOUtils.saveGlycanImage(lGlycans, canvas.getBuilderWorkspace(), null);
            }
        });
    }

    private static void addCopyToClipboardMenu(final GlycanCanvasInterface canvas, Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Copy to clipboad");
        Menu menuExport = new Menu(item);
        item.setMenu(menuExport);
        item = new MenuItem(menuExport, 64);
        item.setText("GWS");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlycanCanvasMenu.copySelectionToClipboard(canvas);
                ClipUtils.copyGWSToClipboard();
                MessageBox box = new MessageBox(canvas.getControl().getShell(), 34);
                box.setMessage("GWS sequence is set to clipboad successfuly.");
                box.open();
            }
        });
        item = new MenuItem(menuExport, 64);
        item.setText("GlycoCT");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List lGlycans = GlycanCanvasMenu.getGlycansFromCanvas(canvas);
                List<String> lGlycoCTs = GlycanIOUtils.convertGlycanSecuenceWithCheck(lGlycans, SequenceFormat.GCT_C, false);
                if (lGlycoCTs == null || lGlycoCTs.isEmpty()) {
                    return;
                }
                ClipUtils.copyTextToClipboad(lGlycoCTs.get(0));
                MessageBox box = new MessageBox(canvas.getControl().getShell(), 34);
                box.setMessage("GlycoCT{condensed} sequence of the first strcuture is set to clipboad.");
                box.open();
            }
        });
    }

    private static void copySelectionToClipboard(GlycanCanvasInterface canvas) {
        if (canvas.hasSelection()) {
            canvas.copy();
            return;
        }
        canvas.selectAll();
        canvas.copy();
        canvas.resetSelection();
    }

    private static List<Glycan> getGlycansFromCanvas(GlycanCanvasInterface canvas) {
        if (canvas.hasSelection()) {
            return canvas.getSelectedGlycans();
        }
        return canvas.getAllGlycans();
    }
}

