/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.io;

public enum SequenceFormat {
    GWS("gws", "GWS", "GlycoWorkbench structure format", ";"),
    GCT_C("glycoct_condensed", "GlycoCT{condensed}", "GlycoCT{condensed} format", null),
    WURCS("wurcs", "WURCS", "WURCS format", System.lineSeparator());

    private String m_strID;
    private String m_strName;
    private String m_strDesc;
    private String m_strDelimiter;

    private SequenceFormat(String strID, String strName, String strDesc, String strDelimiter) {
        this.m_strID = strID;
        this.m_strName = strName;
        this.m_strDesc = strDesc;
        this.m_strDelimiter = strDelimiter;
    }

    public String getIdentifier() {
        return this.m_strID;
    }

    public String getName() {
        return this.m_strName;
    }

    public String getDescription() {
        return this.m_strDesc;
    }

    public String getFilterExtention() {
        return "*." + this.m_strID;
    }

    public String getFilterName() {
        return String.valueOf(this.m_strDesc) + " (" + this.getFilterExtention() + ")";
    }

    public String getDelimiter() {
        return this.m_strDelimiter;
    }

    public boolean supportMultipleStructures() {
        return this.m_strDelimiter != null;
    }

    public static SequenceFormat forID(String strID) {
        SequenceFormat[] sequenceFormatArray = SequenceFormat.values();
        int n = sequenceFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceFormat format = sequenceFormatArray[n2];
            if (format.m_strID.equals(strID)) {
                return format;
            }
            ++n2;
        }
        return null;
    }

    public static String[] getNames() {
        String[] strFormats = new String[SequenceFormat.values().length];
        int i = 0;
        SequenceFormat[] sequenceFormatArray = SequenceFormat.values();
        int n = sequenceFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceFormat format = sequenceFormatArray[n2];
            strFormats[i] = format.getName();
            ++i;
            ++n2;
        }
        return strFormats;
    }

    public static String[] getFilterNames() {
        String[] strFormats = new String[SequenceFormat.values().length];
        int i = 0;
        SequenceFormat[] sequenceFormatArray = SequenceFormat.values();
        int n = sequenceFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceFormat format = sequenceFormatArray[n2];
            strFormats[i] = format.getFilterName();
            ++i;
            ++n2;
        }
        return strFormats;
    }

    public static String[] getFilterExtentions() {
        String[] strFormats = new String[SequenceFormat.values().length];
        int i = 0;
        SequenceFormat[] sequenceFormatArray = SequenceFormat.values();
        int n = sequenceFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceFormat format = sequenceFormatArray[n2];
            strFormats[i] = format.getFilterExtention();
            ++i;
            ++n2;
        }
        return strFormats;
    }
}

