/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.typeahead;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class NamespaceHandler {
    static Logger logger = Logger.getLogger(NamespaceHandler.class);
    private String pluginId = "org.grits.toolbox.core";
    private String resourceFolderName = "namespace";
    protected static Map<String, String> namespaceFileMapping = new HashMap<String, String>();
    protected static Map<String, PatriciaTrie<String>> namespaces = new HashMap<String, PatriciaTrie<String>>();
    String namespace;

    public NamespaceHandler(String namespace, String filename) {
        if (!namespaceFileMapping.containsKey(namespace)) {
            namespaceFileMapping.put(namespace, filename);
        }
        this.namespace = namespace;
    }

    public NamespaceHandler(String namespace, String resourceFolderName, String filename) {
        this(namespace, filename);
        if (resourceFolderName != null) {
            this.resourceFolderName = resourceFolderName;
        }
    }

    public NamespaceHandler(String namespace, String resourceFolderName, String filename, String pluginId) {
        this(namespace, resourceFolderName, filename);
        if (pluginId != null) {
            this.pluginId = pluginId;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public URL getNamespaceURL() {
        return Platform.getBundle((String)this.pluginId).getResource(this.resourceFolderName);
    }

    public PatriciaTrie<String> parseNamespaceFile(String filename) {
        PatriciaTrie trie = new PatriciaTrie();
        long startTime = System.currentTimeMillis();
        try {
            String line;
            FileInputStream inputStream = new FileInputStream(filename);
            logger.info((Object)"Reading namespaces from inputstream");
            BufferedReader names = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = names.readLine()) != null) {
                String[] parts = line.split("\\t");
                String synonym = parts[0].trim();
                String name = parts[1].trim();
                trie.put((Object)synonym.toLowerCase(), (Object)name);
            }
            logger.info((Object)"Closing inputstream for namespace file");
            inputStream.close();
            names.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Cannot find the namespace: " + filename), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Cannot read the namespace: " + filename), (Throwable)e);
        }
        catch (Error | Exception e) {
            logger.fatal((Object)("Cannot load the namespace: " + filename + "\n" + e.getMessage()), e);
            throw e;
        }
        logger.info((Object)("NamespaceHandler Took: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds for file: " + filename));
        return trie;
    }

    public PatriciaTrie<String> getTrieForNamespace() {
        final String namespace = this.getNamespace();
        logger.info((Object)("getting trie for namespace : " + namespace));
        if (namespace == null) {
            return null;
        }
        PatriciaTrie<String> trie = namespaces.get(namespace);
        if (trie == null) {
            logger.info((Object)"trie not found in the map. initializing...");
            final GRITSProgressDialog progressDialog = new GRITSProgressDialog(Display.getCurrent().getActiveShell(), 0, false, false);
            progressDialog.open();
            progressDialog.getMajorProgressBarListener().setMaxValue(2);
            progressDialog.setGritsWorker(new GRITSWorker(){

                public int doWork() {
                    CancelableThread t = new CancelableThread(){

                        public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                            String filename;
                            block6: {
                                try {
                                    filename = namespaceFileMapping.get(namespace);
                                    logger.info((Object)("file name for this\"" + namespace + "\" namespace : " + filename));
                                    if (filename != null) break block6;
                                    return false;
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                    return false;
                                }
                            }
                            try {
                                URL resourceFileUrl = FileLocator.toFileURL((URL)NamespaceHandler.this.getNamespaceURL());
                                String namespaceFilePath = String.valueOf(resourceFileUrl.getPath()) + filename;
                                File namespaceFile = new File(namespaceFilePath);
                                if (namespaceFile.exists()) {
                                    logger.info((Object)("Creating trie from namespace file : " + namespaceFile.getName()));
                                    this.updateListeners("Parsing namespace file", 1);
                                    PatriciaTrie<String> trie = NamespaceHandler.this.parseNamespaceFile(namespaceFile.getAbsolutePath());
                                    namespaces.put(namespace, trie);
                                }
                            }
                            catch (IOException e) {
                                logger.error((Object)("Error getting the namespace file : " + filename), (Throwable)e);
                                return false;
                            }
                            return true;
                        }
                    };
                    t.setProgressThreadHandler((IProgressThreadHandler)progressDialog);
                    progressDialog.setThread(t);
                    t.start();
                    while (!t.isCanceled() && !t.isFinished() && t.isAlive()) {
                        Display.getDefault().readAndDispatch();
                    }
                    if (t.isCanceled()) {
                        t.interrupt();
                        return GRITSProcessStatus.CANCEL;
                    }
                    this.updateListeners("Done!", 2);
                    return GRITSProcessStatus.OK;
                }
            });
            progressDialog.startWorker();
        }
        return namespaces.get(namespace);
    }
}

