/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.preference.project.AddEditEventDialog;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.TableColumnComparatorListener;
import org.grits.toolbox.core.utilShare.sort.TableViewerComparator;

public class EventPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(EventPreference.class);
    private MultiChoicePreference<ProjectEvent> eventPreference = null;
    public List<ProjectEvent> defaultEvents = null;
    public List<ProjectEvent> otherEvents = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private Button addButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private AddEditEventDialog dialog = null;

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.ParameterizedPreference.EVENT.getPreferenceName()));
        this.eventPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.EVENT);
        ProjectEvent copiedEvent = null;
        this.defaultEvents = new ArrayList<ProjectEvent>();
        for (ProjectEvent event : this.eventPreference.getSelectedValues()) {
            copiedEvent = event.getACopy();
            copiedEvent.setAddByDefault(true);
            this.defaultEvents.add(copiedEvent);
        }
        this.otherEvents = new ArrayList<ProjectEvent>();
        for (ProjectEvent event : this.eventPreference.getOtherValues()) {
            copiedEvent = event.getACopy();
            copiedEvent.setAddByDefault(false);
            this.otherEvents.add(copiedEvent);
        }
        this.dialog = new AddEditEventDialog(this.getShell());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginBottom = 8;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        this.createTablePart(container);
        this.createButtonPart(container);
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void createTablePart(Composite container) {
        Table eventsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 150;
        tableLayouData.heightHint = 300;
        eventsTable.setLayoutData((Object)tableLayouData);
        this.checkboxTableViewer = new CheckboxTableViewer(eventsTable, "Default");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Event");
        tableColumn2.getColumn().setWidth(300);
        this.checkboxTableViewer.getTable().setHeaderVisible(true);
        this.checkboxTableViewer.getTable().setLinesVisible(true);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (columnIndex == 1 && element instanceof ProjectEvent) {
                    ProjectEvent event = (ProjectEvent)element;
                    value = event.getProjectAction().getAction();
                    value = String.valueOf(value) + (event.getDescription() != null ? " " : event.getDescription());
                }
                return value;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.checkboxTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)EventPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectEvent selectedEvent = (ProjectEvent)selection.getFirstElement();
                    EventPreference.this.dialog.setProjectEvent(selectedEvent.getACopy());
                    if (EventPreference.this.dialog.open() == 0) {
                        ProjectEvent editedEvent = EventPreference.this.dialog.getProjectEvent();
                        List events = (List)EventPreference.this.checkboxTableViewer.getInput();
                        events.set(events.indexOf(selectedEvent), editedEvent);
                        EventPreference.this.checkboxTableViewer.refresh();
                        EventPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)editedEvent));
                    }
                }
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectEvent projectEvent = (ProjectEvent)event.getElement();
                boolean checked = event.getChecked();
                projectEvent.setAddByDefault(checked);
                EventPreference.this.checkboxTableViewer.setChecked(projectEvent, checked);
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ProjectEvent) {
                    return ((ProjectEvent)element).isAddByDefault();
                }
                return false;
            }
        });
        this.addViewerComparator(this.checkboxTableViewer);
    }

    private void initializeTable() {
        ArrayList<ProjectEvent> input = new ArrayList<ProjectEvent>();
        input.addAll(this.otherEvents);
        input.addAll(this.defaultEvents);
        this.checkboxTableViewer.setInput(input);
        this.checkboxTableViewer.refresh();
    }

    private void addViewerComparator(TableViewer tableViewer) {
        tableViewer.setComparator((ViewerComparator)new TableViewerComparator());
        int totalColumns = tableViewer.getTable().getColumns().length;
        int i = 0;
        while (i < totalColumns) {
            tableViewer.getTable().getColumn(i).addSelectionListener((SelectionListener)new TableColumnComparatorListener(tableViewer));
            ++i;
        }
    }

    private void createButtonPart(Composite container) {
        Composite composite = new Composite(container, 4);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginTop = 20;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.addButton = this.createButton(composite, "Add");
        this.editButton = this.createButton(composite, "Edit");
        this.removeButton = this.createButton(composite, "Delete");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List events = (List)EventPreference.this.checkboxTableViewer.getInput();
                EventPreference.this.dialog.setProjectEvent(null);
                if (EventPreference.this.dialog.open() == 0) {
                    ProjectEvent newEvent = EventPreference.this.dialog.getProjectEvent();
                    events.add(newEvent);
                    EventPreference.this.checkboxTableViewer.refresh();
                    EventPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newEvent));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)EventPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectEvent selectedEvent = (ProjectEvent)selection.getFirstElement();
                    EventPreference.this.dialog.setProjectEvent(selectedEvent.getACopy());
                    if (EventPreference.this.dialog.open() == 0) {
                        ProjectEvent editedEvent = EventPreference.this.dialog.getProjectEvent();
                        List events = (List)EventPreference.this.checkboxTableViewer.getInput();
                        events.set(events.indexOf(selectedEvent), editedEvent);
                        EventPreference.this.checkboxTableViewer.refresh();
                        EventPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)editedEvent));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List events = (List)EventPreference.this.checkboxTableViewer.getInput();
                StructuredSelection selection = (StructuredSelection)EventPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectEvent selectedEvent = (ProjectEvent)selection.getFirstElement();
                    int selectionIndex = EventPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    events.remove(selectedEvent);
                    EventPreference.this.checkboxTableViewer.refresh();
                    selectionIndex = Math.max(selectionIndex - 1, 0);
                    EventPreference.this.checkboxTableViewer.getTable().select(selectionIndex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Button createButton(Composite composite, String buttonLabel) {
        Button button = new Button(composite, 0);
        button.setText(buttonLabel);
        GridData addButtonData = new GridData(0x1000008, 1, true, true, 1, 1);
        addButtonData.widthHint = 80;
        button.setLayoutData((Object)addButtonData);
        GridData compositeLayoutData = new GridData(0x1000008, 1, true, true);
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        return button;
    }

    protected void performDefaults() {
        this.defaultEvents = new ArrayList<ProjectEvent>();
        this.otherEvents = new ArrayList<ProjectEvent>();
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Event\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        List tableInput = (List)this.checkboxTableViewer.getInput();
        ArrayList<ProjectEvent> events = new ArrayList<ProjectEvent>();
        for (ProjectEvent projectEvent : tableInput) {
            if (!this.isUnique(events, projectEvent)) {
                errorMessage = "Similar Events : " + projectEvent.getProjectAction().getAction();
                break;
            }
            events.add(projectEvent);
        }
        return errorMessage;
    }

    private boolean isUnique(List<ProjectEvent> events, ProjectEvent projectEvent) {
        boolean unique = true;
        for (ProjectEvent thisProjectEvent : events) {
            if (!thisProjectEvent.matches(projectEvent)) continue;
            unique = false;
            break;
        }
        return unique;
    }

    private boolean save() {
        List tableInput = (List)this.checkboxTableViewer.getInput();
        this.defaultEvents = new ArrayList<ProjectEvent>();
        this.otherEvents = new ArrayList<ProjectEvent>();
        for (ProjectEvent projectEvent : tableInput) {
            if (this.checkboxTableViewer.getChecked(projectEvent)) {
                this.defaultEvents.add(projectEvent);
                continue;
            }
            this.otherEvents.add(projectEvent);
        }
        this.eventPreference.setSelectedValues(this.defaultEvents);
        this.eventPreference.setOtherValues(this.otherEvents);
        return this.eventPreference.savePreference();
    }
}

