/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog.setTemplate;

import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.sample.config.Config;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;

public class TemplateMembersLabelProvider
implements ITableLabelProvider,
ITableFontProvider,
ITableColorProvider {
    private Font boldFont = null;
    private HashMap<String, HashMap<Integer, Integer>> originalObjectColumnTickedMap = null;
    private HashMap<String, HashMap<Integer, Integer>> objectColumnTickedMap = null;
    private Image tickedIcon = ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.CHECKBOX_TICKED_ICON).createImage();
    private Image optionalTickedIcon = ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.CHECKBOX_OPTIONAL_TICKED_ICON).createImage();
    private Image addIcon = ImageShare.ADD_ICON.createImage();
    private HashMap<Integer, String> columnNoCategoryURIMap = null;
    private boolean editable;

    public void setColumnNoCategoryURIMap(HashMap<Integer, String> columnNoCategoryURIMap) {
        this.columnNoCategoryURIMap = columnNoCategoryURIMap;
    }

    public TemplateMembersLabelProvider(HashMap<String, HashMap<Integer, Integer>> objectColumnTickedMap) {
        this.setOriginalObjectColumnTickedMap(objectColumnTickedMap);
        this.setObjectColumnTickedMap(objectColumnTickedMap);
    }

    public void setOriginalObjectColumnTickedMap(HashMap<String, HashMap<Integer, Integer>> originalObjectColumnTickedMap) {
        this.originalObjectColumnTickedMap = originalObjectColumnTickedMap;
    }

    public HashMap<String, HashMap<Integer, Integer>> getOriginalObjectColumnTickedMap() {
        return this.originalObjectColumnTickedMap;
    }

    public HashMap<String, HashMap<Integer, Integer>> getObjectColumnTickedMap() {
        return this.objectColumnTickedMap;
    }

    public void setObjectColumnTickedMap(HashMap<String, HashMap<Integer, Integer>> objectColumnTickedMap) {
        this.objectColumnTickedMap = objectColumnTickedMap;
    }

    public Image getTickedIcon() {
        return this.tickedIcon;
    }

    public Image getOptionalTickedIcon() {
        return this.optionalTickedIcon;
    }

    public Image getAddIcon() {
        return this.addIcon;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Font getFont(Object element, int columnIndex) {
        Font font = null;
        if (columnIndex == 0 && element instanceof DescriptorGroup) {
            if (this.boldFont == null) {
                Font currentFont = Display.getCurrent().getSystemFont();
                FontData fontData = currentFont.getFontData()[0];
                this.boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
            }
            font = this.boldFont;
        }
        return font;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex > 1 && (element instanceof Descriptor || element instanceof DescriptorGroup)) {
            if (this.objectColumnTickedMap.get(element.toString()) != null) {
                Integer imageType = this.objectColumnTickedMap.get(element.toString()).get(columnIndex);
                switch (imageType) {
                    case -1: {
                        return null;
                    }
                    case 0: {
                        return this.addIcon;
                    }
                    case 1: {
                        return this.optionalTickedIcon;
                    }
                    case 2: {
                        return this.tickedIcon;
                    }
                }
            }
            return this.addIcon;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (element instanceof DescriptorGroup) {
                    return ((DescriptorGroup)element).getLabel();
                }
                if (element instanceof Descriptor) {
                    return ((Descriptor)element).getLabel();
                }
            }
            case 1: {
                if (element instanceof DescriptorGroup) {
                    Integer maxOccurrence = ((DescriptorGroup)element).getMaxOccurrence() == null ? 0 : ((DescriptorGroup)element).getMaxOccurrence();
                    return "" + maxOccurrence;
                }
                if (!(element instanceof Descriptor)) break;
                Integer maxOccurrence = ((Descriptor)element).getMaxOccurrence() == null ? 0 : ((Descriptor)element).getMaxOccurrence();
                return "" + maxOccurrence;
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (this.objectColumnTickedMap.get(element.toString()) == null || this.objectColumnTickedMap.get(element.toString()).isEmpty() || !this.objectColumnTickedMap.containsKey(element.toString())) {
            return Config.HIGHLIGHT_COLOR_ERROR;
        }
        HashMap<Integer, Integer> map = this.objectColumnTickedMap.get(element.toString());
        boolean atleastOne = false;
        for (Integer column : this.columnNoCategoryURIMap.keySet()) {
            if (map.get(column) <= 0) continue;
            atleastOne = true;
            break;
        }
        if (!atleastOne) {
            return Config.HIGHLIGHT_COLOR_ERROR;
        }
        return null;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean getEditable() {
        return this.editable;
    }
}

