/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.process;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.ms.annotation.gelato.AnalyteStructureAnnotation;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressHandler;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class GelatoWorker
extends GRITSWorker {
    private static final Logger logger = Logger.getLogger(GelatoWorker.class);
    protected AnalyteStructureAnnotation gsa = null;
    protected IProgressThreadHandler progressThreadHandler;
    protected IProgressHandler progressHandler;

    public GelatoWorker() {
    }

    public GelatoWorker(AnalyteStructureAnnotation gsa, IProgressHandler progressHandler, IProgressThreadHandler progressThreadHandler, List<IProgressListener> progressMajors, List<IProgressListener> progressStructureAnnotationMinors, List<IProgressListener> progressGlycanMatcherMinors) {
        this.gsa = gsa;
        this.progressThreadHandler = progressThreadHandler;
        this.setProgressListeners(progressMajors);
        this.progressHandler = progressHandler;
        gsa.setProgressListeners(progressStructureAnnotationMinors);
        gsa.setMatcherProgressListener(progressGlycanMatcherMinors);
    }

    public int doWork() {
        try {
            this.setMaxValue(3);
            this.updateListeners("Initializing...", 0);
            CancelableThread s1 = this.getInitializeProcess();
            int iRes = this.runProcess(s1);
            if (s1.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            if (iRes != GRITSProcessStatus.OK) {
                return iRes;
            }
            this.updateListeners("Populating glycan database...", 1);
            CancelableThread s2 = this.getPopulateGlycanObjectsProcess();
            this.runProcess(s2);
            if (s2.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            if (iRes != GRITSProcessStatus.OK) {
                return iRes;
            }
            this.updateListeners("Applying database filters...", 1);
            CancelableThread s3 = this.getApplyFiltersProcess();
            this.runProcess(s3);
            if (s3.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            if (iRes != GRITSProcessStatus.OK) {
                return iRes;
            }
            this.updateListeners("Performing glycan annotation...", 2);
            CancelableThread s4 = this.getProcessScansProcess();
            iRes = this.runProcess(s4);
            if (s4.isCanceled()) {
                return GRITSProcessStatus.CANCEL;
            }
            this.updateListeners("Done!", 3);
            return iRes;
        }
        catch (Exception e) {
            logger.error((Object)"Error in annotateGlycanStructure", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected int runProcess(CancelableThread cp) {
        try {
            cp.setProgressThreadHandler(this.progressThreadHandler);
            this.progressHandler.setThread(cp);
            cp.start();
            while (!cp.isCanceled() && !cp.isFinished() && cp.isAlive()) {
                if (Display.getDefault().readAndDispatch()) continue;
            }
            if (cp.isCanceled()) {
                this.gsa.setCanceled(true);
                cp.interrupt();
                return GRITSProcessStatus.CANCEL;
            }
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in runProcess", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected CancelableThread getInitializeProcess() {
        try {
            CancelableThread cp = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    logger.debug((Object)"Starting job: getInitializeProcess");
                    try {
                        GelatoWorker.this.gsa.initialize();
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            return cp;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getScanBoundsProcess", (Throwable)ex);
            return null;
        }
    }

    protected CancelableThread getPopulateGlycanObjectsProcess() {
        try {
            CancelableThread cp = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    logger.debug((Object)"Starting job: getPopulateGlycanObjectsProcess");
                    try {
                        GelatoWorker.this.gsa.populateGelatoAnalyteObjects();
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            return cp;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getPopulateGlycanObjectsProcess", (Throwable)ex);
            return null;
        }
    }

    protected CancelableThread getApplyFiltersProcess() {
        try {
            CancelableThread cp = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    logger.debug((Object)"Starting job: getApplyFiltersProcess");
                    try {
                        GelatoWorker.this.gsa.applyFilters();
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            return cp;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getApplyFiltersProcess", (Throwable)ex);
            return null;
        }
    }

    protected CancelableThread getProcessScansProcess() {
        try {
            CancelableThread cp = new CancelableThread(){

                public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                    logger.debug((Object)"Starting job: processScans");
                    try {
                        int iRes = GelatoWorker.this.gsa.processScans();
                        if (iRes == GRITSProcessStatus.ERROR) {
                            logger.info((Object)"An error has occurred during processing scans");
                        }
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
            return cp;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in getProcessScansProcess", (Throwable)ex);
            return null;
        }
    }
}

