/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato.glycan;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanMatcherTIM;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class GlycanStructureAnnotationTIM
extends GlycanStructureAnnotation {
    private static final Logger logger = Logger.getLogger(GlycanStructureAnnotationTIM.class);

    public GlycanStructureAnnotationTIM(Data data, String path, String archiveName, MSFile msFile) {
        super(data, path, archiveName, msFile);
    }

    @Override
    protected HashMap<Integer, Scan> getScans(MSFile msFile, int _iScanNumber, double dFragCutoff, String sFragCutoffType, double dPreCutoff, String sPreCutoffType) {
        if (msFile.getReader() instanceof IMSAnnotationFileReader) {
            List scans = ((IMSAnnotationFileReader)msFile.getReader()).readMSFile(msFile);
            return GelatoUtils.listToHashMap(scans, dFragCutoff, sFragCutoffType, dPreCutoff, sPreCutoffType);
        }
        return null;
    }

    @Override
    public List<Integer> determineScanBounds() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(0);
        return l;
    }

    @Override
    public String getFinalArchiveName() {
        return this.m_finalArchive;
    }

    @Override
    public boolean needsOverview() {
        return false;
    }

    @Override
    public String getOverviewFileName() {
        return null;
    }

    @Override
    protected AnalyteMatcher getNewAnalyteMatcher(int iCurScan) {
        return new GlycanMatcherTIM(iCurScan, this);
    }

    @Override
    protected void cleanAfterCancel() {
        try {
            File file = new File(this.getFinalArchiveName());
            file.delete();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setArchiveFilePaths() {
        this.m_finalArchive = AnnotationWriter.getArchiveFilePath((String)this.m_preArchive);
    }
}

