/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONLinkageParser;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.json.JSONObject;

public class GCJSONRepeatParser {
    private GCJSONLinkageParser gclinParser;
    private GlyContainer glyCo;
    private Node current;
    private Node parent;

    public GCJSONRepeatParser(GlyContainer _glyCo, Node _current, Node _parent) {
        this.glyCo = _glyCo;
        this.current = _current;
        this.parent = _parent;
        this.gclinParser = new GCJSONLinkageParser();
    }

    public GlyContainer makeRepeatingEdge(Object _repeat) throws GlycanException {
        Edge edge = new Edge();
        Linkage lin = this.gclinParser.parsePosition((JSONObject)_repeat);
        edge.addGlycosidicLinkage(lin);
        Substituent repMod = this.parseRepeat((JSONObject)_repeat);
        edge.setSubstituent(repMod);
        repMod.addParentEdge(edge);
        this.glyCo.addEdge(this.parent, this.current, edge);
        return this.glyCo;
    }

    public Substituent parseRepeatingBridge(JSONObject _rep) throws GlycanException {
        Linkage lin1 = null;
        Linkage lin2 = null;
        CrossLinkedTemplate subInter = null;
        SubstituentUtility subUtil = new SubstituentUtility();
        Iterator iterator = _rep.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "PositionOne": {
                    lin1 = this.gclinParser.parsePosition(_rep.getJSONObject(key));
                    break;
                }
                case "PositionTwo": {
                    lin2 = this.gclinParser.parsePosition(_rep.getJSONObject(key));
                    break;
                }
                case "Notation": {
                    subInter = this.parseCrossLinkedTemplate(_rep.getString(key));
                }
            }
        }
        if (lin1 == null) {
            lin1 = new Linkage();
        }
        if (lin2 == null) {
            lin2 = new Linkage();
        }
        GlycanRepeatModification ret = new GlycanRepeatModification(subInter);
        ret.setFirstPosition(lin1);
        ret.setSecondPosition(lin2);
        return ret;
    }

    public Substituent parseRepeat(JSONObject _rep) throws GlycanException {
        int max = -1;
        int min = -1;
        GlycanRepeatModification retMod = null;
        Iterator iterator = _rep.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Max": {
                    max = _rep.getInt(key);
                    break;
                }
                case "Min": {
                    min = _rep.getInt(key);
                    break;
                }
                case "Bridge": {
                    retMod = (GlycanRepeatModification)this.parseRepeatingBridge(_rep.getJSONObject(key));
                }
            }
        }
        retMod.setMinRepeatCount(min);
        retMod.setMaxRepeatCount(max);
        return retMod;
    }

    public CrossLinkedTemplate parseCrossLinkedTemplate(String _notation) {
        CrossLinkedTemplate[] crossLinkedTemplateArray = CrossLinkedTemplate.values();
        int n = crossLinkedTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            CrossLinkedTemplate value = crossLinkedTemplateArray[n2];
            if (_notation.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

