/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Aglycone;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseTypeDictionary;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.util.MonosaccharideUtility;
import org.glycoinfo.GlycanFormatconverter.util.similarity.NodeSimilarity;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.json.JSONArray;
import org.json.JSONObject;

public class GCJSONExporter {
    private TreeMap<Integer, Node> nodeIndex;

    public String start(GlyContainer _glyco, boolean _isVisualize) throws GlycanException, ConverterExchangeException {
        this.nodeIndex = this.makeTreeMap(_glyco);
        MonosaccharideUtility monoUtil = new MonosaccharideUtility();
        JSONObject monosaccharides = new JSONObject();
        JSONObject bridges = new JSONObject();
        JSONObject repeat = new JSONObject();
        JSONObject edge = new JSONObject();
        for (Integer key : this.nodeIndex.keySet()) {
            Monosaccharide mono = (Monosaccharide)this.nodeIndex.get(key);
            JSONObject monosaccharide = new JSONObject();
            monosaccharide.accumulate("AnomState", (Object)Character.valueOf(mono.getAnomer().getAnomericState()));
            monosaccharide.accumulate("AnomPosition", (Object)mono.getAnomericPosition());
            monosaccharide.accumulate("TrivialName", this.extractTrivialName(mono.getStereos()));
            monosaccharide.accumulate("Configuration", this.extractConfiguration(mono.getStereos()));
            monosaccharide.accumulate("SuperClass", (Object)mono.getSuperClass());
            monosaccharide.accumulate("RingSize", (Object)this.makeRingSymbol(mono));
            if (_isVisualize) {
                String trivialName = this.makeTrivialNotation(mono);
                monosaccharide.accumulate("Notation", (Object)trivialName);
                monoUtil.modifiedSubstituents(trivialName, mono);
            }
            monosaccharide.put("Modifications", (Object)this.extractModifications(mono));
            monosaccharide.put("Substituents", (Object)this.extractSubstituents(mono));
            for (Object obj : this.extractEdge(mono)) {
                edge.accumulate("e" + edge.length(), obj);
            }
            for (Object obj : this.extractRepeat(mono)) {
                repeat.accumulate("r" + repeat.length(), obj);
            }
            JSONObject bridge = this.extractBridge(mono, false);
            if (bridge.length() != 0) {
                bridges.accumulate("b" + bridges.keySet().size(), (Object)bridge);
            }
            monosaccharides.accumulate("m" + String.valueOf(key), (Object)monosaccharide);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Monosaccharides", (Object)monosaccharides);
        jsonObject.put("Edges", (Object)edge);
        jsonObject.put("Bridge", (Object)bridges);
        jsonObject.put("Composition", (Object)this.extractComposition(_glyco, monosaccharides));
        jsonObject.put("Repeat", (Object)repeat);
        jsonObject.accumulate("Fragments", (Object)this.extractFragment(_glyco));
        jsonObject.put("Aglycone", (Object)this.extractAglycone(_glyco.getAglycone()));
        jsonObject.put("WURCS", (Object)"");
        jsonObject.put("AN", (Object)"");
        return jsonObject.toString();
    }

    private JSONArray extractRepeat(Monosaccharide _mono) {
        JSONArray ret = new JSONArray();
        BidiMap flip = this.makeFlipMap();
        for (Edge parent : _mono.getParentEdges()) {
            Substituent sub = (Substituent)parent.getSubstituent();
            if (sub == null || !(sub instanceof GlycanRepeatModification)) continue;
            GlycanRepeatModification repMod = (GlycanRepeatModification)sub;
            JSONObject repUnit = new JSONObject();
            for (Linkage lin : parent.getGlycosidicLinkages()) {
                repUnit = this.extractLinkage(lin, false);
            }
            repUnit.accumulate("Min", (Object)repMod.getMinRepeatCount());
            repUnit.accumulate("Max", (Object)repMod.getMaxRepeatCount());
            repUnit.accumulate("Bridge", (Object)this.extractBridge(_mono, true));
            repUnit.accumulate("Start", (Object)("m" + flip.get((Object)parent.getChild())));
            repUnit.accumulate("End", (Object)("m" + flip.get((Object)parent.getParent())));
            ret.put((Object)repUnit);
        }
        return ret;
    }

    private JSONObject extractFragment(GlyContainer _glyCo) throws GlycanException {
        JSONObject ret = new JSONObject();
        BidiMap flip = this.makeFlipMap();
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            if (und.isComposition()) continue;
            JSONObject unit = new JSONObject();
            Node root = und.getRootNodes().get(0);
            JSONArray acceptors = new JSONArray();
            for (Node acceptor : und.getParents()) {
                if (flip.get((Object)acceptor) == null) continue;
                acceptors.put((Object)("m" + flip.get((Object)acceptor)));
            }
            unit.put("Acceptor", (Object)acceptors);
            JSONObject pos = new JSONObject();
            if (!und.isComposition()) {
                for (Linkage linkage : und.getConnection().getGlycosidicLinkages()) {
                    pos = this.extractLinkage(linkage, false);
                }
            }
            unit.accumulate("Edge", (Object)pos);
            if (root instanceof Substituent) {
                unit.accumulate("Donor", (Object)((Substituent)root).getNameWithIUPAC());
            } else {
                unit.accumulate("Donor", (Object)("m" + flip.get((Object)root)));
            }
            ret.accumulate("f" + _glyCo.getUndefinedUnit().indexOf(und), (Object)unit);
        }
        return ret;
    }

    private JSONArray extractSubstituents(Monosaccharide _mono) {
        JSONArray ret = new JSONArray();
        for (Edge childEdge : _mono.getChildEdges()) {
            Substituent sub = (Substituent)childEdge.getSubstituent();
            if (sub == null || sub instanceof GlycanRepeatModification || sub.getSubstituent() instanceof CrossLinkedTemplate && childEdge.getChild() != null) continue;
            JSONObject unit = new JSONObject();
            unit = this.extractLinkage(sub.getFirstPosition(), false);
            unit.accumulate("Notation", (Object)sub.getSubstituent().getIUPACnotation());
            if (sub.getSecondPosition() != null && !sub.getSecondPosition().getParentLinkages().isEmpty()) {
                unit.accumulate("Status", (Object)"simple");
            }
            if (sub.getSecondPosition() == null) {
                if (sub.getFirstPosition().getParentLinkages().size() > 1) {
                    unit.accumulate("Status", (Object)"fuzzy");
                } else {
                    unit.accumulate("Status", (Object)"simple");
                }
            }
            ret.put((Object)unit);
        }
        return ret;
    }

    private JSONObject extractProbability(Linkage _lin, boolean _isDonor) {
        JSONObject prob = new JSONObject();
        if (_isDonor) {
            prob.accumulate("Low", (Object)_lin.getParentProbabilityLower());
            prob.accumulate("High", (Object)_lin.getParentProbabilityUpper());
        }
        if (!_isDonor) {
            prob.accumulate("Low", (Object)_lin.getParentProbabilityLower());
            prob.accumulate("High", (Object)_lin.getParentProbabilityUpper());
        }
        return prob;
    }

    private JSONObject extractLinkage(Linkage _lin, boolean _isDonor) {
        JSONObject ret = new JSONObject();
        if (_lin == null) {
            return ret;
        }
        JSONObject pos = new JSONObject();
        pos.accumulate("Acceptor", _lin.getParentLinkages());
        pos.accumulate("Donor", _lin.getChildLinkages());
        ret.accumulate("Probability", (Object)this.extractProbability(_lin, _isDonor));
        JSONObject type = new JSONObject();
        type.accumulate("Acceptor", (Object)_lin.getParentLinkageType());
        type.accumulate("Donor", (Object)_lin.getChildLinkageType());
        ret.accumulate("Position", (Object)pos);
        ret.accumulate("LinkageType", (Object)type);
        return ret;
    }

    private JSONArray extractEdge(Monosaccharide _mono) {
        JSONArray ret = new JSONArray();
        BidiMap flip = this.makeFlipMap();
        for (Edge acceptor : _mono.getParentEdges()) {
            Substituent sub = (Substituent)acceptor.getSubstituent();
            if (sub != null && sub instanceof GlycanRepeatModification || acceptor.getParent() == null) continue;
            JSONObject edge = new JSONObject();
            for (Linkage lin : acceptor.getGlycosidicLinkages()) {
                edge = this.extractLinkage(lin, false);
            }
            edge.accumulate("Donor", (Object)("m" + flip.get((Object)acceptor.getChild())));
            edge.accumulate("Acceptor", (Object)("m" + flip.get((Object)acceptor.getParent())));
            ret.put((Object)edge);
        }
        return ret;
    }

    private JSONObject extractBridge(Node _node, boolean _isRepeat) {
        JSONObject unit = new JSONObject();
        BidiMap flip = this.makeFlipMap();
        for (Edge parentEdge : _node.getParentEdges()) {
            Substituent sub = (Substituent)parentEdge.getSubstituent();
            if (sub == null || !(sub.getSubstituent() instanceof CrossLinkedTemplate) || sub instanceof GlycanRepeatModification && !_isRepeat) continue;
            unit.accumulate("Notation", (Object)sub.getNameWithIUPAC());
            unit.accumulate("Acceptor", (Object)("m" + flip.get((Object)_node.getParentNode())));
            unit.accumulate("Donor", (Object)("m" + flip.get((Object)_node)));
            JSONObject pos = new JSONObject();
            if (this.haveSubstituentDirection(sub)) {
                pos.accumulate("Donor", (Object)sub.getFirstPosition().getChildLinkages().get(0));
                pos.accumulate("Acceptor", (Object)sub.getSecondPosition().getChildLinkages().get(0));
                unit.accumulate("Pos", (Object)pos);
            }
            if (sub.getFirstPosition() == null || sub.getSecondPosition() == null) continue;
            JSONObject linType = new JSONObject();
            linType.accumulate("Acceptor", (Object)sub.getFirstPosition().getParentLinkageType());
            linType.accumulate("Donor", (Object)sub.getSecondPosition().getChildLinkageType());
            unit.accumulate("LinkageType", (Object)linType);
        }
        return unit;
    }

    private TreeMap<Integer, Node> makeTreeMap(GlyContainer _glyco) throws GlycanException {
        TreeMap<Integer, Node> ret = new TreeMap<Integer, Node>();
        NodeSimilarity nodeSim = new NodeSimilarity();
        ArrayList<Object> sorted = new ArrayList();
        if (_glyco.getAllNodes().size() == _glyco.getUndefinedUnit().size()) {
            for (GlycanUndefinedUnit glycanUndefinedUnit : _glyco.getUndefinedUnit()) {
                sorted.addAll(glycanUndefinedUnit.getNodes());
            }
        } else {
            sorted = nodeSim.sortAllNode(_glyco.getRootNodes().get(0));
            for (GlycanUndefinedUnit glycanUndefinedUnit : _glyco.getUndefinedUnit()) {
                Node fragRoot = glycanUndefinedUnit.getRootNodes().get(0);
                if (fragRoot instanceof Substituent) continue;
                sorted.addAll(nodeSim.sortAllNode(fragRoot));
            }
        }
        for (Node node : sorted) {
            ret.put(sorted.indexOf(node), node);
        }
        return ret;
    }

    private ArrayList<String> extractTrivialName(LinkedList<String> _stereo) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String unit : _stereo) {
            unit = unit.indexOf("-") != -1 ? unit.substring(unit.indexOf("-") + 1, unit.length()) : unit;
            BaseTypeDictionary baseType = BaseTypeDictionary.forName(unit);
            String name = baseType.getCoreName();
            ret.add(name);
        }
        return ret;
    }

    private String makeTrivialNotation(Node _node) throws ConverterExchangeException, GlycanException {
        IUPACNotationConverter iupacConv = new IUPACNotationConverter();
        iupacConv.makeTrivialName(_node);
        String ret = iupacConv.getCoreCode();
        return ret;
    }

    private ArrayList<String> extractConfiguration(LinkedList<String> _stereo) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String unit : _stereo) {
            unit = unit.indexOf("-") != -1 ? unit.substring(unit.indexOf("-") + 1, unit.length()) : unit;
            BaseTypeDictionary baseType = BaseTypeDictionary.forName(unit);
            String name = baseType.getConfiguration();
            ret.add(name);
        }
        return ret;
    }

    private String makeRingSymbol(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        int ringStart = mono.getRingStart();
        int ringEnd = mono.getRingEnd();
        if (ringStart == -1 && ringEnd == -1) {
            return "";
        }
        if (ringStart == 1) {
            if (ringEnd == 4) {
                return "f";
            }
            if (ringEnd == 5) {
                return "p";
            }
        }
        if (ringStart == 2) {
            if (ringEnd == 5) {
                return "f";
            }
            if (ringEnd == 6) {
                return "p";
            }
        }
        return "";
    }

    private boolean haveSubstituentDirection(Node _node) {
        if (!(_node instanceof Substituent)) {
            return false;
        }
        Substituent sub = (Substituent)_node;
        if (sub.getFirstPosition() == null || sub.getSecondPosition() == null) {
            return false;
        }
        return !sub.getFirstPosition().getChildLinkages().isEmpty() && !sub.getSecondPosition().getChildLinkages().isEmpty();
    }

    private BidiMap makeFlipMap() {
        DualHashBidiMap bidi = new DualHashBidiMap(this.nodeIndex);
        BidiMap flip = bidi.inverseBidiMap();
        return flip;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JSONArray extractModifications(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        JSONArray ret = new JSONArray();
        boolean isUnsaturate = false;
        JSONArray pos = null;
        for (GlyCoModification gMod : mono.getModifications()) {
            JSONObject modUnit;
            block5: {
                if (mono.getSuperClass().getSize() == gMod.getPositionOne().intValue() && gMod.getModificationTemplate().equals((Object)ModificationTemplate.HYDROXYL)) continue;
                modUnit = new JSONObject();
                if (this.isUnsaturation(gMod)) {
                    if (isUnsaturate) {
                        pos.put((Object)gMod.getPositionOne());
                        isUnsaturate = false;
                        break block5;
                    } else {
                        pos = new JSONArray();
                        pos.put((Object)gMod.getPositionOne());
                        isUnsaturate = true;
                        continue;
                    }
                }
                pos = new JSONArray();
                pos.put((Object)gMod.getPositionOne());
            }
            if (pos != null) {
                modUnit.put("Position", (Object)pos);
            }
            modUnit.accumulate("Notation", (Object)gMod.getModificationTemplate().getIUPACnotation());
            ret.put((Object)modUnit);
        }
        return ret;
    }

    private JSONObject extractComposition(GlyContainer _glyCo, JSONObject _monoObj) throws GlycanException {
        JSONObject ret = new JSONObject();
        if (!_glyCo.isComposition()) {
            return ret;
        }
        LinkedHashMap count = new LinkedHashMap();
        for (Integer n : this.nodeIndex.keySet()) {
            String jsonKey = "m" + String.valueOf(n);
            String json = _monoObj.get(jsonKey).toString();
            if (!count.containsKey(json.toString())) {
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(jsonKey);
                count.put(json.toString(), tmp);
                continue;
            }
            ((ArrayList)count.get(json.toString())).add(jsonKey);
        }
        for (String string : count.keySet()) {
            JSONObject unit = new JSONObject();
            unit.put("Monosaccharide", ((ArrayList)count.get(string)).get(0));
            unit.put("Count", ((ArrayList)count.get(string)).size());
            ret.accumulate("c" + ret.length(), (Object)unit);
        }
        return ret;
    }

    private String extractAglycone(Node _node) {
        if (_node == null) {
            return "";
        }
        if (_node instanceof Aglycone) {
            return "";
        }
        Aglycone agly = (Aglycone)_node;
        return agly.getName();
    }

    private boolean isUnsaturation(GlyCoModification _gMod) {
        return _gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_EL) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_EU) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_FL) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_FU) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_ZL) || _gMod.getModificationTemplate().equals((Object)ModificationTemplate.UNSATURATION_ZU);
    }
}

