/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

public class TopHatFilter {
    public static void filter(double[][] data, double struc_elem_size) {
        if (data == null || data[0].length < 2) {
            return;
        }
        int no_points = data[0].length;
        double first_mz = data[0][0];
        double last_mz = data[0][no_points - 1];
        double spacing = (last_mz - first_mz) / (double)no_points;
        int struc_elem_no_points = (int)Math.ceil(struc_elem_size / spacing);
        struc_elem_no_points += (struc_elem_no_points + 1) % 2;
        double[][] erosion_results = TopHatFilter.erosion(data, struc_elem_no_points);
        double[][] dilation_results = TopHatFilter.dilatation(erosion_results, struc_elem_no_points);
        for (int i = 0; i < no_points; ++i) {
            double[] dArray = data[1];
            int n = i;
            dArray[n] = dArray[n] - dilation_results[1][i];
        }
    }

    private static double[][] dilatation(double[][] data, int l) {
        int first = 0;
        int last = data[0].length;
        int length = data[0].length;
        int middle = l / 2;
        double[][] results = new double[][]{new double[length], new double[length]};
        double[] g = new double[l];
        double[] h = new double[l];
        int k = length - length % l - 1;
        TopHatFilter.calcGDilatation(data, first, last, l, g, true);
        TopHatFilter.calcHDilatation(data, first, l - 1, l, h, true);
        int it = 0;
        int i = 0;
        while (i < middle) {
            results[0][it] = data[0][first];
            results[1][it] = g[i + middle];
            ++i;
            ++it;
            ++first;
        }
        int m = l - 1;
        int n = 0;
        i = middle;
        while (i < length - middle) {
            if (i % l == middle + 1) {
                if (i == k) {
                    TopHatFilter.calcGDilatation(data, first + middle, last, l, g, false);
                } else {
                    TopHatFilter.calcGDilatation(data, first + middle, last, l, g, true);
                }
                m = 0;
            }
            if (i % l == middle && i > middle) {
                if (i > k) {
                    TopHatFilter.calcHDilatation(data, first, last, l, h, false);
                } else {
                    TopHatFilter.calcHDilatation(data, first - middle, first + middle, l, h, true);
                }
                n = 0;
            }
            results[0][it] = data[0][first];
            results[1][it] = Math.max(g[m], h[n]);
            ++i;
            ++it;
            ++first;
            ++m;
            ++n;
        }
        double last_int = data[1][first - 1];
        i = 0;
        while (i < middle) {
            results[0][it] = data[0][first];
            results[1][it] = last_int;
            ++i;
            ++it;
            ++first;
        }
        return results;
    }

    private static double[][] erosion(double[][] data, int l) {
        int first = 0;
        int last = data[0].length;
        int length = data[0].length;
        int middle = l / 2;
        double[][] results = new double[][]{new double[length], new double[length]};
        double[] g = new double[l];
        double[] h = new double[l];
        int k = length - length % l - 1;
        TopHatFilter.calcGErosion(data, first, last, l, g, true);
        TopHatFilter.calcHErosion(data, first + l - 1, l, h, true);
        int it = 0;
        int i = 0;
        while (i < middle) {
            results[0][it] = data[0][first];
            results[1][it] = 0.0;
            ++i;
            ++it;
            ++first;
        }
        int m = l - 1;
        int n = 0;
        i = middle;
        while (i < length - middle) {
            if (i % l == middle + 1) {
                if (i == k) {
                    TopHatFilter.calcGErosion(data, first + middle, last, l, g, false);
                } else {
                    TopHatFilter.calcGErosion(data, first + middle, last, l, g, true);
                }
                m = 0;
            }
            if (i % l == middle && i > middle) {
                if (i > k) {
                    TopHatFilter.calcHErosion(data, first + middle, l, h, false);
                } else {
                    TopHatFilter.calcHErosion(data, first + middle, l, h, true);
                }
                n = 0;
            }
            results[0][it] = data[0][first];
            results[1][it] = Math.min(g[m], h[n]);
            ++i;
            ++it;
            ++first;
            ++m;
            ++n;
        }
        i = 0;
        while (i < middle) {
            results[0][it] = data[0][first];
            results[1][it] = 0.0;
            ++i;
            ++it;
            ++first;
        }
        return results;
    }

    private static void calcGErosion(double[][] data, int first, int last, int l, double[] g, boolean b) {
        if (b) {
            for (int j = 0; j < l && first < last; ++first, ++j) {
                g[j] = j == 0 ? data[1][first] : Math.min(data[1][first], g[j - 1]);
            }
        } else {
            int j = 0;
            while (first != last) {
                g[j] = j == 0 ? data[1][first] : Math.min(data[1][first], g[j - 1]);
                ++first;
                ++j;
            }
            for (int i = j; i < l; ++i) {
                g[i] = 0.0;
            }
        }
    }

    private static void calcHErosion(double[][] data, int first, int l, double[] h, boolean b) {
        if (b) {
            for (int j = l - 1; j >= 0; --j) {
                h[j] = j == l - 1 ? data[1][first] : Math.min(data[1][first], h[j + 1]);
                --first;
            }
        } else {
            for (int j = 0; j < l; ++j) {
                h[j] = 0.0;
            }
        }
    }

    private static void calcGDilatation(double[][] data, int first, int last, int l, double[] g, boolean b) {
        if (b) {
            for (int j = 0; j < l && first < last; ++first, ++j) {
                g[j] = j == 0 ? data[1][first] : Math.max(data[1][first], g[j - 1]);
            }
        } else {
            int j = 0;
            while (first != last) {
                g[j] = j == 0 ? data[1][first] : Math.max(data[1][first], g[j - 1]);
                ++first;
                ++j;
            }
            for (int i = j; i < l; ++i) {
                g[i] = g[j - 1];
            }
        }
    }

    private static void calcHDilatation(double[][] data, int first, int last, int l, double[] h, boolean b) {
        if (b) {
            for (int j = l - 1; j >= 0; --j) {
                h[j] = j == l - 1 ? data[1][last] : Math.max(data[1][last], h[j + 1]);
                --last;
            }
        } else {
            int j = last - first - 1;
            h[j] = data[1][--last];
            while (last != first) {
                h[--j] = Math.max(data[1][first], h[j + 1]);
                --last;
            }
        }
    }
}

