/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;

public class AnnotationOptions {
    public boolean NEGATIVE_MODE = false;
    public int MAX_NO_H_IONS = 1;
    public int MAX_NO_NA_IONS = 0;
    public int MAX_NO_LI_IONS = 0;
    public int MAX_NO_K_IONS = 0;
    public int MAX_NO_CHARGES = 1;
    public boolean COMPUTE_EXCHANGES = false;
    public int MAX_EX_NA_IONS = 999;
    public int MAX_EX_LI_IONS = 999;
    public int MAX_EX_K_IONS = 999;
    public boolean DERIVE_FROM_PARENT = true;
    public double MASS_ACCURACY = 1.0;
    public static final String MASS_ACCURACY_DA = "Da";
    public static final String MASS_ACCURACY_PPM = "ppm";
    public String MASS_ACCURACY_UNIT = "Da";
    public boolean LOSS_H2O = false;
    public boolean LOSS_NH3 = false;
    public boolean LOSS_CO2 = false;
    public boolean GAIN_H2O = false;
    public boolean GAIN_NH3 = false;
    public boolean GAIN_CO2 = false;
    public boolean CLEAR_EXISTING_ANNOTATIONS = false;

    public boolean getPositiveMode() {
        return !this.NEGATIVE_MODE;
    }

    public void setPositiveMode(boolean f) {
        this.NEGATIVE_MODE = !f;
    }

    public boolean getNegativeMode() {
        return this.NEGATIVE_MODE;
    }

    public void setNegativeMode(boolean f) {
        this.NEGATIVE_MODE = f;
    }

    public int getMaxNoHIons() {
        return this.MAX_NO_H_IONS;
    }

    public void setMaxNoHIons(int i) {
        this.MAX_NO_H_IONS = i;
    }

    public int getMaxNoNaIons() {
        return this.MAX_NO_NA_IONS;
    }

    public void setMaxNoNaIons(int i) {
        this.MAX_NO_NA_IONS = i;
    }

    public int getMaxNoLiIons() {
        return this.MAX_NO_LI_IONS;
    }

    public void setMaxNoLiIons(int i) {
        this.MAX_NO_LI_IONS = i;
    }

    public int getMaxNoKIons() {
        return this.MAX_NO_K_IONS;
    }

    public void setMaxNoKIons(int i) {
        this.MAX_NO_K_IONS = i;
    }

    public int getMaxNoCharges() {
        return this.MAX_NO_CHARGES;
    }

    public void setMaxNoCharges(int i) {
        this.MAX_NO_CHARGES = i;
    }

    public boolean getComputeExchanges() {
        return this.COMPUTE_EXCHANGES;
    }

    public void setComputeExchanges(boolean f) {
        this.COMPUTE_EXCHANGES = f;
    }

    public int getMaxExNaIons() {
        return this.MAX_EX_NA_IONS;
    }

    public void setMaxExNaIons(int i) {
        this.MAX_EX_NA_IONS = i;
    }

    public int getMaxExLiIons() {
        return this.MAX_EX_LI_IONS;
    }

    public void setMaxExLiIons(int i) {
        this.MAX_EX_LI_IONS = i;
    }

    public int getMaxExKIons() {
        return this.MAX_EX_K_IONS;
    }

    public void setMaxExKIons(int i) {
        this.MAX_EX_K_IONS = i;
    }

    public boolean getDeriveFromParent() {
        return this.DERIVE_FROM_PARENT;
    }

    public void setDeriveFromParent(boolean f) {
        this.DERIVE_FROM_PARENT = f;
    }

    public double getMassAccuracy() {
        return this.MASS_ACCURACY;
    }

    public void setMassAccuracy(double v) {
        this.MASS_ACCURACY = v;
    }

    public String getMassAccuracyUnit() {
        return this.MASS_ACCURACY_UNIT;
    }

    public void setMassAccuracyUnit(String s) {
        this.MASS_ACCURACY_UNIT = s;
    }

    public AnnotationOptions derive(Glycan parent) {
        AnnotationOptions ret = new AnnotationOptions();
        IonCloud charges = parent.getMassOptions().ION_CLOUD;
        ret.NEGATIVE_MODE = charges.isNegative();
        ret.MAX_NO_H_IONS = Math.abs(charges.get("H"));
        ret.MAX_NO_NA_IONS = Math.abs(charges.get("Na"));
        ret.MAX_NO_LI_IONS = Math.abs(charges.get("Li"));
        ret.MAX_NO_K_IONS = Math.abs(charges.get("K"));
        ret.MAX_NO_CHARGES = charges.getNoCharges();
        IonCloud exchanges = parent.getMassOptions().NEUTRAL_EXCHANGES;
        ret.MAX_EX_NA_IONS = exchanges.get("Na");
        ret.MAX_EX_LI_IONS = exchanges.get("Li");
        ret.MAX_EX_K_IONS = exchanges.get("K");
        ret.COMPUTE_EXCHANGES = ret.MAX_EX_NA_IONS > 0 || ret.MAX_EX_LI_IONS > 0 || ret.MAX_EX_K_IONS > 0;
        ret.DERIVE_FROM_PARENT = false;
        ret.LOSS_H2O = this.LOSS_H2O;
        ret.LOSS_NH3 = this.LOSS_NH3;
        ret.LOSS_CO2 = this.LOSS_CO2;
        ret.GAIN_H2O = this.GAIN_H2O;
        ret.GAIN_NH3 = this.GAIN_NH3;
        ret.GAIN_CO2 = this.GAIN_CO2;
        ret.MASS_ACCURACY = this.MASS_ACCURACY;
        ret.MASS_ACCURACY_UNIT = this.MASS_ACCURACY_UNIT;
        ret.CLEAR_EXISTING_ANNOTATIONS = this.CLEAR_EXISTING_ANNOTATIONS;
        return ret;
    }

    public AnnotationOptions clone() {
        AnnotationOptions ret = new AnnotationOptions();
        ret.NEGATIVE_MODE = this.NEGATIVE_MODE;
        ret.MAX_NO_H_IONS = this.MAX_NO_H_IONS;
        ret.MAX_NO_NA_IONS = this.MAX_NO_NA_IONS;
        ret.MAX_NO_LI_IONS = this.MAX_NO_LI_IONS;
        ret.MAX_NO_K_IONS = this.MAX_NO_K_IONS;
        ret.MAX_NO_CHARGES = this.MAX_NO_CHARGES;
        ret.COMPUTE_EXCHANGES = this.COMPUTE_EXCHANGES;
        ret.MAX_EX_NA_IONS = this.MAX_EX_NA_IONS;
        ret.MAX_EX_LI_IONS = this.MAX_EX_LI_IONS;
        ret.MAX_EX_K_IONS = this.MAX_EX_K_IONS;
        ret.DERIVE_FROM_PARENT = this.DERIVE_FROM_PARENT;
        ret.LOSS_H2O = this.LOSS_H2O;
        ret.LOSS_NH3 = this.LOSS_NH3;
        ret.LOSS_CO2 = this.LOSS_CO2;
        ret.GAIN_H2O = this.GAIN_H2O;
        ret.GAIN_NH3 = this.GAIN_NH3;
        ret.GAIN_CO2 = this.GAIN_CO2;
        ret.MASS_ACCURACY = this.MASS_ACCURACY;
        ret.MASS_ACCURACY_UNIT = this.MASS_ACCURACY_UNIT;
        ret.CLEAR_EXISTING_ANNOTATIONS = this.CLEAR_EXISTING_ANNOTATIONS;
        return ret;
    }

    public void store(Configuration config) {
        config.put("AnnotationOptions", "mass_accuracy", this.MASS_ACCURACY);
        config.put("AnnotationOptions", "mass_accuracy_unit", this.MASS_ACCURACY_UNIT);
        config.put("AnnotationOptions", "negative_mode", this.NEGATIVE_MODE);
        config.put("AnnotationOptions", "max_no_h_ions", this.MAX_NO_H_IONS);
        config.put("AnnotationOptions", "max_no_na_ions", this.MAX_NO_NA_IONS);
        config.put("AnnotationOptions", "max_no_li_ions", this.MAX_NO_LI_IONS);
        config.put("AnnotationOptions", "max_no_k_ions", this.MAX_NO_K_IONS);
        config.put("AnnotationOptions", "max_no_charges", this.MAX_NO_CHARGES);
        config.put("AnnotationOptions", "compute_exchanges", this.COMPUTE_EXCHANGES);
        config.put("AnnotationOptions", "max_ex_na_ions", this.MAX_EX_NA_IONS);
        config.put("AnnotationOptions", "max_ex_li_ions", this.MAX_EX_LI_IONS);
        config.put("AnnotationOptions", "max_ex_k_ions", this.MAX_EX_K_IONS);
        config.put("AnnotationOptions", "derive_from_parent", this.DERIVE_FROM_PARENT);
        config.put("AnnotationOptions", "loss_h2o", this.LOSS_H2O);
        config.put("AnnotationOptions", "loss_nh3", this.LOSS_NH3);
        config.put("AnnotationOptions", "loss_co2", this.LOSS_CO2);
        config.put("AnnotationOptions", "gain_h2o", this.GAIN_H2O);
        config.put("AnnotationOptions", "gain_nh3", this.GAIN_NH3);
        config.put("AnnotationOptions", "gain_co2", this.GAIN_CO2);
        config.put("AnnotationOptions", "clear_existing_annotations", this.CLEAR_EXISTING_ANNOTATIONS);
    }

    public void retrieve(Configuration config) {
        this.MASS_ACCURACY = config.get("AnnotationOptions", "mass_accuracy", this.MASS_ACCURACY);
        this.MASS_ACCURACY_UNIT = config.get("AnnotationOptions", "mass_accuracy_unit", this.MASS_ACCURACY_UNIT);
        this.NEGATIVE_MODE = config.get("AnnotationOptions", "negative_mode", this.NEGATIVE_MODE);
        this.MAX_NO_H_IONS = config.get("AnnotationOptions", "max_no_h_ions", this.MAX_NO_H_IONS);
        this.MAX_NO_NA_IONS = config.get("AnnotationOptions", "max_no_na_ions", this.MAX_NO_NA_IONS);
        this.MAX_NO_LI_IONS = config.get("AnnotationOptions", "max_no_li_ions", this.MAX_NO_LI_IONS);
        this.MAX_NO_K_IONS = config.get("AnnotationOptions", "max_no_k_ions", this.MAX_NO_K_IONS);
        this.MAX_NO_CHARGES = config.get("AnnotationOptions", "max_no_charges", this.MAX_NO_CHARGES);
        this.COMPUTE_EXCHANGES = config.get("AnnotationOptions", "compute_exchanges", this.COMPUTE_EXCHANGES);
        this.MAX_EX_NA_IONS = config.get("AnnotationOptions", "max_ex_na_ions", this.MAX_EX_NA_IONS);
        this.MAX_EX_LI_IONS = config.get("AnnotationOptions", "max_ex_li_ions", this.MAX_EX_LI_IONS);
        this.MAX_EX_K_IONS = config.get("AnnotationOptions", "max_ex_k_ions", this.MAX_EX_K_IONS);
        this.DERIVE_FROM_PARENT = config.get("AnnotationOptions", "derive_from_parent", this.DERIVE_FROM_PARENT);
        this.LOSS_H2O = config.get("AnnotationOptions", "loss_h2o", this.LOSS_H2O);
        this.LOSS_NH3 = config.get("AnnotationOptions", "loss_nh3", this.LOSS_NH3);
        this.LOSS_CO2 = config.get("AnnotationOptions", "loss_co2", this.LOSS_CO2);
        this.GAIN_H2O = config.get("AnnotationOptions", "gain_h2o", this.GAIN_H2O);
        this.GAIN_NH3 = config.get("AnnotationOptions", "gain_nh3", this.GAIN_NH3);
        this.GAIN_CO2 = config.get("AnnotationOptions", "gain_co2", this.GAIN_CO2);
        this.CLEAR_EXISTING_ANNOTATIONS = config.get("AnnotationOptions", "clear_existing_annotations", this.CLEAR_EXISTING_ANNOTATIONS);
    }
}

