/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public abstract class ElementContentProvider
implements IElementContentProvider {
    protected static final Object[] EMPTY = new Object[0];

    @Override
    public void update(final IChildrenUpdate[] updates) {
        ElementContentProviderJob job = new ElementContentProviderJob(this, "Debug children update"){

            protected IStatus run(IProgressMonitor monitor) {
                int i = 0;
                while (i < updates.length) {
                    IChildrenUpdate update = updates[i];
                    if (!update.isCanceled()) {
                        this.retrieveChildren(update);
                    }
                    update.done();
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(this.getRule(updates));
        job.schedule();
    }

    @Override
    public void update(final IChildrenCountUpdate[] updates) {
        ElementContentProviderJob job = new ElementContentProviderJob(this, "Debug child count update"){

            protected IStatus run(IProgressMonitor monitor) {
                int i = 0;
                while (i < updates.length) {
                    IChildrenCountUpdate update = updates[i];
                    if (!update.isCanceled()) {
                        this.retrieveChildCount(update);
                    }
                    update.done();
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(this.getRule(updates));
        job.schedule();
    }

    protected void retrieveChildren(IChildrenUpdate update) {
        if (!update.isCanceled()) {
            IStatus status = Status.OK_STATUS;
            try {
                IPresentationContext context = update.getPresentationContext();
                if (this.supportsContext(context)) {
                    int offset = update.getOffset();
                    Object[] children = this.getChildren(update.getElement(), offset, update.getLength(), context, update);
                    if (!update.isCanceled() && children != null) {
                        int i = 0;
                        while (i < children.length) {
                            update.setChild(children[i], offset + i);
                            ++i;
                        }
                    }
                }
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            update.setStatus(status);
        }
    }

    protected void retrieveChildCount(IChildrenCountUpdate update) {
        if (!update.isCanceled()) {
            IStatus status = Status.OK_STATUS;
            try {
                IPresentationContext context = update.getPresentationContext();
                if (this.supportsContext(context)) {
                    int childCount = this.getChildCount(update.getElement(), context, update);
                    if (!update.isCanceled()) {
                        update.setChildCount(childCount);
                    }
                } else {
                    update.setChildCount(0);
                }
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            update.setStatus(status);
        }
    }

    protected abstract Object[] getChildren(Object var1, int var2, int var3, IPresentationContext var4, IViewerUpdate var5) throws CoreException;

    protected abstract int getChildCount(Object var1, IPresentationContext var2, IViewerUpdate var3) throws CoreException;

    protected boolean supportsContext(IPresentationContext context) {
        return this.supportsContextId(context.getId());
    }

    protected abstract boolean supportsContextId(String var1);

    protected Object[] getElements(Object[] elements, int index, int length) {
        int max = elements.length;
        if (index < max && index + length > max) {
            length = max - index;
        }
        if (index + length <= elements.length) {
            Object[] sub = new Object[length];
            System.arraycopy(elements, index, sub, 0, length);
            return sub;
        }
        return null;
    }

    @Override
    public void update(final IHasChildrenUpdate[] updates) {
        ElementContentProviderJob job = new ElementContentProviderJob(this, "Debug has children update"){

            protected IStatus run(IProgressMonitor monitor) {
                int i = 0;
                while (i < updates.length) {
                    IHasChildrenUpdate update = updates[i];
                    if (!update.isCanceled()) {
                        this.updateHasChildren(update);
                    }
                    update.done();
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(this.getRule(updates));
        job.schedule();
    }

    protected void updateHasChildren(IHasChildrenUpdate update) {
        if (!update.isCanceled()) {
            IStatus status = Status.OK_STATUS;
            try {
                IPresentationContext context = update.getPresentationContext();
                if (this.supportsContext(context)) {
                    boolean hasChildren = this.hasChildren(update.getElement(), context, update);
                    if (!update.isCanceled()) {
                        update.setHasChilren(hasChildren);
                    }
                } else {
                    update.setHasChilren(false);
                }
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            update.setStatus(status);
        }
    }

    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return this.getChildCount(element, context, monitor) > 0;
    }

    protected ISchedulingRule getRule(IChildrenCountUpdate[] updates) {
        return null;
    }

    protected ISchedulingRule getRule(IChildrenUpdate[] updates) {
        return null;
    }

    protected ISchedulingRule getRule(IHasChildrenUpdate[] updates) {
        return null;
    }

    protected abstract class ElementContentProviderJob
    extends Job {
        public ElementContentProviderJob(String name) {
            super(name);
            this.setSystem(true);
            this.setUser(false);
        }

        public boolean belongsTo(Object family) {
            return family == ElementContentProvider.class;
        }
    }
}

