/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationTemplate;

@XmlRootElement(name="massSpecCustomAnnotation")
public class MassSpecCustomAnnotation {
    private static final Logger logger = Logger.getLogger(MassSpecCustomAnnotation.class);
    public static final String VALUE_SEPERATOR = "!!!!!!";
    protected String sAnnotationName = null;
    protected String sDescription = null;
    protected Integer iMSLevel = null;
    protected Double dMassTolerance = null;
    protected Boolean bIsPPM = null;
    protected HashMap<Double, MassSpecCustomAnnotationPeak> listPeaks = null;
    protected String sAnnotatedPeakText = null;

    public MassSpecCustomAnnotation() {
    }

    public MassSpecCustomAnnotation(String sAnnotationName, String sDescription, Integer iMSLevel, Double dMassTolerance, Boolean bIsPPM) {
        this.sAnnotationName = sAnnotationName;
        this.sDescription = sDescription;
        this.iMSLevel = iMSLevel;
        this.dMassTolerance = dMassTolerance;
        this.bIsPPM = bIsPPM;
        this.listPeaks = new HashMap();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MassSpecCustomAnnotation)) {
            return false;
        }
        return ((MassSpecCustomAnnotation)obj).getAnnotationName().equals(this.getAnnotationName());
    }

    protected MassSpecCustomAnnotation getNewCustomAnnotationObject() {
        return new MassSpecCustomAnnotation();
    }

    public Object clone() {
        MassSpecCustomAnnotation msca = this.getNewCustomAnnotationObject();
        msca.setAnnotationName(this.getAnnotationName());
        msca.setDescription(this.getDescription());
        msca.setMSLevel(this.getMSLevel());
        msca.setMassTolerance(this.getMassTolerance());
        msca.setIsPPM(this.getIsPPM());
        msca.setAnnotatedPeaks(new HashMap<Double, MassSpecCustomAnnotationPeak>());
        for (Double dMz : this.getAnnotatedPeaks().keySet()) {
            MassSpecCustomAnnotationPeak peak = this.getAnnotatedPeaks().get(dMz);
            msca.getAnnotatedPeaks().put(dMz, peak);
        }
        return msca;
    }

    public boolean differsFrom(MassSpecCustomAnnotation that) {
        if (!this.getAnnotationName().equals(that.getAnnotationName())) {
            return true;
        }
        if (this.getIsPPM().booleanValue() && !that.getIsPPM().booleanValue() || !this.getIsPPM().booleanValue() && that.getIsPPM().booleanValue()) {
            return true;
        }
        if (!this.getDescription().equals(that.getDescription())) {
            return true;
        }
        if (Double.compare(this.getMassTolerance(), that.getMassTolerance()) != 0) {
            return true;
        }
        if (this.getMSLevel() != that.getMSLevel()) {
            return true;
        }
        if (this.getAnnotatedPeaks().size() != that.getAnnotatedPeaks().size()) {
            return true;
        }
        Collection<MassSpecCustomAnnotationPeak> thesePeaks = this.getAnnotatedPeaks().values();
        Collection<MassSpecCustomAnnotationPeak> thosePeaks = that.getAnnotatedPeaks().values();
        for (MassSpecCustomAnnotationPeak thisPeak : thesePeaks) {
            Iterator<MassSpecCustomAnnotationPeak> thatItr = thosePeaks.iterator();
            boolean bFound = false;
            while (thatItr.hasNext() && !bFound) {
                MassSpecCustomAnnotationPeak thatPeak = thatItr.next();
                if (!thisPeak.equals(thatPeak)) continue;
                bFound = true;
            }
            if (bFound) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getAnnotationName()) + ", num peaks: " + this.getAnnotatedPeaks().size();
    }

    public String getAnnotationName() {
        return this.sAnnotationName;
    }

    @XmlAttribute(name="annotationName")
    public void setAnnotationName(String sAnnotationName) {
        this.sAnnotationName = sAnnotationName;
    }

    public String getDescription() {
        return this.sDescription;
    }

    @XmlAttribute(name="description")
    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public Integer getMSLevel() {
        return this.iMSLevel;
    }

    @XmlAttribute(name="msLevel")
    public void setMSLevel(Integer iMSLevel) {
        this.iMSLevel = iMSLevel;
    }

    public Double getMassTolerance() {
        return this.dMassTolerance;
    }

    @XmlAttribute(name="massTolerance")
    public void setMassTolerance(Double dMassTolerance) {
        this.dMassTolerance = dMassTolerance;
    }

    public Boolean getIsPPM() {
        return this.bIsPPM;
    }

    @XmlAttribute(name="isPPM")
    public void setIsPPM(Boolean bIsPPM) {
        this.bIsPPM = bIsPPM;
    }

    public HashMap<Double, MassSpecCustomAnnotationPeak> getAnnotatedPeaks() {
        return this.listPeaks;
    }

    @XmlTransient
    public void setAnnotatedPeaks(HashMap<Double, MassSpecCustomAnnotationPeak> listPeaks) {
        this.listPeaks = listPeaks;
    }

    public String getsAnnotatedPeakText() {
        return this.sAnnotatedPeakText;
    }

    @XmlAttribute(name="annotatedPeakText")
    public void setsAnnotatedPeakText(String sAnnotatedPeakText) {
        this.sAnnotatedPeakText = sAnnotatedPeakText;
    }

    public void unmarshalAnnotatedPeakList() {
        HashMap<Double, MassSpecCustomAnnotationPeak> annotatedPeaks = MassSpecCustomAnnotation.unmarshalAnnotatedPeakText(this);
        this.setAnnotatedPeaks(annotatedPeaks);
    }

    public void updateAnnotatedPeakText() {
        String annotatedPeakText = MassSpecCustomAnnotation.createAnnotatedPeaksText(this.getAnnotatedPeaks());
        this.setsAnnotatedPeakText(annotatedPeakText);
    }

    public static String createAnnotatedPeaksText(MassSpecCustomAnnotationPeak peak) {
        String asText = XMLUtils.marshalObjectXML((Object)peak);
        return asText;
    }

    public static String createAnnotatedPeaksText(HashMap<Double, MassSpecCustomAnnotationPeak> annotatedPeaks) {
        StringBuilder sb = new StringBuilder();
        if (annotatedPeaks != null && !annotatedPeaks.isEmpty()) {
            for (Double dKey : annotatedPeaks.keySet()) {
                MassSpecCustomAnnotationPeak value = annotatedPeaks.get(dKey);
                if (value == null) continue;
                if (!sb.toString().equals("")) {
                    sb.append(VALUE_SEPERATOR);
                }
                String sXML = MassSpecCustomAnnotation.createAnnotatedPeaksText(value);
                sb.append(sXML);
            }
        }
        return sb.toString();
    }

    public static HashMap<Double, MassSpecCustomAnnotationPeak> unmarshalAnnotatedPeakText(MassSpecCustomAnnotation annotation) {
        HashMap<Double, MassSpecCustomAnnotationPeak> annotatedPeaks = new HashMap<Double, MassSpecCustomAnnotationPeak>();
        try {
            String[] annotations;
            if (annotation != null && annotation.getsAnnotatedPeakText() != null && !annotation.getsAnnotatedPeakText().equals("") && (annotations = annotation.getsAnnotatedPeakText().trim().split(VALUE_SEPERATOR)) != null && annotations.length > 0) {
                int i = 0;
                while (i < annotations.length) {
                    String annotXML = annotations[i];
                    MassSpecCustomAnnotationPeak peak = annotation.getPeakObjectFromXML(annotXML);
                    if (peak != null) {
                        annotatedPeaks.put(peak.getPeakMz(), peak);
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from xml files.", (Throwable)ex);
        }
        return annotatedPeaks;
    }

    public MassSpecCustomAnnotationPeak getPeakObjectFromXML(String peakXML) {
        MassSpecCustomAnnotationPeak peak = (MassSpecCustomAnnotationPeak)XMLUtils.getObjectFromXML((String)peakXML, MassSpecCustomAnnotationPeak.class);
        return peak;
    }

    public MassSpecCustomAnnotationTemplate getNewTemplate() {
        return new MassSpecCustomAnnotationTemplate();
    }

    public MassSpecCustomAnnotationTemplate copyToNewTemplate() {
        MassSpecCustomAnnotationTemplate template = this.getNewTemplate();
        template.setAnnotationName(this.getAnnotationName());
        template.setDescription(this.getDescription());
        template.setIsPPM(this.getIsPPM());
        template.setMassTolerance(this.getMassTolerance());
        template.setMSLevel(this.getMSLevel());
        template.setTemplatePeaks(this);
        return template;
    }
}

