/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.extquantfiles.process;

import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExternalQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.StandardQuantColumnInfo;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakMatch;
import org.grits.toolbox.ms.om.data.Peak;

public class StandardQuantDataProcessor
extends QuantFileProcessor {
    private static final Logger logger = Logger.getLogger(StandardQuantDataProcessor.class);
    protected QuantFileProcessor qfProcessor;

    public StandardQuantDataProcessor(QuantFileProcessor qfProcessor) {
        super(qfProcessor.getSettings());
        this.qfProcessor = qfProcessor;
    }

    public QuantFileProcessor getQuantFileProcessor() {
        return this.qfProcessor;
    }

    @Override
    public void loadExternalData() {
        this.qfProcessor.loadExternalData();
        this.setQuantPeakData(this.qfProcessor.getQuantPeakData());
    }

    @Override
    public boolean matchExternalPeaks(boolean _bRequirePrecursorPeak) {
        String sKey = this.qfProcessor.getKeyID();
        String sLabel = this.qfProcessor.getLabelAlias();
        String sIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel).getKey();
        boolean bReadStandards = super.matchExternalPeaks(false);
        boolean bUpdated = false;
        if (bReadStandards && this.qfProcessor.getSourcePeakListToMatch() != null) {
            for (Peak precursorPeak : this.qfProcessor.getSourcePeakListToMatch()) {
                QuantPeakMatch precursorQPM;
                if (_bRequirePrecursorPeak && !precursorPeak.getIsPrecursor() || (precursorQPM = this.qfProcessor.findExternalPeak(precursorPeak.getMz())) == null) continue;
                for (Peak standardPeak : this.getSourcePeakListToMatch()) {
                    if (!standardPeak.getDoubleProp().containsKey(sIntKey)) continue;
                    bUpdated |= this.setStandardQuantPeakData(precursorPeak, precursorQPM, standardPeak);
                }
            }
        }
        return bUpdated;
    }

    @Override
    public boolean removeExternalPeakMatches(boolean _bRequirePrecursorPeak) {
        boolean bUpdated = false;
        String sKey = this.qfProcessor.getKeyID();
        String sLabel = this.qfProcessor.getLabelAlias();
        String sIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel).getKey();
        if (this.qfProcessor.getSourcePeakListToMatch() != null) {
            for (Peak precursorPeak : this.qfProcessor.getSourcePeakListToMatch()) {
                QuantPeakMatch precursorQPM;
                if (_bRequirePrecursorPeak && !precursorPeak.getIsPrecursor() || (precursorQPM = this.qfProcessor.findExternalPeak(precursorPeak.getMz())) == null) continue;
                for (Peak standardPeak : this.getSourcePeakListToMatch()) {
                    if (!standardPeak.getDoubleProp().containsKey(sIntKey)) continue;
                    bUpdated |= this.setStandardQuantPeakData(precursorPeak, null, standardPeak);
                }
            }
        }
        return bUpdated;
    }

    @Override
    public void generateAllMatches() {
        this.qfProcessor.generateAllMatches();
    }

    @Override
    public boolean setExternalPeakData(Peak a_peak, QuantPeakMatch cPeak) {
        return this.qfProcessor.setExternalPeakData(a_peak, cPeak);
    }

    @Override
    public boolean matchesExternalQuantKey(String sExtQuantFullKey) {
        String theRest;
        int inx2;
        String sSourceKey = this.getKeyID();
        int inx = sExtQuantFullKey.indexOf(sSourceKey);
        if (inx >= 0 && (inx2 = (theRest = sExtQuantFullKey.substring(sSourceKey.length() + 1)).indexOf("_")) >= 0) {
            String sMz = theRest.substring(0, inx2);
            double dMz = 0.0;
            try {
                dMz = Double.parseDouble(sMz);
            }
            catch (NumberFormatException numberFormatException) {}
            int i = 0;
            while (i < this.getSourcePeakListToMatch().size()) {
                Peak peak = this.getSourcePeakListToMatch().get(i);
                if (peak.getMz() == dMz) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public boolean setStandardQuantPeakData(Peak a_peak, QuantPeakMatch precursorQPM, Peak dStdPeak) {
        String sSourceKey = this.qfProcessor.getKeyID();
        String sSourceLabel = this.qfProcessor.getLabelAlias();
        String sSourceIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(sSourceKey, sSourceLabel).getKey();
        String sSourceDeconvoIntKey = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(sSourceKey, sSourceLabel).getKey();
        String sSourceMzKey = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sSourceKey, sSourceLabel).getKey();
        if (!dStdPeak.getDoubleProp().containsKey(sSourceIntKey)) {
            return false;
        }
        Double dStdIntensity = (Double)dStdPeak.getDoubleProp().get(sSourceIntKey);
        Double dStdMz = (Double)dStdPeak.getDoubleProp().get(sSourceMzKey);
        Double dStdDeconvoIntensity = (Double)dStdPeak.getDoubleProp().get(sSourceDeconvoIntKey);
        Double dMz = dStdPeak.getMz();
        String sKey = String.valueOf(this.getKeyID()) + "-" + dMz.toString();
        String sLabel = dMz.toString();
        if (this.getLabelAlias() != null && !this.getLabelAlias().equals("")) {
            sLabel = String.valueOf(this.getLabelAlias()) + "-" + dMz.toString();
        }
        String sDeconvoIntKey = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(sKey, sLabel).getKey();
        String sIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel).getKey();
        String sMzKey = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel).getKey();
        String sCorrIntKey = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity(sKey, sLabel).getKey();
        String sRelIntKey = StandardQuantColumnInfo.getStandardQuantRelativeIntensity(sKey, sLabel).getKey();
        if (precursorQPM == null) {
            a_peak.getDoubleProp().remove(sDeconvoIntKey);
            a_peak.getDoubleProp().remove(sIntKey);
            a_peak.getDoubleProp().remove(sMzKey);
            a_peak.getDoubleProp().remove(sCorrIntKey);
            a_peak.getDoubleProp().remove(sRelIntKey);
            a_peak.getDoubleProp().remove(sSourceDeconvoIntKey);
            a_peak.getDoubleProp().remove(sSourceIntKey);
            a_peak.getDoubleProp().remove(sSourceMzKey);
            return true;
        }
        boolean bAddSource = true;
        if (a_peak.getDoubleProp().containsKey(sSourceDeconvoIntKey) && a_peak.getDoubleProp().containsKey(sSourceIntKey) && a_peak.getDoubleProp().containsKey(sSourceMzKey)) {
            Double dVal1 = (Double)a_peak.getDoubleProp().get(sSourceDeconvoIntKey);
            Double dVal2 = precursorQPM.getParent().getSumIntensity();
            bAddSource = false;
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAddSource = true;
            }
            dVal1 = (Double)a_peak.getDoubleProp().get(sSourceIntKey);
            dVal2 = precursorQPM.getIntensitySum();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAddSource = true;
            }
            dVal1 = (Double)a_peak.getDoubleProp().get(sSourceMzKey);
            dVal2 = precursorQPM.getMzMostAbundant();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAddSource = true;
            }
        }
        if (bAddSource) {
            a_peak.addDoubleProp(sSourceDeconvoIntKey, precursorQPM.getParent().getSumIntensity());
            a_peak.addDoubleProp(sSourceIntKey, precursorQPM.getIntensitySum());
            a_peak.addDoubleProp(sSourceMzKey, precursorQPM.getMzMostAbundant());
        }
        boolean bAddStd = true;
        if (a_peak.getDoubleProp().containsKey(sDeconvoIntKey) && a_peak.getDoubleProp().containsKey(sIntKey) && a_peak.getDoubleProp().containsKey(sMzKey)) {
            bAddStd = false;
            Double dVal1 = (Double)a_peak.getDoubleProp().get(sSourceDeconvoIntKey);
            Double dVal2 = precursorQPM.getParent().getSumIntensity();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAddStd = true;
            }
            dVal1 = (Double)a_peak.getDoubleProp().get(sSourceIntKey);
            dVal2 = precursorQPM.getIntensitySum();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAddStd = true;
            }
            dVal1 = (Double)a_peak.getDoubleProp().get(sSourceMzKey);
            dVal2 = precursorQPM.getMzMostAbundant();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAddStd = true;
            }
        }
        if (bAddStd) {
            a_peak.addDoubleProp(sDeconvoIntKey, dStdDeconvoIntensity);
            a_peak.addDoubleProp(sIntKey, dStdIntensity);
            a_peak.addDoubleProp(sMzKey, dStdMz);
        }
        return bAddSource || bAddStd;
    }
}

