/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.Collections;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.util.comparater.GlyCoModificationComparater;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.MAPAnalyzer;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.SkeletonCodeToStereo;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneUnknown_TBD;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor_TBD;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class BackboneToNode {
    public Node start(Backbone _backbone) throws GlycanException, WURCSFormatException, ConverterExchangeException {
        Monosaccharide ret = new Monosaccharide();
        String skeletonCode = _backbone.getSkeletonCode();
        ret.setSuperClass(SuperClass.forSize(_backbone.getLength()));
        char anomericstate = _backbone.getAnomericSymbol();
        AnomericStateDescriptor enumAnom = AnomericStateDescriptor.forAnomericState(this.checkAnomericState(skeletonCode, anomericstate));
        ret.setAnomer(enumAnom);
        int anomericposition = this.checkAnomericPosition(_backbone);
        ret.setAnomericPosition(anomericposition);
        SkeletonCodeToStereo sc2s = new SkeletonCodeToStereo();
        ret.setStereos(sc2s.start(_backbone));
        this.extractRingPosition(_backbone, ret);
        ret.setModification(this.extractModification(ret, _backbone));
        this.extractSubstituent(_backbone, ret);
        return ret;
    }

    private ArrayList<GlyCoModification> extractModification(Monosaccharide _mono, Backbone _backbone) throws GlycanException {
        ArrayList<GlyCoModification> ret = new ArrayList<GlyCoModification>();
        String skeletonCode = _backbone.getSkeletonCode();
        int i = 0;
        while (i < skeletonCode.length()) {
            char carbon = skeletonCode.charAt(i);
            ModificationTemplate modT = ModificationTemplate.forCarbon(carbon);
            if (i != 0) {
                if (carbon == 'o') {
                    modT = ModificationTemplate.KETONE;
                }
                if (carbon == 'O' || carbon == 'a') {
                    modT = ModificationTemplate.KETONE_U;
                }
            }
            if (i == _mono.getSuperClass().getSize() - 1 && carbon == 'A') {
                modT = ModificationTemplate.URONICACID;
            }
            if (modT != null) {
                GlyCoModification mod = new GlyCoModification(modT, i + 1);
                ret.add(mod);
                if (i != 1 && i + 1 != _mono.getSuperClass().getSize() && (modT.equals((Object)ModificationTemplate.KETONE) || modT.equals((Object)ModificationTemplate.KETONE_U))) {
                    boolean haveMod = false;
                    for (GlyCoModification gMod : ret) {
                        if (gMod.getPositionOne() != 1) continue;
                        haveMod = true;
                    }
                    if (!haveMod) {
                        mod = new GlyCoModification(modT, 1);
                        ret.add(mod);
                    }
                }
            }
            ++i;
        }
        for (WURCSEdge we : _backbone.getChildEdges()) {
            Modification mod = we.getModification();
            if (mod.isRing() || mod.isGlycosidic() || mod instanceof ModificationRepeat || mod.getParentEdges().size() != 1 || !mod.getMAPCode().equals("*")) continue;
            ModificationTemplate modT = ModificationTemplate.DEOXY;
            GlyCoModification gmod = new GlyCoModification(modT, 0);
            ret.add(gmod);
        }
        Collections.sort(ret, new GlyCoModificationComparater());
        return ret;
    }

    private Monosaccharide extractSubstituent(Backbone _backbone, Monosaccharide _mono) throws GlycanException, ConverterExchangeException, WURCSFormatException {
        ArrayList<Modification> tempMods = new ArrayList<Modification>();
        for (WURCSEdge we : _backbone.getChildEdges()) {
            Modification mod = we.getModification();
            if (this.isRingPosition(mod, _mono) || mod.isGlycosidic() || mod instanceof ModificationRepeat || mod.getMAPCode().equals("*")) continue;
            if (mod.getParentEdges().size() == 1) {
                _mono = this.appendSubstituent(_mono, this.ModificationToSubstituent(_backbone, mod));
            }
            if (mod.getParentEdges().size() == 2) {
                if (tempMods.contains(mod)) continue;
                _mono = this.appendSubstituent(_mono, this.ModificationToCrossLinkedSubstituent(mod));
                tempMods.add(mod);
            }
            if (mod.getParentEdges().size() <= 2 || mod instanceof ModificationAlternative) continue;
            throw new GlycanException(String.valueOf(mod.getMAPCode()) + " have more than two anchors.");
        }
        return _mono;
    }

    private Substituent ModificationToSubstituent(Backbone _backbone, Modification _mod) throws ConverterExchangeException, GlycanException, WURCSFormatException {
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_mod.getMAPCode());
        BaseSubstituentTemplate bsubT = mapAnalyze.getSingleTemplate();
        Linkage lin = new Linkage();
        if (bsubT == null) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        if (bsubT.getIUPACnotation().equals("")) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        for (WURCSEdge we : _mod.getParentEdges()) {
            for (LinkagePosition lp : we.getLinkages()) {
                lin.addParentLinkage(lp.getBackbonePosition());
                lin.addChildLinkage(lp.getModificationPosition());
                lin.setProbabilityUpper(lp.getProbabilityUpper());
                lin.setProbabilityLower(lp.getProbabilityLower());
            }
        }
        Substituent ret = new Substituent(bsubT, lin);
        ret.setHeadAtom(mapAnalyze.getHeadAtom());
        if (_backbone instanceof BackboneUnknown_TBD) {
            return ret;
        }
        if (lin.getParentLinkages().size() == 1 && !lin.getParentLinkages().contains(-1)) {
            int pos = lin.getParentLinkages().get(0);
            if (((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDesctriptor().equals(CarbonDescriptor_TBD.SS3_CHIRAL_X_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDesctriptor().equals(CarbonDescriptor_TBD.SS3_CHIRAL_R_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDesctriptor().equals(CarbonDescriptor_TBD.SS3_CHIRAL_r_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDesctriptor().equals(CarbonDescriptor_TBD.SS3_CHIRAL_S_U) || ((BackboneCarbon)_backbone.getBackboneCarbons().get(pos - 1)).getDesctriptor().equals(CarbonDescriptor_TBD.SS3_CHIRAL_s_U)) {
                ret.setHeadAtom("C");
            }
        }
        return ret;
    }

    private Substituent ModificationToCrossLinkedSubstituent(Modification _mod) throws ConverterExchangeException, GlycanException, WURCSFormatException {
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_mod.getMAPCode().equals("") ? "*o" : _mod.getMAPCode());
        BaseCrossLinkedTemplate subT = mapAnalyze.getCrossTemplate();
        Linkage first = new Linkage();
        Linkage second = new Linkage();
        if (subT == null) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        if (subT.getIUPACnotation().equals("")) {
            throw new ConverterExchangeException("This substituent could not support: " + _mod.getMAPCode());
        }
        for (WURCSEdge we : _mod.getParentEdges()) {
            if (_mod.getParentEdges().size() - 1 != _mod.getParentEdges().indexOf(we)) {
                for (LinkagePosition lp : we.getLinkages()) {
                    first.addParentLinkage(lp.getBackbonePosition());
                    first.addChildLinkage(lp.getModificationPosition());
                    first.setProbabilityUpper(lp.getProbabilityUpper());
                    first.setProbabilityLower(lp.getProbabilityLower());
                }
                continue;
            }
            for (LinkagePosition lp : we.getLinkages()) {
                second.addParentLinkage(lp.getBackbonePosition());
                second.addChildLinkage(lp.getModificationPosition());
                second.setProbabilityUpper(lp.getProbabilityUpper());
                second.setProbabilityLower(lp.getProbabilityLower());
            }
        }
        Substituent ret = new Substituent(subT, first, second);
        ret.setHeadAtom(mapAnalyze.getHeadAtom());
        ret.setTailAtom(mapAnalyze.getTailAtom());
        return ret;
    }

    private char checkAnomericState(String _skeletonCode, char _anomericstate) {
        if (_anomericstate == 'o') {
            if (_skeletonCode.indexOf("o") == 0 || _skeletonCode.indexOf("O") == 1) {
                return 'o';
            }
            if (_skeletonCode.indexOf("u") == 0 || _skeletonCode.indexOf("U") == 1) {
                return '?';
            }
        }
        return _anomericstate;
    }

    private Monosaccharide appendSubstituent(Node _node, Node _substituent) throws GlycanException {
        Edge first = new Edge();
        first.setSubstituent(_substituent);
        first.setParent(_node);
        _node.addChildEdge(first);
        _substituent.addParentEdge(first);
        Linkage linkage = new Linkage();
        for (Integer pos : ((Substituent)_substituent).getFirstPosition().getChildLinkages()) {
            linkage.addChildLinkage(pos);
        }
        for (Integer pos : ((Substituent)_substituent).getFirstPosition().getParentLinkages()) {
            linkage.addParentLinkage(pos);
        }
        first.addGlycosidicLinkage(linkage);
        return (Monosaccharide)_node;
    }

    private int checkAnomericPosition(Backbone _backbone) {
        int anomericPosition = _backbone.getAnomericPosition();
        String skeletonCode = _backbone.getSkeletonCode();
        if (skeletonCode.indexOf("u") == 0 || skeletonCode.indexOf("U") == 1) {
            anomericPosition = -1;
        }
        return anomericPosition;
    }

    private Monosaccharide extractRingPosition(Backbone _backbone, Monosaccharide _mono) throws GlycanException {
        int anomericPos = _backbone.getAnomericPosition();
        ArrayList<Integer> ring = new ArrayList<Integer>();
        int start = -1;
        for (WURCSEdge cwe : _backbone.getChildEdges()) {
            Modification mod = cwe.getModification();
            if (!mod.isRing()) continue;
            for (LinkagePosition lp : cwe.getLinkages()) {
                if (anomericPos == lp.getBackbonePosition()) {
                    start = lp.getBackbonePosition();
                    continue;
                }
                ring.add(lp.getBackbonePosition());
            }
        }
        if (ring.isEmpty()) {
            _mono.setRing(start, -1);
        } else {
            Collections.sort(ring);
            _mono.setRing(start, (Integer)ring.get(0));
        }
        return _mono;
    }

    private boolean isRingPosition(Modification _mod, Monosaccharide _mono) {
        if (_mod.getParentEdges().size() != 2) {
            return false;
        }
        int start = ((LinkagePosition)((WURCSEdge)_mod.getParentEdges().get(0)).getLinkages().get(0)).getBackbonePosition();
        int end = ((LinkagePosition)((WURCSEdge)_mod.getParentEdges().get(1)).getLinkages().get(0)).getBackbonePosition();
        return _mono.getRingStart() == start && _mono.getRingEnd() == end;
    }
}

