/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONLinkageParser;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.json.JSONObject;

public class GCJSONFragmentsParser {
    private HashMap<String, Node> nodeIndex;
    private GCJSONLinkageParser gclinParser;

    public GCJSONFragmentsParser(HashMap<String, Node> _nodeIndex) {
        this.nodeIndex = _nodeIndex;
        this.gclinParser = new GCJSONLinkageParser();
    }

    public GlycanUndefinedUnit parseFragments(JSONObject _fragment, Node _root) throws GlycanException {
        GlycanUndefinedUnit ret = new GlycanUndefinedUnit();
        Linkage lin = new Linkage();
        Iterator iterator = _fragment.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "LinkageType": {
                    lin = this.gclinParser.extractLinkageType(_fragment.getJSONObject("LinkageType"), lin);
                    break;
                }
                case "Position": {
                    lin = this.gclinParser.extractPosition(_fragment.getJSONObject("Position"), lin);
                    break;
                }
                case "Probability": {
                    lin = this.gclinParser.extractProbability(_fragment.getJSONObject("Probability"), lin);
                }
            }
        }
        if (!this.isComposition(_fragment)) {
            Edge edge = new Edge();
            edge.addGlycosidicLinkage(lin);
            edge.setChild(_root);
            _root.addParentEdge(edge);
            ret.setConnection(edge);
        }
        ret.addNode(_root);
        for (Object id : _fragment.getJSONArray("ParentNodeID")) {
            ret.addParentNode(this.nodeIndex.get(id.toString()));
        }
        return ret;
    }

    public ArrayList<GlycanUndefinedUnit> parseSubFragments(JSONObject _subFragments) throws GlycanException {
        ArrayList<GlycanUndefinedUnit> undes = new ArrayList<GlycanUndefinedUnit>();
        SubstituentUtility subUtil = new SubstituentUtility();
        for (String unit : _subFragments.keySet()) {
            JSONObject subUnit = _subFragments.getJSONObject(unit);
            GlycanUndefinedUnit und = new GlycanUndefinedUnit();
            Linkage lin = new Linkage();
            Iterator iterator = subUnit.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "LinkageType": {
                        lin = this.gclinParser.extractLinkageType(subUnit.getJSONObject("LinkageType"), lin);
                        break;
                    }
                    case "Position": {
                        lin = this.gclinParser.extractPosition(subUnit.getJSONObject("Position"), lin);
                        break;
                    }
                    case "Probability": {
                        lin = this.gclinParser.extractProbability(subUnit.getJSONObject("Probability"), lin);
                    }
                }
            }
            Substituent root = new Substituent(this.parseSubstituentTemplate(subUnit.getString("Notation")), lin);
            Edge edge = new Edge();
            edge.addGlycosidicLinkage(lin);
            edge.setSubstituent(root);
            root.addParentEdge(edge);
            und.setConnection(edge);
            und.addNode(root);
            for (Object id : subUnit.getJSONArray("ParentNodeID")) {
                und.addParentNode(this.nodeIndex.get(id.toString()));
            }
            undes.add(und);
        }
        return undes;
    }

    public SubstituentTemplate parseSubstituentTemplate(String _notation) {
        SubstituentTemplate[] substituentTemplateArray = SubstituentTemplate.values();
        int n = substituentTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubstituentTemplate value = substituentTemplateArray[n2];
            if (_notation.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    private boolean isComposition(JSONObject _fragments) {
        return _fragments.length() == 2;
    }
}

